/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.join;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.join.ComposableInputFormat;
import org.apache.hadoop.mapreduce.lib.join.ComposableRecordReader;
import org.apache.hadoop.mapreduce.lib.join.CompositeInputSplit;
import org.apache.hadoop.mapreduce.lib.join.CompositeRecordReader;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Parser {
    private static Token reduce(Stack<Token> st, Configuration conf) throws IOException {
        LinkedList<Token> args = new LinkedList<Token>();
        while (!st.isEmpty() && !TType.LPAREN.equals((Object)st.peek().getType())) {
            args.addFirst(st.pop());
        }
        if (st.isEmpty()) {
            throw new IOException("Unmatched ')'");
        }
        st.pop();
        if (st.isEmpty() || !TType.IDENT.equals((Object)st.peek().getType())) {
            throw new IOException("Identifier expected");
        }
        Node n = Node.forIdent(st.pop().getStr());
        n.parse(args, conf);
        return new NodeToken(n);
    }

    static Node parse(String expr, Configuration conf) throws IOException {
        Token tok;
        if (null == expr) {
            throw new IOException("Expression is null");
        }
        Class cmpcl = conf.getClass("mapreduce.join.keycomparator", null, WritableComparator.class);
        Lexer lex = new Lexer(expr);
        Stack<Token> st = new Stack<Token>();
        while ((tok = lex.next()) != null) {
            if (TType.RPAREN.equals((Object)tok.getType())) {
                st.push(Parser.reduce(st, conf));
                continue;
            }
            st.push(tok);
        }
        if (st.size() == 1 && TType.CIF.equals((Object)((Token)st.peek()).getType())) {
            Node ret = st.pop().getNode();
            if (cmpcl != null) {
                ret.setKeyComparator(cmpcl);
            }
            return ret;
        }
        throw new IOException("Missing ')'");
    }

    static class CNode
    extends Node {
        private static final Class<?>[] cstrSig = new Class[]{Integer.TYPE, Configuration.class, Integer.TYPE, Class.class};
        private ArrayList<Node> kids = new ArrayList();

        static void addIdentifier(String ident, Class<? extends ComposableRecordReader> cl) throws NoSuchMethodException {
            Node.addIdentifier(ident, cstrSig, CNode.class, cl);
        }

        public CNode(String ident) {
            super(ident);
        }

        @Override
        public void setKeyComparator(Class<? extends WritableComparator> cmpcl) {
            super.setKeyComparator(cmpcl);
            for (Node n : this.kids) {
                n.setKeyComparator(cmpcl);
            }
        }

        @Override
        public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
            ArrayList<List<InputSplit>> splits = new ArrayList<List<InputSplit>>(this.kids.size());
            for (int i = 0; i < this.kids.size(); ++i) {
                List<InputSplit> tmp = this.kids.get(i).getSplits(job);
                if (null == tmp) {
                    throw new IOException("Error gathering splits from child RReader");
                }
                if (i > 0 && ((List)splits.get(i - 1)).size() != tmp.size()) {
                    throw new IOException("Inconsistent split cardinality from child " + i + " (" + ((List)splits.get(i - 1)).size() + "/" + tmp.size() + ")");
                }
                splits.add(i, tmp);
            }
            int size = ((List)splits.get(0)).size();
            ArrayList<InputSplit> ret = new ArrayList<InputSplit>();
            for (int i = 0; i < size; ++i) {
                CompositeInputSplit split = new CompositeInputSplit(splits.size());
                for (int j = 0; j < splits.size(); ++j) {
                    split.add((InputSplit)((List)splits.get(j)).get(i));
                }
                ret.add(split);
            }
            return ret;
        }

        @Override
        public ComposableRecordReader createRecordReader(InputSplit split, TaskAttemptContext taskContext) throws IOException, InterruptedException {
            if (!(split instanceof CompositeInputSplit)) {
                throw new IOException("Invalid split type:" + split.getClass().getName());
            }
            CompositeInputSplit spl = (CompositeInputSplit)split;
            int capacity = this.kids.size();
            CompositeRecordReader ret = null;
            try {
                if (!rrCstrMap.containsKey(this.ident)) {
                    throw new IOException("No RecordReader for " + this.ident);
                }
                ret = (CompositeRecordReader)((Constructor)rrCstrMap.get(this.ident)).newInstance(this.id, taskContext.getConfiguration(), capacity, this.cmpcl);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
            for (int i = 0; i < capacity; ++i) {
                ret.add(this.kids.get(i).createRecordReader(spl.get(i), taskContext));
            }
            return ret;
        }

        @Override
        public void parse(List<Token> args, Configuration conf) throws IOException {
            ListIterator<Token> i = args.listIterator();
            while (i.hasNext()) {
                Token t = i.next();
                t.getNode().setID(i.previousIndex() >> 1);
                this.kids.add(t.getNode());
                if (!i.hasNext() || TType.COMMA.equals((Object)i.next().getType())) continue;
                throw new IOException("Expected ','");
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.ident + "(");
            for (Node n : this.kids) {
                sb.append(n.toString() + ",");
            }
            sb.setCharAt(sb.length() - 1, ')');
            return sb.toString();
        }
    }

    static class WNode
    extends Node {
        private static final Class<?>[] cstrSig = new Class[]{Integer.TYPE, RecordReader.class, Class.class};
        private String indir;
        private InputFormat<?, ?> inf;

        static void addIdentifier(String ident, Class<? extends ComposableRecordReader> cl) throws NoSuchMethodException {
            Node.addIdentifier(ident, cstrSig, WNode.class, cl);
        }

        public WNode(String ident) {
            super(ident);
        }

        @Override
        public void parse(List<Token> ll, Configuration conf) throws IOException {
            Token t;
            StringBuilder sb = new StringBuilder();
            Iterator<Token> i = ll.iterator();
            while (i.hasNext()) {
                t = i.next();
                if (TType.COMMA.equals((Object)t.getType())) {
                    try {
                        this.inf = (InputFormat)ReflectionUtils.newInstance((Class)conf.getClassByName(sb.toString()), (Configuration)conf);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException(e);
                    }
                }
                sb.append(t.getStr());
            }
            if (!i.hasNext()) {
                throw new IOException("Parse error");
            }
            t = i.next();
            if (!TType.QUOT.equals((Object)t.getType())) {
                throw new IOException("Expected quoted string");
            }
            this.indir = t.getStr();
        }

        private Configuration getConf(Configuration jconf) throws IOException {
            Job job = new Job(jconf);
            FileInputFormat.setInputPaths(job, this.indir);
            return job.getConfiguration();
        }

        @Override
        public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
            return this.inf.getSplits(new JobContextImpl(this.getConf(context.getConfiguration()), context.getJobID()));
        }

        @Override
        public ComposableRecordReader<?, ?> createRecordReader(InputSplit split, TaskAttemptContext taskContext) throws IOException, InterruptedException {
            try {
                if (!rrCstrMap.containsKey(this.ident)) {
                    throw new IOException("No RecordReader for " + this.ident);
                }
                Configuration conf = this.getConf(taskContext.getConfiguration());
                TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, TaskAttemptID.forName(conf.get("mapreduce.task.attempt.id")));
                return (ComposableRecordReader)((Constructor)rrCstrMap.get(this.ident)).newInstance(this.id, this.inf.createRecordReader(split, context), this.cmpcl);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
        }

        public String toString() {
            return this.ident + "(" + this.inf.getClass().getName() + ",\"" + this.indir + "\")";
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static abstract class Node
    extends ComposableInputFormat {
        private static final Class<?>[] ncstrSig = new Class[]{String.class};
        private static final Map<String, Constructor<? extends Node>> nodeCstrMap = new HashMap<String, Constructor<? extends Node>>();
        protected static final Map<String, Constructor<? extends ComposableRecordReader>> rrCstrMap = new HashMap<String, Constructor<? extends ComposableRecordReader>>();
        protected int id = -1;
        protected String ident;
        protected Class<? extends WritableComparator> cmpcl;

        static Node forIdent(String ident) throws IOException {
            try {
                if (!nodeCstrMap.containsKey(ident)) {
                    throw new IOException("No nodetype for " + ident);
                }
                return nodeCstrMap.get(ident).newInstance(ident);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
        }

        protected static void addIdentifier(String ident, Class<?>[] mcstrSig, Class<? extends Node> nodetype, Class<? extends ComposableRecordReader> cl) throws NoSuchMethodException {
            Constructor<? extends Node> ncstr = nodetype.getDeclaredConstructor(ncstrSig);
            ncstr.setAccessible(true);
            nodeCstrMap.put(ident, ncstr);
            Constructor<? extends ComposableRecordReader> mcstr = cl.getDeclaredConstructor(mcstrSig);
            mcstr.setAccessible(true);
            rrCstrMap.put(ident, mcstr);
        }

        protected Node(String ident) {
            this.ident = ident;
        }

        protected void setID(int id) {
            this.id = id;
        }

        protected void setKeyComparator(Class<? extends WritableComparator> cmpcl) {
            this.cmpcl = cmpcl;
        }

        abstract void parse(List<Token> var1, Configuration var2) throws IOException;
    }

    private static class Lexer {
        private StreamTokenizer tok;

        Lexer(String s) {
            this.tok = new StreamTokenizer(new CharArrayReader(s.toCharArray()));
            this.tok.quoteChar(34);
            this.tok.parseNumbers();
            this.tok.ordinaryChar(44);
            this.tok.ordinaryChar(40);
            this.tok.ordinaryChar(41);
            this.tok.wordChars(36, 36);
            this.tok.wordChars(95, 95);
        }

        Token next() throws IOException {
            int type = this.tok.nextToken();
            switch (type) {
                case -1: 
                case 10: {
                    return null;
                }
                case -2: {
                    return new NumToken(this.tok.nval);
                }
                case -3: {
                    return new StrToken(TType.IDENT, this.tok.sval);
                }
                case 34: {
                    return new StrToken(TType.QUOT, this.tok.sval);
                }
            }
            switch (type) {
                case 44: {
                    return new Token(TType.COMMA);
                }
                case 40: {
                    return new Token(TType.LPAREN);
                }
                case 41: {
                    return new Token(TType.RPAREN);
                }
            }
            throw new IOException("Unexpected: " + type);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class StrToken
    extends Token {
        private String str;

        public StrToken(TType type, String str) {
            super(type);
            this.str = str;
        }

        @Override
        public String getStr() {
            return this.str;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class NodeToken
    extends Token {
        private Node node;

        NodeToken(Node node) {
            super(TType.CIF);
            this.node = node;
        }

        @Override
        public Node getNode() {
            return this.node;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class NumToken
    extends Token {
        private double num;

        public NumToken(double num) {
            super(TType.NUM);
            this.num = num;
        }

        @Override
        public double getNum() {
            return this.num;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class Token {
        private TType type;

        Token(TType type) {
            this.type = type;
        }

        public TType getType() {
            return this.type;
        }

        public Node getNode() throws IOException {
            throw new IOException("Expected nodetype");
        }

        public double getNum() throws IOException {
            throw new IOException("Expected numtype");
        }

        public String getStr() throws IOException {
            throw new IOException("Expected strtype");
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum TType {
        CIF,
        IDENT,
        COMMA,
        LPAREN,
        RPAREN,
        QUOT,
        NUM;

    }
}

