/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security.token;

import java.net.URI;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.security.TokenStorage;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegationTokenRenewal {
    private static final Log LOG = LogFactory.getLog(DelegationTokenRenewal.class);
    public static final String SCHEME = "hdfs";
    private static Timer renewalTimer = new Timer(true);
    private static Map<JobID, List<DelegationTokenToRenew>> delegationTokens = Collections.synchronizedMap(new HashMap());
    private static final Text kindHdfs = DelegationTokenIdentifier.HDFS_DELEGATION_KIND;

    private static void addTokenToMap(DelegationTokenToRenew t) {
        JobID jobId = t.jobId;
        List<DelegationTokenToRenew> l = delegationTokens.get(jobId);
        if (l == null) {
            l = new ArrayList<DelegationTokenToRenew>();
            delegationTokens.put(jobId, l);
        }
        l.add(t);
    }

    public static synchronized void registerDelegationTokensForRenewal(JobID jobId, TokenStorage ts, Configuration conf) {
        if (ts == null) {
            return;
        }
        Collection tokens = ts.getAllTokens();
        long now = System.currentTimeMillis();
        for (Token t : tokens) {
            if (!t.getKind().equals((Object)kindHdfs)) continue;
            Token dt = t;
            DelegationTokenToRenew dtr = new DelegationTokenToRenew(jobId, (Token<DelegationTokenIdentifier>)dt, conf, now);
            DelegationTokenRenewal.addTokenToMap(dtr);
            DelegationTokenRenewal.setTimerForTokenRenewal(dtr, true);
            LOG.info((Object)("registering token for renewal for service =" + dt.getService() + " and jobID = " + jobId));
        }
    }

    private static long renewDelegationToken(DelegationTokenToRenew dttr) throws Exception {
        long newExpirationDate = System.currentTimeMillis() + 3600000L;
        Token<DelegationTokenIdentifier> token = dttr.token;
        Configuration conf = dttr.conf;
        if (token.getKind().equals((Object)kindHdfs)) {
            try {
                DistributedFileSystem dfs = DelegationTokenRenewal.getDFSForToken(token, conf);
                newExpirationDate = dfs.renewDelegationToken(token);
            }
            catch (SecretManager.InvalidToken ite) {
                LOG.warn((Object)"token canceled - not scheduling for renew");
                DelegationTokenRenewal.removeFailedDelegationToken(dttr);
                throw new Exception("failed to renew token", ite);
            }
            catch (AccessControlException ace) {
                LOG.warn((Object)"token canceled - not scheduling for renew");
                DelegationTokenRenewal.removeFailedDelegationToken(dttr);
                throw new Exception("failed to renew token", ace);
            }
            catch (Exception ioe) {
                LOG.warn((Object)("failed to renew token:" + token), (Throwable)ioe);
            }
        } else {
            throw new Exception("unknown token type to renew+" + token.getKind());
        }
        return newExpirationDate;
    }

    private static DistributedFileSystem getDFSForToken(Token<DelegationTokenIdentifier> token, Configuration conf) throws Exception {
        DistributedFileSystem dfs = null;
        try {
            URI uri = new URI("hdfs://" + token.getService().toString());
            dfs = (DistributedFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to create a dfs to renew for:" + token.getService()), (Throwable)e);
            throw e;
        }
        return dfs;
    }

    private static void setTimerForTokenRenewal(DelegationTokenToRenew token, boolean firstTime) {
        long renewIn;
        long now = System.currentTimeMillis();
        if (firstTime) {
            renewIn = now;
        } else {
            long expiresIn = token.expirationDate - now;
            renewIn = now + expiresIn - expiresIn / 10L;
        }
        try {
            RenewalTimerTask tTask = new RenewalTimerTask(token);
            token.setTimerTask(tTask);
            renewalTimer.schedule(token.timerTask, new Date(renewIn));
        }
        catch (Exception e) {
            LOG.warn((Object)"failed to schedule a task, token will not renew more", (Throwable)e);
        }
    }

    public static void close() {
        renewalTimer.cancel();
        delegationTokens.clear();
    }

    private static void cancelToken(DelegationTokenToRenew t) {
        Token<DelegationTokenIdentifier> token = t.token;
        Configuration conf = t.conf;
        if (token.getKind().equals((Object)kindHdfs)) {
            try {
                DistributedFileSystem dfs = DelegationTokenRenewal.getDFSForToken(token, conf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("canceling token " + token.getService() + " for dfs=" + dfs));
                }
                dfs.cancelDelegationToken(token);
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to cancel " + token), (Throwable)e);
            }
        }
    }

    private static void removeFailedDelegationToken(DelegationTokenToRenew t) {
        JobID jobId = t.jobId;
        List<DelegationTokenToRenew> l = delegationTokens.get(jobId);
        if (l == null) {
            return;
        }
        Iterator<DelegationTokenToRenew> it = l.iterator();
        while (it.hasNext()) {
            DelegationTokenToRenew dttr = it.next();
            if (dttr != t) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("removing failed delegation token for jobid=" + jobId + ";t=" + dttr.token.getService()));
            }
            if (dttr.timerTask != null) {
                dttr.timerTask.cancel();
            }
            it.remove();
            break;
        }
    }

    public static void removeDelegationTokenRenewalForJob(JobID jobId) {
        List<DelegationTokenToRenew> l = delegationTokens.remove(jobId);
        if (l == null) {
            return;
        }
        Iterator<DelegationTokenToRenew> it = l.iterator();
        while (it.hasNext()) {
            DelegationTokenToRenew dttr = it.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("removing delegation token for jobid=" + jobId + ";t=" + dttr.token.getService()));
            }
            if (dttr.timerTask != null) {
                dttr.timerTask.cancel();
            }
            DelegationTokenRenewal.cancelToken(dttr);
            it.remove();
        }
    }

    private static class RenewalTimerTask
    extends TimerTask {
        private DelegationTokenToRenew dttr;

        RenewalTimerTask(DelegationTokenToRenew t) {
            this.dttr = t;
        }

        @Override
        public void run() {
            Token<DelegationTokenIdentifier> token = this.dttr.token;
            long newExpirationDate = 0L;
            try {
                newExpirationDate = DelegationTokenRenewal.renewDelegationToken(this.dttr);
            }
            catch (Exception e) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("renewing for:" + token.getService() + ";newED=" + newExpirationDate));
            }
            this.dttr.expirationDate = newExpirationDate;
            DelegationTokenRenewal.setTimerForTokenRenewal(this.dttr, false);
        }
    }

    private static class DelegationTokenToRenew {
        public final Token<DelegationTokenIdentifier> token;
        public final JobID jobId;
        public final Configuration conf;
        public long expirationDate;
        public TimerTask timerTask;

        public DelegationTokenToRenew(JobID jId, Token<DelegationTokenIdentifier> t, Configuration newConf, long newExpirationDate) {
            this.token = t;
            this.jobId = jId;
            this.conf = newConf;
            this.expirationDate = newExpirationDate;
            this.timerTask = null;
            if (this.token == null || this.jobId == null || this.conf == null) {
                throw new IllegalArgumentException("invalid params for Renew Token;t=" + this.token + ";j=" + this.jobId + ";c=" + this.conf);
            }
        }

        public void setTimerTask(TimerTask tTask) {
            this.timerTask = tTask;
        }

        public String toString() {
            return this.token + ";exp=" + this.expirationDate;
        }
    }
}

