/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.MergeManager;

abstract class MergeThread<T, K, V>
extends Thread {
    private static final Log LOG = LogFactory.getLog(MergeThread.class);
    private volatile boolean inProgress = false;
    private List<T> inputs = new ArrayList<T>();
    protected final MergeManager<K, V> manager;
    private final ExceptionReporter reporter;
    private boolean closed = false;
    private final int mergeFactor;

    public MergeThread(MergeManager<K, V> manager, int mergeFactor, ExceptionReporter reporter) {
        this.manager = manager;
        this.mergeFactor = mergeFactor;
        this.reporter = reporter;
    }

    public synchronized void close() throws InterruptedException {
        this.closed = true;
        this.waitForMerge();
        this.interrupt();
    }

    public synchronized boolean isInProgress() {
        return this.inProgress;
    }

    public synchronized void startMerge(Set<T> inputs) {
        if (!this.closed) {
            this.inProgress = true;
            this.inputs = new ArrayList<T>();
            Iterator<T> iter = inputs.iterator();
            for (int ctr = 0; iter.hasNext() && ctr < this.mergeFactor; ++ctr) {
                this.inputs.add(iter.next());
                iter.remove();
            }
            LOG.info((Object)(this.getName() + ": Starting merge with " + this.inputs.size() + " segments, while ignoring " + inputs.size() + " segments"));
            this.notifyAll();
        }
    }

    public synchronized void waitForMerge() throws InterruptedException {
        while (this.inProgress) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            MergeThread mergeThread;
            try {
                mergeThread = this;
                synchronized (mergeThread) {
                    while (!this.inProgress) {
                        this.wait();
                    }
                }
                this.merge(this.inputs);
                continue;
            }
            catch (InterruptedException ie) {
                return;
            }
            catch (Throwable t) {
                this.reporter.reportException(t);
                return;
            }
            finally {
                mergeThread = this;
                synchronized (mergeThread) {
                    this.inputs = null;
                    this.inProgress = false;
                    this.notifyAll();
                }
                continue;
            }
            break;
        }
    }

    public abstract void merge(List<T> var1) throws IOException;
}

