/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.spi.AbstractMetricsContext;
import org.apache.hadoop.metrics.spi.OutputRecord;
import org.mortbay.util.ajax.JSON;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MetricsServlet
extends HttpServlet {
    Map<String, Map<String, List<TagsMetricsPair>>> makeMap(Collection<MetricsContext> contexts) throws IOException {
        TreeMap<String, Map<String, List<TagsMetricsPair>>> map = new TreeMap<String, Map<String, List<TagsMetricsPair>>>();
        for (MetricsContext context : contexts) {
            TreeMap records = new TreeMap();
            map.put(context.getContextName(), records);
            for (Map.Entry<String, Collection<OutputRecord>> r : context.getAllRecords().entrySet()) {
                ArrayList<TagsMetricsPair> metricsAndTags = new ArrayList<TagsMetricsPair>();
                records.put(r.getKey(), metricsAndTags);
                for (OutputRecord outputRecord : r.getValue()) {
                    AbstractMetricsContext.TagMap tagMap = outputRecord.getTagsCopy();
                    AbstractMetricsContext.MetricMap metricMap = outputRecord.getMetricsCopy();
                    metricsAndTags.add(new TagsMetricsPair(tagMap, metricMap));
                }
            }
        }
        return map;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!HttpServer.hasAdministratorAccess(this.getServletContext(), request, response)) {
            return;
        }
        PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
        String format = request.getParameter("format");
        Collection<MetricsContext> allContexts = ContextFactory.getFactory().getAllContexts();
        if ("json".equals(format)) {
            out.print(new JSON().toJSON(this.makeMap(allContexts)));
        } else {
            this.printMap(out, this.makeMap(allContexts));
        }
        out.close();
    }

    void printMap(PrintWriter out, Map<String, Map<String, List<TagsMetricsPair>>> map) {
        for (Map.Entry<String, Map<String, List<TagsMetricsPair>>> context : map.entrySet()) {
            out.println(context.getKey());
            for (Map.Entry<String, List<TagsMetricsPair>> record : context.getValue().entrySet()) {
                this.indent(out, 1);
                out.println(record.getKey());
                for (TagsMetricsPair pair : record.getValue()) {
                    this.indent(out, 2);
                    out.print("{");
                    boolean first = true;
                    for (Map.Entry tagValue : pair.tagMap.entrySet()) {
                        if (first) {
                            first = false;
                        } else {
                            out.print(",");
                        }
                        out.print((String)tagValue.getKey());
                        out.print("=");
                        out.print(tagValue.getValue().toString());
                    }
                    out.println("}:");
                    for (Map.Entry metricValue : pair.metricMap.entrySet()) {
                        this.indent(out, 3);
                        out.print((String)metricValue.getKey());
                        out.print("=");
                        out.println(((Number)metricValue.getValue()).toString());
                    }
                }
            }
        }
    }

    private void indent(PrintWriter out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.append("  ");
        }
    }

    static class TagsMetricsPair
    implements JSON.Convertible {
        final AbstractMetricsContext.TagMap tagMap;
        final AbstractMetricsContext.MetricMap metricMap;

        public TagsMetricsPair(AbstractMetricsContext.TagMap tagMap, AbstractMetricsContext.MetricMap metricMap) {
            this.tagMap = tagMap;
            this.metricMap = metricMap;
        }

        public void fromJSON(Map map) {
            throw new UnsupportedOperationException();
        }

        public void toJSON(JSON.Output out) {
            out.add((Object)new Object[]{this.tagMap, this.metricMap});
        }
    }
}

