/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public class LineReader {
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private int bufferSize = 65536;
    private InputStream in;
    private byte[] buffer;
    private int bufferLength = 0;
    private int bufferPosn = 0;
    private static final byte CR = 13;
    private static final byte LF = 10;

    public LineReader(InputStream in) {
        this(in, 65536);
    }

    public LineReader(InputStream in, int bufferSize) {
        this.in = in;
        this.bufferSize = bufferSize;
        this.buffer = new byte[this.bufferSize];
    }

    public LineReader(InputStream in, Configuration conf) throws IOException {
        this(in, conf.getInt("io.file.buffer.size", 65536));
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int readLine(Text str, int maxLineLength, int maxBytesToConsume) throws IOException {
        str.clear();
        int txtLength = 0;
        int newlineLength = 0;
        boolean prevCharCR = false;
        long bytesConsumed = 0L;
        do {
            int startPosn = this.bufferPosn;
            if (this.bufferPosn >= this.bufferLength) {
                this.bufferPosn = 0;
                startPosn = 0;
                if (prevCharCR) {
                    ++bytesConsumed;
                }
                this.bufferLength = this.in.read(this.buffer);
                if (this.bufferLength <= 0) break;
            }
            while (this.bufferPosn < this.bufferLength) {
                if (this.buffer[this.bufferPosn] == 10) {
                    newlineLength = prevCharCR ? 2 : 1;
                    ++this.bufferPosn;
                    break;
                }
                if (prevCharCR) {
                    newlineLength = 1;
                    break;
                }
                prevCharCR = this.buffer[this.bufferPosn] == 13;
                ++this.bufferPosn;
            }
            int readLength = this.bufferPosn - startPosn;
            if (prevCharCR && newlineLength == 0) {
                --readLength;
            }
            bytesConsumed += (long)readLength;
            int appendLength = readLength - newlineLength;
            if (appendLength > maxLineLength - txtLength) {
                appendLength = maxLineLength - txtLength;
            }
            if (appendLength <= 0) continue;
            str.append(this.buffer, startPosn, appendLength);
            txtLength += appendLength;
        } while (newlineLength == 0 && bytesConsumed < (long)maxBytesToConsume);
        if (bytesConsumed > Integer.MAX_VALUE) {
            throw new IOException("Too many bytes before newline: " + bytesConsumed);
        }
        return (int)bytesConsumed;
    }

    public int readLine(Text str, int maxLineLength) throws IOException {
        return this.readLine(str, maxLineLength, Integer.MAX_VALUE);
    }

    public int readLine(Text str) throws IOException {
        return this.readLine(str, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

