/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.avro.reflect.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HdfsFileStatus
implements Writable {
    private byte[] path;
    @Nullable
    private byte[] symlink;
    private long length;
    private boolean isdir;
    private short block_replication;
    private long blocksize;
    private long modification_time;
    private long access_time;
    private FsPermission permission;
    private String owner;
    private String group;
    public static final byte[] EMPTY_NAME;
    public static final String __PARANAMER_DATA = "<init> long,boolean,int,long,long,long,org.apache.hadoop.fs.permission.FsPermission,java.lang.String,java.lang.String,byte[],byte[] length,isdir,block_replication,blocksize,modification_time,access_time,permission,owner,group,symlink,path \ngetFullName java.lang.String parent \ngetFullPath org.apache.hadoop.fs.Path parent \nreadFields java.io.DataInput in \nwrite java.io.DataOutput out \n";

    public HdfsFileStatus() {
        this(0L, false, 0, 0L, 0L, 0L, null, null, null, null, null);
    }

    public HdfsFileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, byte[] symlink, byte[] path) {
        this.length = length;
        this.isdir = isdir;
        this.block_replication = (short)block_replication;
        this.blocksize = blocksize;
        this.modification_time = modification_time;
        this.access_time = access_time;
        this.permission = permission == null ? FsPermission.getDefault() : permission;
        this.owner = owner == null ? "" : owner;
        this.group = group == null ? "" : group;
        this.symlink = symlink;
        this.path = path;
    }

    public final long getLen() {
        return this.length;
    }

    public final boolean isDir() {
        return this.isdir;
    }

    public boolean isSymlink() {
        return this.symlink != null;
    }

    public final long getBlockSize() {
        return this.blocksize;
    }

    public final short getReplication() {
        return this.block_replication;
    }

    public final long getModificationTime() {
        return this.modification_time;
    }

    public final long getAccessTime() {
        return this.access_time;
    }

    public final FsPermission getPermission() {
        return this.permission;
    }

    public final String getOwner() {
        return this.owner;
    }

    public final String getGroup() {
        return this.group;
    }

    public final boolean isEmptyLocalName() {
        return this.path.length == 0;
    }

    public final String getLocalName() {
        return DFSUtil.bytes2String(this.path);
    }

    public final byte[] getLocalNameInBytes() {
        return this.path;
    }

    public final String getFullName(String parent) {
        if (this.isEmptyLocalName()) {
            return parent;
        }
        StringBuilder fullName = new StringBuilder(parent);
        if (!parent.endsWith("/")) {
            fullName.append("/");
        }
        fullName.append(this.getLocalName());
        return fullName.toString();
    }

    public final Path getFullPath(Path parent) {
        if (this.isEmptyLocalName()) {
            return parent;
        }
        return new Path(parent, this.getLocalName());
    }

    public final String getSymlink() {
        return DFSUtil.bytes2String(this.symlink);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.path.length);
        out.write(this.path);
        out.writeLong(this.length);
        out.writeBoolean(this.isdir);
        out.writeShort(this.block_replication);
        out.writeLong(this.blocksize);
        out.writeLong(this.modification_time);
        out.writeLong(this.access_time);
        this.permission.write(out);
        Text.writeString((DataOutput)out, (String)this.owner);
        Text.writeString((DataOutput)out, (String)this.group);
        out.writeBoolean(this.isSymlink());
        if (this.isSymlink()) {
            out.writeInt(this.symlink.length);
            out.write(this.symlink);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numOfBytes = in.readInt();
        if (numOfBytes == 0) {
            this.path = EMPTY_NAME;
        } else {
            this.path = new byte[numOfBytes];
            in.readFully(this.path);
        }
        this.length = in.readLong();
        this.isdir = in.readBoolean();
        this.block_replication = in.readShort();
        this.blocksize = in.readLong();
        this.modification_time = in.readLong();
        this.access_time = in.readLong();
        this.permission.readFields(in);
        this.owner = Text.readString((DataInput)in);
        this.group = Text.readString((DataInput)in);
        if (in.readBoolean()) {
            numOfBytes = in.readInt();
            this.symlink = new byte[numOfBytes];
            in.readFully(this.symlink);
        }
    }

    static {
        WritableFactories.setFactory(HdfsFileStatus.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new HdfsFileStatus();
            }
        });
        EMPTY_NAME = new byte[0];
    }
}

