/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class UnresolvedPathException
extends UnresolvedLinkException {
    private static final long serialVersionUID = 1L;
    private String originalPath;
    private String linkTarget;
    private String remainingPath;
    public static final String __PARANAMER_DATA = "<init> java.lang.String msg \n<init> java.lang.String,java.lang.String,java.lang.String originalPath,remainingPath,linkTarget \n";

    public UnresolvedPathException(String msg) {
        super(msg);
    }

    public UnresolvedPathException(String originalPath, String remainingPath, String linkTarget) {
        this.originalPath = originalPath;
        this.remainingPath = remainingPath;
        this.linkTarget = linkTarget;
    }

    public Path getUnresolvedPath() throws IOException {
        return new Path(this.originalPath);
    }

    public Path getResolvedPath() throws IOException {
        if (this.remainingPath == null || "".equals(this.remainingPath)) {
            return new Path(this.linkTarget);
        }
        return new Path(this.linkTarget, this.remainingPath);
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (msg != null) {
            return msg;
        }
        String myMsg = "Unresolved path " + this.originalPath;
        try {
            return this.getResolvedPath().toString();
        }
        catch (IOException iOException) {
            return myMsg;
        }
    }
}

