/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;

class FinalizedReplica
extends ReplicaInfo {
    private boolean unlinked;

    FinalizedReplica(long blockId, long len, long genStamp, FSDataset.FSVolume vol, File dir) {
        super(blockId, len, genStamp, vol, dir);
    }

    FinalizedReplica(Block block, FSDataset.FSVolume vol, File dir) {
        super(block, vol, dir);
    }

    FinalizedReplica(FinalizedReplica from) {
        super(from);
        this.unlinked = from.isUnlinked();
    }

    @Override
    public HdfsConstants.ReplicaState getState() {
        return HdfsConstants.ReplicaState.FINALIZED;
    }

    @Override
    boolean isUnlinked() {
        return this.unlinked;
    }

    @Override
    void setUnlinked() {
        this.unlinked = true;
    }

    @Override
    public long getVisibleLength() {
        return this.getNumBytes();
    }

    @Override
    public long getBytesOnDisk() {
        return this.getNumBytes();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + "\n  unlinked=" + this.unlinked;
    }
}

