/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.JournalStream;

class EditLogBackupInputStream
extends EditLogInputStream {
    String address;
    private ByteBufferInputStream inner;
    private DataInputStream in;

    EditLogBackupInputStream(String name) throws IOException {
        this.address = name;
        this.inner = new ByteBufferInputStream();
        this.in = new DataInputStream(this.inner);
    }

    @Override
    public String getName() {
        return this.address;
    }

    @Override
    public JournalStream.JournalType getType() {
        return JournalStream.JournalType.BACKUP;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    long length() throws IOException {
        return this.inner.length();
    }

    @Override
    DataInputStream getDataInputStream() {
        return this.in;
    }

    void setBytes(byte[] newBytes) throws IOException {
        this.inner.setData(newBytes);
        this.in.reset();
    }

    void clear() throws IOException {
        this.setBytes(null);
    }

    private static class ByteBufferInputStream
    extends ByteArrayInputStream {
        ByteBufferInputStream() {
            super(new byte[0]);
        }

        byte[] getData() {
            return this.buf;
        }

        void setData(byte[] newBytes) {
            this.buf = newBytes;
            this.count = newBytes == null ? 0 : newBytes.length;
            this.mark = 0;
            this.reset();
        }

        int length() {
            return this.count;
        }
    }
}

