/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.EditLogBackupOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.JournalStream;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.security.token.delegation.DelegationKey;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSEditLog {
    public static final byte OP_INVALID = -1;
    private static final byte OP_ADD = 0;
    private static final byte OP_RENAME_OLD = 1;
    private static final byte OP_DELETE = 2;
    private static final byte OP_MKDIR = 3;
    private static final byte OP_SET_REPLICATION = 4;
    @Deprecated
    private static final byte OP_DATANODE_ADD = 5;
    @Deprecated
    private static final byte OP_DATANODE_REMOVE = 6;
    private static final byte OP_SET_PERMISSIONS = 7;
    private static final byte OP_SET_OWNER = 8;
    private static final byte OP_CLOSE = 9;
    private static final byte OP_SET_GENSTAMP = 10;
    private static final byte OP_SET_NS_QUOTA = 11;
    private static final byte OP_CLEAR_NS_QUOTA = 12;
    private static final byte OP_TIMES = 13;
    private static final byte OP_SET_QUOTA = 14;
    private static final byte OP_RENAME = 15;
    private static final byte OP_CONCAT_DELETE = 16;
    private static final byte OP_SYMLINK = 17;
    private static final byte OP_GET_DELEGATION_TOKEN = 18;
    private static final byte OP_RENEW_DELEGATION_TOKEN = 19;
    private static final byte OP_CANCEL_DELEGATION_TOKEN = 20;
    private static final byte OP_UPDATE_MASTER_KEY = 21;
    static final byte OP_JSPOOL_START = 102;
    static final byte OP_CHECKPOINT_TIME = 103;
    static final String NO_JOURNAL_STREAMS_WARNING = "!!! WARNING !!! File system changes are not persistent. No journal streams.";
    private volatile int sizeOutputFlushBuffer = 524288;
    private ArrayList<EditLogOutputStream> editStreams = null;
    private FSImage fsimage = null;
    private long txid = 0L;
    private long synctxid = 0L;
    private long lastPrintTime;
    private volatile boolean isSyncRunning;
    private long numTransactions;
    private long numTransactionsBatchedInSync;
    private long totalTimeTransactions;
    private NameNodeMetrics metrics;
    private static final ThreadLocal<TransactionId> myTransactionId = new ThreadLocal<TransactionId>(){

        @Override
        protected synchronized TransactionId initialValue() {
            return new TransactionId(Long.MAX_VALUE);
        }
    };
    private static final LongWritable longWritable = new LongWritable();

    FSEditLog(FSImage image) {
        this.fsimage = image;
        this.isSyncRunning = false;
        this.metrics = NameNode.getNameNodeMetrics();
        this.lastPrintTime = FSNamesystem.now();
    }

    private File getEditFile(Storage.StorageDirectory sd) {
        return this.fsimage.getEditFile(sd);
    }

    private File getEditNewFile(Storage.StorageDirectory sd) {
        return this.fsimage.getEditNewFile(sd);
    }

    private int getNumEditsDirs() {
        return this.fsimage.getNumStorageDirs(FSImage.NameNodeDirType.EDITS);
    }

    synchronized int getNumEditStreams() {
        return this.editStreams == null ? 0 : this.editStreams.size();
    }

    ArrayList<EditLogOutputStream> getEditStreams() {
        return this.editStreams;
    }

    boolean isOpen() {
        return this.getNumEditStreams() > 0;
    }

    synchronized void open() throws IOException {
        this.numTransactionsBatchedInSync = 0L;
        this.totalTimeTransactions = 0L;
        this.numTransactions = 0L;
        if (this.editStreams == null) {
            this.editStreams = new ArrayList();
        }
        ArrayList<Storage.StorageDirectory> al = null;
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            File eFile = this.getEditFile(sd);
            try {
                this.addNewEditLogStream(eFile);
            }
            catch (IOException e) {
                FSNamesystem.LOG.warn((Object)("Unable to open edit log file " + eFile));
                if (al == null) {
                    al = new ArrayList<Storage.StorageDirectory>(1);
                }
                al.add(sd);
            }
        }
        if (al != null) {
            this.fsimage.processIOError(al, false);
        }
    }

    synchronized void addNewEditLogStream(File eFile) throws IOException {
        EditLogFileOutputStream eStream = new EditLogFileOutputStream(eFile, this.sizeOutputFlushBuffer);
        this.editStreams.add(eStream);
    }

    synchronized void createEditLogFile(File name) throws IOException {
        this.waitForSyncToFinish();
        EditLogFileOutputStream eStream = new EditLogFileOutputStream(name, this.sizeOutputFlushBuffer);
        ((EditLogOutputStream)eStream).create();
        ((EditLogOutputStream)eStream).close();
    }

    synchronized void close() {
        this.waitForSyncToFinish();
        if (this.editStreams == null || this.editStreams.isEmpty()) {
            return;
        }
        this.printStatistics(true);
        this.numTransactionsBatchedInSync = 0L;
        this.totalTimeTransactions = 0L;
        this.numTransactions = 0L;
        ArrayList<EditLogOutputStream> errorStreams = null;
        Iterator<EditLogOutputStream> it = this.getOutputStreamIterator(null);
        while (it.hasNext()) {
            EditLogOutputStream eStream = it.next();
            try {
                this.closeStream(eStream);
            }
            catch (IOException e) {
                FSNamesystem.LOG.warn((Object)("FSEditLog:close - failed to close stream " + eStream.getName()));
                if (errorStreams == null) {
                    errorStreams = new ArrayList<EditLogOutputStream>(1);
                }
                errorStreams.add(eStream);
            }
        }
        this.processIOError(errorStreams, true);
        this.editStreams.clear();
    }

    private synchronized void removeStream(int index) {
        EditLogOutputStream eStream = this.editStreams.get(index);
        try {
            eStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.editStreams.remove(index);
    }

    synchronized void processIOError(ArrayList<EditLogOutputStream> errorStreams, boolean propagate) {
        if (errorStreams == null || errorStreams.size() == 0) {
            return;
        }
        String lsd = this.fsimage.listStorageDirectories();
        FSNamesystem.LOG.info((Object)("current list of storage dirs:" + lsd));
        ArrayList<Storage.StorageDirectory> al = null;
        block2: for (EditLogOutputStream eStream : errorStreams) {
            Storage.StorageDirectory storageDir;
            FSNamesystem.LOG.error((Object)("Unable to log edits to " + eStream.getName() + "; removing it"));
            if (propagate && eStream.getType() == JournalStream.JournalType.FILE && (storageDir = this.getStorage(eStream)) != null) {
                FSNamesystem.LOG.info((Object)("about to remove corresponding storage:" + storageDir.getRoot().getAbsolutePath()));
                if (al == null) {
                    al = new ArrayList<Storage.StorageDirectory>(1);
                }
                al.add(storageDir);
            }
            Iterator<EditLogOutputStream> ies = this.editStreams.iterator();
            while (ies.hasNext()) {
                EditLogOutputStream es = ies.next();
                if (es != eStream) continue;
                try {
                    eStream.close();
                }
                catch (IOException e) {
                    FSNamesystem.LOG.warn((Object)("Failed to close eStream " + eStream.getName() + " before removing it (might be ok)"));
                }
                ies.remove();
                continue block2;
            }
        }
        if (this.editStreams == null || this.editStreams.size() <= 0) {
            String msg = "Fatal Error: All storage directories are inaccessible.";
            FSNamesystem.LOG.fatal((Object)msg, (Throwable)new IOException(msg));
            Runtime.getRuntime().exit(-1);
        }
        if (propagate && al != null) {
            this.fsimage.processIOError(al, false);
        }
        if (propagate) {
            this.incrementCheckpointTime();
        }
        lsd = this.fsimage.listStorageDirectories();
        FSNamesystem.LOG.info((Object)("at the end current list of storage dirs:" + lsd));
    }

    Storage.StorageDirectory getStorage(EditLogOutputStream es) {
        String parentStorageDir = ((EditLogFileOutputStream)es).getFile().getParentFile().getParentFile().getAbsolutePath();
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            FSNamesystem.LOG.info((Object)("comparing: " + parentStorageDir + " and " + sd.getRoot().getAbsolutePath()));
            if (!parentStorageDir.equals(sd.getRoot().getAbsolutePath())) continue;
            return sd;
        }
        return null;
    }

    synchronized EditLogOutputStream getEditsStream(Storage.StorageDirectory sd) {
        for (EditLogOutputStream es : this.editStreams) {
            File parentStorageDir = ((EditLogFileOutputStream)es).getFile().getParentFile().getParentFile();
            if (!parentStorageDir.getName().equals(sd.getRoot().getName())) continue;
            return es;
        }
        return null;
    }

    boolean existsNew(Storage.StorageDirectory sd) {
        return this.getEditNewFile(sd).exists();
    }

    int loadFSEdits(EditLogInputStream edits) throws IOException {
        DataInputStream in = edits.getDataInputStream();
        long startTime = FSNamesystem.now();
        int numEdits = this.loadFSEdits(in, true);
        FSImage.LOG.info((Object)("Edits file " + edits.getName() + " of size " + edits.length() + " edits # " + numEdits + " loaded in " + (FSNamesystem.now() - startTime) / 1000L + " seconds."));
        return numEdits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int loadFSEdits(DataInputStream in, boolean closeOnExit) throws IOException {
        int numEdits = 0;
        int logVersion = 0;
        try {
            in.mark(4);
            boolean available = true;
            try {
                logVersion = in.readByte();
            }
            catch (EOFException e) {
                available = false;
            }
            if (available) {
                in.reset();
                logVersion = in.readInt();
                if (logVersion < -24) {
                    throw new IOException("Unexpected version of the file system log file: " + logVersion + ". Current version = " + -24 + ".");
                }
            }
            assert (logVersion <= -7) : "Unsupported version " + logVersion;
            numEdits = this.loadEditRecords(logVersion, in, false);
        }
        finally {
            if (closeOnExit) {
                in.close();
            }
        }
        if (logVersion != -24) {
            ++numEdits;
        }
        return numEdits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int loadEditRecords(int logVersion, DataInputStream in, boolean closeOnExit) throws IOException {
        int numOpOther;
        int numOpUpdateMasterKey;
        int numOpCancelDelegationToken;
        int numOpRenewDelegationToken;
        int numOpGetDelegationToken;
        int numOpConcatDelete;
        int numOpRename;
        int numOpTimes;
        int numOpSetGenStamp;
        int numOpSetOwner;
        int numOpSetPerm;
        int numOpMkDir;
        int numOpSetRepl;
        int numOpRenameOld;
        int numOpDelete;
        int numOpClose;
        int numOpAdd;
        int numEdits;
        block63: {
            FSNamesystem fsNamesys = this.fsimage.getFSNamesystem();
            FSDirectory fsDir = fsNamesys.dir;
            numEdits = 0;
            String clientName = null;
            String clientMachine = null;
            String path = null;
            numOpAdd = 0;
            numOpClose = 0;
            numOpDelete = 0;
            numOpRenameOld = 0;
            numOpSetRepl = 0;
            numOpMkDir = 0;
            numOpSetPerm = 0;
            numOpSetOwner = 0;
            numOpSetGenStamp = 0;
            numOpTimes = 0;
            numOpRename = 0;
            numOpConcatDelete = 0;
            int numOpSymlink = 0;
            numOpGetDelegationToken = 0;
            numOpRenewDelegationToken = 0;
            numOpCancelDelegationToken = 0;
            numOpUpdateMasterKey = 0;
            numOpOther = 0;
            try {
                int opcode;
                block28: while (true) {
                    long timestamp = 0L;
                    long mtime = 0L;
                    long atime = 0L;
                    long blockSize = 0L;
                    opcode = -1;
                    try {
                        in.mark(1);
                        opcode = in.readByte();
                        if (opcode == -1) {
                            in.reset();
                        }
                    }
                    catch (EOFException e) {}
                    break block63;
                    ++numEdits;
                    switch (opcode) {
                        case 0: 
                        case 9: {
                            int length = in.readInt();
                            if (-7 == logVersion && length != 3 || -17 < logVersion && logVersion < -7 && length != 4 || logVersion <= -17 && length != 5) {
                                throw new IOException("Incorrect data format. logVersion is " + logVersion + " but writables.length is " + length + ". ");
                            }
                            path = FSImage.readString(in);
                            short replication = this.adjustReplication(FSEditLog.readShort(in));
                            mtime = FSEditLog.readLong(in);
                            if (logVersion <= -17) {
                                atime = FSEditLog.readLong(in);
                            }
                            if (logVersion < -7) {
                                blockSize = FSEditLog.readLong(in);
                            }
                            boolean isFileUnderConstruction = opcode == 0;
                            BlockInfo[] blocks = FSEditLog.readBlocks(in, logVersion, isFileUnderConstruction, replication);
                            if (-8 <= logVersion && blockSize == 0L) {
                                if (blocks.length > 1) {
                                    blockSize = blocks[0].getNumBytes();
                                } else {
                                    long first = blocks.length == 1 ? blocks[0].getNumBytes() : 0L;
                                    blockSize = Math.max(fsNamesys.getDefaultBlockSize(), first);
                                }
                            }
                            PermissionStatus permissions = fsNamesys.getUpgradePermission();
                            if (logVersion <= -11) {
                                permissions = PermissionStatus.read((DataInput)in);
                            }
                            if (opcode == 0 && logVersion <= -12) {
                                clientName = FSImage.readString(in);
                                clientMachine = FSImage.readString(in);
                                if (-13 <= logVersion) {
                                    FSEditLog.readDatanodeDescriptorArray(in);
                                }
                            } else {
                                clientName = "";
                                clientMachine = "";
                            }
                            if (FSNamesystem.LOG.isDebugEnabled()) {
                                FSNamesystem.LOG.debug((Object)(opcode + ": " + path + " numblocks : " + blocks.length + " clientHolder " + clientName + " clientMachine " + clientMachine));
                            }
                            fsDir.unprotectedDelete(path, mtime);
                            INodeFile node = (INodeFile)fsDir.unprotectedAddFile(path, permissions, blocks, replication, mtime, atime, blockSize);
                            if (!isFileUnderConstruction) continue block28;
                            ++numOpAdd;
                            INodeFileUnderConstruction cons = new INodeFileUnderConstruction(node.getLocalNameBytes(), node.getReplication(), node.getModificationTime(), node.getPreferredBlockSize(), node.getBlocks(), node.getPermissionStatus(), clientName, clientMachine, null);
                            fsDir.replaceNode(path, node, cons);
                            fsNamesys.leaseManager.addLease(cons.getClientName(), path);
                            continue block28;
                        }
                        case 4: {
                            ++numOpSetRepl;
                            path = FSImage.readString(in);
                            short replication = this.adjustReplication(FSEditLog.readShort(in));
                            fsDir.unprotectedSetReplication(path, replication, null);
                            continue block28;
                        }
                        case 16: {
                            if (logVersion > -22) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            ++numOpConcatDelete;
                            int length = in.readInt();
                            if (length < 3) {
                                throw new IOException("Incorrect data format. Mkdir operation.");
                            }
                            String trg = FSImage.readString(in);
                            int srcSize = length - 1 - 1;
                            String[] srcs = new String[srcSize];
                            for (int i = 0; i < srcSize; ++i) {
                                srcs[i] = FSImage.readString(in);
                            }
                            timestamp = FSEditLog.readLong(in);
                            fsDir.unprotectedConcat(trg, srcs);
                            continue block28;
                        }
                        case 1: {
                            ++numOpRenameOld;
                            int length = in.readInt();
                            if (length != 3) {
                                throw new IOException("Incorrect data format. Mkdir operation.");
                            }
                            String s = FSImage.readString(in);
                            String d = FSImage.readString(in);
                            timestamp = FSEditLog.readLong(in);
                            HdfsFileStatus dinfo = fsDir.getFileInfo(d, false);
                            fsDir.unprotectedRenameTo(s, d, timestamp);
                            fsNamesys.changeLease(s, d, dinfo);
                            continue block28;
                        }
                        case 2: {
                            ++numOpDelete;
                            int length = in.readInt();
                            if (length != 2) {
                                throw new IOException("Incorrect data format. delete operation.");
                            }
                            path = FSImage.readString(in);
                            timestamp = FSEditLog.readLong(in);
                            fsDir.unprotectedDelete(path, timestamp);
                            continue block28;
                        }
                        case 3: {
                            ++numOpMkDir;
                            PermissionStatus permissions = fsNamesys.getUpgradePermission();
                            int length = in.readInt();
                            if (-17 < logVersion && length != 2 || logVersion <= -17 && length != 3) {
                                throw new IOException("Incorrect data format. Mkdir operation.");
                            }
                            path = FSImage.readString(in);
                            timestamp = FSEditLog.readLong(in);
                            if (logVersion <= -17) {
                                atime = FSEditLog.readLong(in);
                            }
                            if (logVersion <= -11) {
                                permissions = PermissionStatus.read((DataInput)in);
                            }
                            fsDir.unprotectedMkdir(path, permissions, timestamp);
                            continue block28;
                        }
                        case 10: {
                            ++numOpSetGenStamp;
                            long lw = in.readLong();
                            fsNamesys.setGenerationStamp(lw);
                            continue block28;
                        }
                        case 5: {
                            ++numOpOther;
                            FSImage.DatanodeImage nodeimage = new FSImage.DatanodeImage();
                            nodeimage.readFields(in);
                            continue block28;
                        }
                        case 6: {
                            ++numOpOther;
                            DatanodeID nodeID = new DatanodeID();
                            nodeID.readFields(in);
                            continue block28;
                        }
                        case 7: {
                            ++numOpSetPerm;
                            if (logVersion > -11) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            fsDir.unprotectedSetPermission(FSImage.readString(in), FsPermission.read((DataInput)in));
                            continue block28;
                        }
                        case 8: {
                            ++numOpSetOwner;
                            if (logVersion > -11) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            fsDir.unprotectedSetOwner(FSImage.readString(in), FSImage.readString_EmptyAsNull(in), FSImage.readString_EmptyAsNull(in));
                            continue block28;
                        }
                        case 11: {
                            if (logVersion > -16) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            fsDir.unprotectedSetQuota(FSImage.readString(in), FSEditLog.readLongWritable(in), Long.MAX_VALUE);
                            continue block28;
                        }
                        case 12: {
                            if (logVersion > -16) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            fsDir.unprotectedSetQuota(FSImage.readString(in), -1L, Long.MAX_VALUE);
                            continue block28;
                        }
                        case 14: {
                            fsDir.unprotectedSetQuota(FSImage.readString(in), FSEditLog.readLongWritable(in), FSEditLog.readLongWritable(in));
                            continue block28;
                        }
                        case 13: {
                            ++numOpTimes;
                            int length = in.readInt();
                            if (length != 3) {
                                throw new IOException("Incorrect data format. times operation.");
                            }
                            path = FSImage.readString(in);
                            mtime = FSEditLog.readLong(in);
                            atime = FSEditLog.readLong(in);
                            fsDir.unprotectedSetTimes(path, mtime, atime, true);
                            continue block28;
                        }
                        case 17: {
                            ++numOpSymlink;
                            int length = in.readInt();
                            if (length != 4) {
                                throw new IOException("Incorrect data format. symlink operation.");
                            }
                            path = FSImage.readString(in);
                            String value = FSImage.readString(in);
                            mtime = FSEditLog.readLong(in);
                            atime = FSEditLog.readLong(in);
                            PermissionStatus perm = PermissionStatus.read((DataInput)in);
                            fsDir.unprotectedSymlink(path, value, mtime, atime, perm);
                            continue block28;
                        }
                        case 15: {
                            if (logVersion > -21) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            ++numOpRename;
                            int length = in.readInt();
                            if (length != 3) {
                                throw new IOException("Incorrect data format. Mkdir operation.");
                            }
                            String s = FSImage.readString(in);
                            String d = FSImage.readString(in);
                            timestamp = FSEditLog.readLong(in);
                            Options.Rename[] options = FSEditLog.readRenameOptions(in);
                            HdfsFileStatus dinfo = fsDir.getFileInfo(d, false);
                            fsDir.unprotectedRenameTo(s, d, timestamp, options);
                            fsNamesys.changeLease(s, d, dinfo);
                            continue block28;
                        }
                        case 18: {
                            if (logVersion > -24) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            ++numOpGetDelegationToken;
                            DelegationTokenIdentifier delegationTokenId = new DelegationTokenIdentifier();
                            delegationTokenId.readFields(in);
                            long expiryTime = FSEditLog.readLong(in);
                            fsNamesys.getDelegationTokenSecretManager().addPersistedDelegationToken(delegationTokenId, expiryTime);
                            continue block28;
                        }
                        case 19: {
                            if (logVersion > -24) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            ++numOpRenewDelegationToken;
                            DelegationTokenIdentifier delegationTokenId = new DelegationTokenIdentifier();
                            delegationTokenId.readFields(in);
                            long expiryTime = FSEditLog.readLong(in);
                            fsNamesys.getDelegationTokenSecretManager().updatePersistedTokenRenewal(delegationTokenId, expiryTime);
                            continue block28;
                        }
                        case 20: {
                            if (logVersion > -24) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            ++numOpCancelDelegationToken;
                            DelegationTokenIdentifier delegationTokenId = new DelegationTokenIdentifier();
                            delegationTokenId.readFields(in);
                            fsNamesys.getDelegationTokenSecretManager().updatePersistedTokenCancellation(delegationTokenId);
                            continue block28;
                        }
                        case 21: {
                            if (logVersion > -24) {
                                throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                            }
                            ++numOpUpdateMasterKey;
                            DelegationKey delegationKey = new DelegationKey();
                            delegationKey.readFields((DataInput)in);
                            fsNamesys.getDelegationTokenSecretManager().updatePersistedMasterKey(delegationKey);
                            continue block28;
                        }
                    }
                    break;
                }
                throw new IOException("Never seen opcode " + opcode);
            }
            finally {
                if (closeOnExit) {
                    in.close();
                }
            }
        }
        if (FSImage.LOG.isDebugEnabled()) {
            FSImage.LOG.debug((Object)("numOpAdd = " + numOpAdd + " numOpClose = " + numOpClose + " numOpDelete = " + numOpDelete + " numOpRenameOld = " + numOpRenameOld + " numOpSetRepl = " + numOpSetRepl + " numOpMkDir = " + numOpMkDir + " numOpSetPerm = " + numOpSetPerm + " numOpSetOwner = " + numOpSetOwner + " numOpSetGenStamp = " + numOpSetGenStamp + " numOpTimes = " + numOpTimes + " numOpConcatDelete  = " + numOpConcatDelete + " numOpRename = " + numOpRename + " numOpGetDelegationToken = " + numOpGetDelegationToken + " numOpRenewDelegationToken = " + numOpRenewDelegationToken + " numOpCancelDelegationToken = " + numOpCancelDelegationToken + " numOpUpdateMasterKey = " + numOpUpdateMasterKey + " numOpOther = " + numOpOther));
        }
        return numEdits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long readLongWritable(DataInputStream in) throws IOException {
        LongWritable longWritable = FSEditLog.longWritable;
        synchronized (longWritable) {
            FSEditLog.longWritable.readFields((DataInput)in);
            return FSEditLog.longWritable.get();
        }
    }

    short adjustReplication(short replication) {
        short maxReplication;
        FSNamesystem fsNamesys = this.fsimage.getFSNamesystem();
        short minReplication = fsNamesys.getMinReplication();
        if (replication < minReplication) {
            replication = minReplication;
        }
        if (replication > (maxReplication = fsNamesys.getMaxReplication())) {
            replication = maxReplication;
        }
        return replication;
    }

    synchronized void logEdit(byte op, Writable ... writables) {
        if (this.getNumEditStreams() == 0) {
            throw new IllegalStateException(NO_JOURNAL_STREAMS_WARNING);
        }
        ArrayList<EditLogOutputStream> errorStreams = null;
        long start = FSNamesystem.now();
        for (EditLogOutputStream eStream : this.editStreams) {
            FSImage.LOG.debug((Object)("loggin edits into " + eStream.getName() + " stream"));
            if (!eStream.isOperationSupported(op)) continue;
            try {
                eStream.write(op, writables);
            }
            catch (IOException ie) {
                FSImage.LOG.warn((Object)("logEdit: removing " + eStream.getName()), (Throwable)ie);
                if (errorStreams == null) {
                    errorStreams = new ArrayList<EditLogOutputStream>(1);
                }
                errorStreams.add(eStream);
            }
        }
        this.processIOError(errorStreams, true);
        this.recordTransaction(start);
    }

    private void recordTransaction(long start) {
        ++this.txid;
        TransactionId id = myTransactionId.get();
        id.txid = this.txid;
        long end = FSNamesystem.now();
        ++this.numTransactions;
        this.totalTimeTransactions += end - start;
        if (this.metrics != null) {
            this.metrics.transactions.inc(end - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logSyncAll() throws IOException {
        FSEditLog fSEditLog = this;
        synchronized (fSEditLog) {
            TransactionId id = myTransactionId.get();
            id.txid = this.txid;
        }
        this.logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSync() throws IOException {
        ArrayList<EditLogOutputStream> errorStreams = null;
        long syncStart = 0L;
        long mytxid = FSEditLog.myTransactionId.get().txid;
        EditLogOutputStream[] streams = null;
        boolean sync = false;
        try {
            FSEditLog fSEditLog = this;
            synchronized (fSEditLog) {
                block29: {
                    assert (this.editStreams.size() > 0) : "no editlog streams";
                    this.printStatistics(false);
                    while (mytxid > this.synctxid && this.isSyncRunning) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException ie) {}
                    }
                    if (mytxid > this.synctxid) break block29;
                    ++this.numTransactionsBatchedInSync;
                    if (this.metrics != null) {
                        this.metrics.transactionsBatchedInSync.inc();
                    }
                    return;
                }
                syncStart = this.txid;
                this.isSyncRunning = true;
                sync = true;
                for (EditLogOutputStream eStream : this.editStreams) {
                    eStream.setReadyToFlush();
                }
                streams = this.editStreams.toArray(new EditLogOutputStream[this.editStreams.size()]);
            }
            long start = FSNamesystem.now();
            for (int idx = 0; idx < streams.length; ++idx) {
                EditLogOutputStream eStream = streams[idx];
                try {
                    eStream.flush();
                    continue;
                }
                catch (IOException ie) {
                    FSNamesystem.LOG.error((Object)"Unable to sync edit log.", (Throwable)ie);
                    if (errorStreams == null) {
                        errorStreams = new ArrayList<EditLogOutputStream>(1);
                    }
                    errorStreams.add(eStream);
                }
            }
            long elapsed = FSNamesystem.now() - start;
            this.processIOError(errorStreams, true);
            if (this.metrics != null) {
                this.metrics.syncs.inc(elapsed);
            }
        }
        finally {
            FSEditLog ie = this;
            synchronized (ie) {
                this.synctxid = syncStart;
                if (sync) {
                    this.isSyncRunning = false;
                }
                this.notifyAll();
            }
        }
    }

    private void printStatistics(boolean force) {
        long now = FSNamesystem.now();
        if (this.lastPrintTime + 60000L > now && !force) {
            return;
        }
        if (this.editStreams == null || this.editStreams.size() == 0) {
            return;
        }
        this.lastPrintTime = now;
        StringBuilder buf = new StringBuilder();
        buf.append("Number of transactions: ");
        buf.append(this.numTransactions);
        buf.append(" Total time for transactions(ms): ");
        buf.append(this.totalTimeTransactions);
        buf.append("Number of transactions batched in Syncs: ");
        buf.append(this.numTransactionsBatchedInSync);
        buf.append(" Number of syncs: ");
        buf.append(this.editStreams.get(0).getNumSync());
        buf.append(" SyncTimes(ms): ");
        int numEditStreams = this.editStreams.size();
        for (int idx = 0; idx < numEditStreams; ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            buf.append(eStream.getTotalSyncTime());
            buf.append(" ");
        }
        FSNamesystem.LOG.info((Object)buf);
    }

    public void logOpenFile(String path, INodeFileUnderConstruction newNode) {
        DeprecatedUTF8[] nameReplicationPair = new DeprecatedUTF8[]{new DeprecatedUTF8(path), FSEditLog.toLogReplication(newNode.getReplication()), FSEditLog.toLogLong(newNode.getModificationTime()), FSEditLog.toLogLong(newNode.getAccessTime()), FSEditLog.toLogLong(newNode.getPreferredBlockSize())};
        this.logEdit((byte)0, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])nameReplicationPair), new ArrayWritable(Block.class, (Writable[])newNode.getBlocks()), newNode.getPermissionStatus(), new DeprecatedUTF8(newNode.getClientName()), new DeprecatedUTF8(newNode.getClientMachine())});
    }

    public void logCloseFile(String path, INodeFile newNode) {
        DeprecatedUTF8[] nameReplicationPair = new DeprecatedUTF8[]{new DeprecatedUTF8(path), FSEditLog.toLogReplication(newNode.getReplication()), FSEditLog.toLogLong(newNode.getModificationTime()), FSEditLog.toLogLong(newNode.getAccessTime()), FSEditLog.toLogLong(newNode.getPreferredBlockSize())};
        this.logEdit((byte)9, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])nameReplicationPair), new ArrayWritable(Block.class, (Writable[])newNode.getBlocks()), newNode.getPermissionStatus()});
    }

    public void logMkDir(String path, INode newNode) {
        DeprecatedUTF8[] info = new DeprecatedUTF8[]{new DeprecatedUTF8(path), FSEditLog.toLogLong(newNode.getModificationTime()), FSEditLog.toLogLong(newNode.getAccessTime())};
        this.logEdit((byte)3, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info), newNode.getPermissionStatus()});
    }

    void logRename(String src, String dst, long timestamp) {
        DeprecatedUTF8[] info = new DeprecatedUTF8[]{new DeprecatedUTF8(src), new DeprecatedUTF8(dst), FSEditLog.toLogLong(timestamp)};
        this.logEdit((byte)1, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info)});
    }

    void logRename(String src, String dst, long timestamp, Options.Rename ... options) {
        DeprecatedUTF8[] info = new DeprecatedUTF8[]{new DeprecatedUTF8(src), new DeprecatedUTF8(dst), FSEditLog.toLogLong(timestamp)};
        this.logEdit((byte)15, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info), FSEditLog.toBytesWritable(options)});
    }

    void logSetReplication(String src, short replication) {
        this.logEdit((byte)4, new Writable[]{new DeprecatedUTF8(src), FSEditLog.toLogReplication(replication)});
    }

    void logSetQuota(String src, long nsQuota, long dsQuota) {
        this.logEdit((byte)14, new Writable[]{new DeprecatedUTF8(src), new LongWritable(nsQuota), new LongWritable(dsQuota)});
    }

    void logSetPermissions(String src, FsPermission permissions) {
        this.logEdit((byte)7, new Writable[]{new DeprecatedUTF8(src), permissions});
    }

    void logSetOwner(String src, String username, String groupname) {
        DeprecatedUTF8 u = new DeprecatedUTF8(username == null ? "" : username);
        DeprecatedUTF8 g = new DeprecatedUTF8(groupname == null ? "" : groupname);
        this.logEdit((byte)8, new Writable[]{new DeprecatedUTF8(src), u, g});
    }

    void logConcat(String trg, String[] srcs, long timestamp) {
        int size = 1 + srcs.length + 1;
        DeprecatedUTF8[] info = new DeprecatedUTF8[size];
        int idx = 0;
        info[idx++] = new DeprecatedUTF8(trg);
        for (int i = 0; i < srcs.length; ++i) {
            info[idx++] = new DeprecatedUTF8(srcs[i]);
        }
        info[idx] = FSEditLog.toLogLong(timestamp);
        this.logEdit((byte)16, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info)});
    }

    void logDelete(String src, long timestamp) {
        DeprecatedUTF8[] info = new DeprecatedUTF8[]{new DeprecatedUTF8(src), FSEditLog.toLogLong(timestamp)};
        this.logEdit((byte)2, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info)});
    }

    void logGenerationStamp(long genstamp) {
        this.logEdit((byte)10, new Writable[]{new LongWritable(genstamp)});
    }

    void logTimes(String src, long mtime, long atime) {
        DeprecatedUTF8[] info = new DeprecatedUTF8[]{new DeprecatedUTF8(src), FSEditLog.toLogLong(mtime), FSEditLog.toLogLong(atime)};
        this.logEdit((byte)13, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info)});
    }

    void logSymlink(String path, String value, long mtime, long atime, INodeSymlink node) {
        DeprecatedUTF8[] info = new DeprecatedUTF8[]{new DeprecatedUTF8(path), new DeprecatedUTF8(value), FSEditLog.toLogLong(mtime), FSEditLog.toLogLong(atime)};
        this.logEdit((byte)17, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info), node.getPermissionStatus()});
    }

    void logGetDelegationToken(DelegationTokenIdentifier id, long expiryTime) {
        this.logEdit((byte)18, new Writable[]{id, FSEditLog.toLogLong(expiryTime)});
    }

    void logRenewDelegationToken(DelegationTokenIdentifier id, long expiryTime) {
        this.logEdit((byte)19, new Writable[]{id, FSEditLog.toLogLong(expiryTime)});
    }

    void logCancelDelegationToken(DelegationTokenIdentifier id) {
        this.logEdit((byte)20, new Writable[]{id});
    }

    void logUpdateMasterKey(DelegationKey key) {
        this.logEdit((byte)21, new Writable[]{key});
    }

    private static DeprecatedUTF8 toLogReplication(short replication) {
        return new DeprecatedUTF8(Short.toString(replication));
    }

    private static DeprecatedUTF8 toLogLong(long timestamp) {
        return new DeprecatedUTF8(Long.toString(timestamp));
    }

    synchronized long getEditLogSize() throws IOException {
        assert (this.getNumEditsDirs() <= this.getNumEditStreams()) : "Number of edits directories should not exceed the number of streams.";
        long size = 0L;
        ArrayList<EditLogOutputStream> al = null;
        for (int idx = 0; idx < this.getNumEditStreams(); ++idx) {
            EditLogOutputStream es = this.editStreams.get(idx);
            try {
                long curSize = es.length();
                assert (size == 0L || size == curSize || curSize == 0L) : "Wrong streams size";
                size = Math.max(size, curSize);
                continue;
            }
            catch (IOException e) {
                FSImage.LOG.warn((Object)("getEditLogSize: editstream.length failed. removing editlog (" + idx + ") " + es.getName()));
                if (al == null) {
                    al = new ArrayList<EditLogOutputStream>(1);
                }
                al.add(es);
            }
        }
        if (al != null) {
            this.processIOError(al, true);
        }
        return size;
    }

    synchronized void rollEditLog() throws IOException {
        this.waitForSyncToFinish();
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        if (!it.hasNext()) {
            return;
        }
        boolean alreadyExists = this.existsNew(it.next());
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            if (alreadyExists == this.existsNew(sd)) continue;
            throw new IOException(this.getEditNewFile(sd) + "should " + (alreadyExists ? "" : "not ") + "exist.");
        }
        if (alreadyExists) {
            return;
        }
        this.fsimage.attemptRestoreRemovedStorage();
        this.divertFileStreams("current/" + FSImage.NameNodeFile.EDITS_NEW.getName());
    }

    synchronized void divertFileStreams(String dest) throws IOException {
        this.waitForSyncToFinish();
        assert (this.getNumEditStreams() >= this.getNumEditsDirs()) : "Inconsistent number of streams";
        ArrayList<EditLogOutputStream> errorStreams = null;
        EditStreamIterator itE = (EditStreamIterator)this.getOutputStreamIterator(JournalStream.JournalType.FILE);
        Iterator<Storage.StorageDirectory> itD = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (itE.hasNext() && itD.hasNext()) {
            EditLogOutputStream eStream = itE.next();
            Storage.StorageDirectory sd = itD.next();
            if (!eStream.getName().startsWith(sd.getRoot().getPath())) {
                throw new IOException("Inconsistent order of edit streams: " + eStream);
            }
            try {
                this.closeStream(eStream);
                eStream = new EditLogFileOutputStream(new File(sd.getRoot(), dest), this.sizeOutputFlushBuffer);
                eStream.create();
                itE.replace(eStream);
            }
            catch (IOException e) {
                FSNamesystem.LOG.warn((Object)("Error in editStream " + eStream.getName()), (Throwable)e);
                if (errorStreams == null) {
                    errorStreams = new ArrayList<EditLogOutputStream>(1);
                }
                errorStreams.add(eStream);
            }
        }
        this.processIOError(errorStreams, true);
    }

    synchronized void purgeEditLog() throws IOException {
        this.waitForSyncToFinish();
        this.revertFileStreams("current/" + FSImage.NameNodeFile.EDITS_NEW.getName());
    }

    synchronized void waitForSyncToFinish() {
        while (this.isSyncRunning) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void revertFileStreams(String source) throws IOException {
        this.waitForSyncToFinish();
        assert (this.getNumEditStreams() >= this.getNumEditsDirs()) : "Inconsistent number of streams";
        ArrayList<EditLogOutputStream> errorStreams = null;
        EditStreamIterator itE = (EditStreamIterator)this.getOutputStreamIterator(JournalStream.JournalType.FILE);
        Iterator<Storage.StorageDirectory> itD = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (itE.hasNext() && itD.hasNext()) {
            EditLogOutputStream eStream = itE.next();
            Storage.StorageDirectory sd = itD.next();
            if (!eStream.getName().startsWith(sd.getRoot().getPath())) {
                throw new IOException("Inconsistent order of edit streams: " + eStream + " does not start with " + sd.getRoot().getPath());
            }
            try {
                this.closeStream(eStream);
                File editFile = this.getEditFile(sd);
                File prevEditFile = new File(sd.getRoot(), source);
                if (!(!prevEditFile.exists() || prevEditFile.renameTo(editFile) || editFile.delete() && prevEditFile.renameTo(editFile))) {
                    throw new IOException("Rename failed for " + sd.getRoot());
                }
                eStream = new EditLogFileOutputStream(editFile, this.sizeOutputFlushBuffer);
                itE.replace(eStream);
            }
            catch (IOException e) {
                FSNamesystem.LOG.warn((Object)("Error in editStream " + eStream.getName()), (Throwable)e);
                if (errorStreams == null) {
                    errorStreams = new ArrayList<EditLogOutputStream>(1);
                }
                errorStreams.add(eStream);
            }
        }
        this.processIOError(errorStreams, true);
    }

    synchronized File getFsEditName() {
        Storage.StorageDirectory sd = null;
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            sd = it.next();
            if (!sd.getRoot().canRead()) continue;
            return this.getEditFile(sd);
        }
        return null;
    }

    synchronized long getFsEditTime() {
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        if (it.hasNext()) {
            return this.getEditFile(it.next()).lastModified();
        }
        return 0L;
    }

    public void setBufferCapacity(int size) {
        this.sizeOutputFlushBuffer = size;
    }

    private static DatanodeDescriptor[] readDatanodeDescriptorArray(DataInput in) throws IOException {
        DatanodeDescriptor[] locations = new DatanodeDescriptor[in.readInt()];
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = new DatanodeDescriptor();
            locations[i].readFieldsFromFSEditLog(in);
        }
        return locations;
    }

    private static short readShort(DataInputStream in) throws IOException {
        return Short.parseShort(FSImage.readString(in));
    }

    private static long readLong(DataInputStream in) throws IOException {
        return Long.parseLong(FSImage.readString(in));
    }

    private static BlockInfo[] readBlocks(DataInputStream in, int logVersion, boolean isFileUnderConstruction, short replication) throws IOException {
        int numBlocks = in.readInt();
        BlockInfo[] blocks = new BlockInfo[numBlocks];
        Block blk = new Block();
        BlockTwo oldblk = new BlockTwo();
        for (int i = 0; i < numBlocks; ++i) {
            if (logVersion <= -14) {
                blk.readFields(in);
            } else {
                oldblk.readFields(in);
                blk.set(oldblk.blkid, oldblk.len, 0L);
            }
            blocks[i] = isFileUnderConstruction && i == numBlocks - 1 ? new BlockInfoUnderConstruction(blk, replication) : new BlockInfo(blk, replication);
        }
        return blocks;
    }

    boolean isEmpty() throws IOException {
        return this.getEditLogSize() <= 0L;
    }

    synchronized void logJSpoolStart(NamenodeRegistration bnReg, NamenodeRegistration nnReg) throws IOException {
        if (bnReg.isRole(HdfsConstants.NamenodeRole.CHECKPOINT)) {
            return;
        }
        if (this.editStreams == null) {
            this.editStreams = new ArrayList();
        }
        EditLogOutputStream boStream = null;
        for (EditLogOutputStream eStream : this.editStreams) {
            if (!eStream.getName().equals(bnReg.getAddress())) continue;
            boStream = eStream;
            break;
        }
        if (boStream == null) {
            boStream = new EditLogBackupOutputStream(bnReg, nnReg);
            this.editStreams.add(boStream);
        }
        this.logEdit((byte)102, (Writable[])null);
    }

    synchronized void logEdit(int length, byte[] data) {
        if (this.getNumEditStreams() == 0) {
            throw new IllegalStateException(NO_JOURNAL_STREAMS_WARNING);
        }
        ArrayList<EditLogOutputStream> errorStreams = null;
        long start = FSNamesystem.now();
        for (EditLogOutputStream eStream : this.editStreams) {
            try {
                eStream.write(data, 0, length);
            }
            catch (IOException ie) {
                FSNamesystem.LOG.warn((Object)("Error in editStream " + eStream.getName()), (Throwable)ie);
                if (errorStreams == null) {
                    errorStreams = new ArrayList<EditLogOutputStream>(1);
                }
                errorStreams.add(eStream);
            }
        }
        this.processIOError(errorStreams, true);
        this.recordTransaction(start);
    }

    public Iterator<EditLogOutputStream> getOutputStreamIterator(JournalStream.JournalType streamType) {
        return new EditStreamIterator(streamType);
    }

    private void closeStream(EditLogOutputStream eStream) throws IOException {
        eStream.setReadyToFlush();
        eStream.flush();
        eStream.close();
    }

    void incrementCheckpointTime() {
        this.fsimage.incrementCheckpointTime();
        Writable[] args = new Writable[]{new LongWritable(this.fsimage.getCheckpointTime())};
        this.logEdit((byte)103, args);
    }

    synchronized void releaseBackupStream(NamenodeRegistration registration) {
        Iterator<EditLogOutputStream> it = this.getOutputStreamIterator(JournalStream.JournalType.BACKUP);
        ArrayList<EditLogBackupOutputStream> errorStreams = null;
        NamenodeRegistration backupNode = null;
        while (it.hasNext()) {
            EditLogBackupOutputStream eStream = (EditLogBackupOutputStream)it.next();
            backupNode = eStream.getRegistration();
            if (!backupNode.getAddress().equals(registration.getAddress()) || !backupNode.isRole(registration.getRole())) continue;
            errorStreams = new ArrayList<EditLogBackupOutputStream>(1);
            errorStreams.add(eStream);
            break;
        }
        assert (backupNode == null || backupNode.isRole(HdfsConstants.NamenodeRole.BACKUP)) : "Not a backup node corresponds to a backup stream";
        this.processIOError(errorStreams, true);
    }

    synchronized boolean checkBackupRegistration(NamenodeRegistration registration) {
        Iterator<EditLogOutputStream> it = this.getOutputStreamIterator(JournalStream.JournalType.BACKUP);
        boolean regAllowed = !it.hasNext();
        NamenodeRegistration backupNode = null;
        ArrayList<EditLogBackupOutputStream> errorStreams = null;
        while (it.hasNext()) {
            EditLogBackupOutputStream eStream = (EditLogBackupOutputStream)it.next();
            backupNode = eStream.getRegistration();
            if (backupNode.getAddress().equals(registration.getAddress()) && backupNode.isRole(registration.getRole())) {
                regAllowed = true;
                break;
            }
            if (eStream.isAlive()) continue;
            if (errorStreams == null) {
                errorStreams = new ArrayList<EditLogBackupOutputStream>(1);
            }
            errorStreams.add(eStream);
            regAllowed = true;
        }
        assert (backupNode == null || backupNode.isRole(HdfsConstants.NamenodeRole.BACKUP)) : "Not a backup node corresponds to a backup stream";
        this.processIOError(errorStreams, true);
        return regAllowed;
    }

    static Options.Rename[] readRenameOptions(DataInputStream in) throws IOException {
        BytesWritable writable = new BytesWritable();
        writable.readFields((DataInput)in);
        byte[] bytes = writable.getBytes();
        Options.Rename[] options = new Options.Rename[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            options[i] = Options.Rename.valueOf((byte)bytes[i]);
        }
        return options;
    }

    static BytesWritable toBytesWritable(Options.Rename ... options) {
        byte[] bytes = new byte[options.length];
        for (int i = 0; i < options.length; ++i) {
            bytes[i] = options[i].value();
        }
        return new BytesWritable(bytes);
    }

    private class EditStreamIterator
    implements Iterator<EditLogOutputStream> {
        JournalStream.JournalType type;
        int prevIndex;
        int nextIndex;

        EditStreamIterator(JournalStream.JournalType streamType) {
            this.type = streamType;
            this.nextIndex = 0;
            this.prevIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            FSEditLog fSEditLog = FSEditLog.this;
            synchronized (fSEditLog) {
                if (FSEditLog.this.editStreams == null || FSEditLog.this.editStreams.isEmpty() || this.nextIndex >= FSEditLog.this.editStreams.size()) {
                    return false;
                }
                while (this.nextIndex < FSEditLog.this.editStreams.size() && !((EditLogOutputStream)FSEditLog.this.editStreams.get(this.nextIndex)).getType().isOfType(this.type)) {
                    ++this.nextIndex;
                }
                return this.nextIndex < FSEditLog.this.editStreams.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public EditLogOutputStream next() {
            EditLogOutputStream stream = null;
            FSEditLog fSEditLog = FSEditLog.this;
            synchronized (fSEditLog) {
                stream = (EditLogOutputStream)FSEditLog.this.editStreams.get(this.nextIndex);
                this.prevIndex = this.nextIndex++;
                while (this.nextIndex < FSEditLog.this.editStreams.size() && !((EditLogOutputStream)FSEditLog.this.editStreams.get(this.nextIndex)).getType().isOfType(this.type)) {
                    ++this.nextIndex;
                }
            }
            return stream;
        }

        @Override
        public void remove() {
            this.nextIndex = this.prevIndex;
            FSEditLog.this.removeStream(this.prevIndex);
            this.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void replace(EditLogOutputStream newStream) {
            FSEditLog fSEditLog = FSEditLog.this;
            synchronized (fSEditLog) {
                assert (0 <= this.prevIndex && this.prevIndex < FSEditLog.this.editStreams.size()) : "Index out of bound.";
                FSEditLog.this.editStreams.set(this.prevIndex, newStream);
            }
        }
    }

    static class BlockTwo
    implements Writable {
        long blkid = 0L;
        long len = 0L;

        BlockTwo() {
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.blkid);
            out.writeLong(this.len);
        }

        public void readFields(DataInput in) throws IOException {
            this.blkid = in.readLong();
            this.len = in.readLong();
        }

        static {
            WritableFactories.setFactory(BlockTwo.class, (WritableFactory)new WritableFactory(){

                public Writable newInstance() {
                    return new BlockTwo();
                }
            });
        }
    }

    private static class TransactionId {
        public long txid;

        TransactionId(long value) {
            this.txid = value;
        }
    }
}

