/*
 * Decompiled with CFR 0.152.
 */
package okuyama.base.util;

import java.io.File;
import java.net.URL;
import okuyama.base.util.ILogger;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;

public class DefaultLogger
implements ILogger {
    Logger logger = null;

    public DefaultLogger(Class clazz) {
        if (new File("log4j.properties").exists()) {
            this.logger = Logger.getLogger((Class)clazz);
            PropertyConfigurator.configure((String)"log4j.properties");
        } else if (DefaultLogger.class.getResource("/log4j.properties") != null) {
            this.logger = Logger.getLogger((Class)clazz);
            PropertyConfigurator.configure((URL)DefaultLogger.class.getResource("/log4j.properties"));
        } else {
            RollingFileAppender rollingFileAppender = null;
            this.logger = Logger.getLogger((Class)clazz);
            this.logger.setLevel(Level.ERROR);
            PatternLayout layout = new PatternLayout("%d %5p %c{1} - %m%n");
            try {
                rollingFileAppender = new RollingFileAppender((Layout)layout, "okuyama_default.log");
                rollingFileAppender.setMaxFileSize("128MB");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            this.logger.addAppender((Appender)rollingFileAppender);
        }
    }

    public DefaultLogger(Class clazz, String configFile) {
        this.logger = Logger.getLogger((Class)clazz);
        PropertyConfigurator.configure((String)configFile);
    }

    @Override
    public void trace(Object message) {
        this.logger.trace(message);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.logger.trace(message, t);
    }

    @Override
    public void debug(Object message) {
        this.logger.debug(message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.logger.debug(message, t);
    }

    @Override
    public void info(Object message) {
        this.logger.info(message);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.logger.info(message, t);
    }

    @Override
    public void error(Object message) {
        this.logger.error(message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.logger.error(message, t);
    }

    @Override
    public void fatal(Object message) {
        this.logger.fatal(message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.logger.fatal(message, t);
    }

    @Override
    public void warn(Object message) {
        this.logger.warn(message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.logger.warn(message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }
}

