/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.client.result;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import okuyama.imdst.client.OkuyamaClient;
import okuyama.imdst.client.OkuyamaClientException;
import okuyama.imdst.client.OkuyamaResultSet;
import okuyama.imdst.client.UserDataFilter;

public class OkuyamaTagKeysResultSet
implements OkuyamaResultSet {
    protected int maxMultiGetSize = 100;
    protected OkuyamaClient client = null;
    protected String tagStr = null;
    protected String[] indexList = null;
    protected String encoding = null;
    protected double[] rangeSet = null;
    protected String matchPatternStr = null;
    protected int matchType = -1;
    protected UserDataFilter filter = null;
    private int nowIndex = 0;
    private boolean closeFlg = true;
    private LinkedBlockingQueue indexQueue = null;
    private LinkedBlockingQueue keyQueue = null;
    private LinkedBlockingQueue keyValueQueue = null;
    private String nowKey = null;
    private String nowValue = null;
    private boolean dataNull = false;

    public OkuyamaTagKeysResultSet() {
        this.dataNull = true;
    }

    public OkuyamaTagKeysResultSet(OkuyamaClient client, String tagStr, String[] indexList, String encoding) {
        this.client = client;
        this.tagStr = tagStr;
        this.indexList = indexList;
        this.encoding = encoding;
        this.indexQueue = new LinkedBlockingQueue();
        this.keyQueue = new LinkedBlockingQueue();
        this.keyValueQueue = new LinkedBlockingQueue();
        this.closeFlg = false;
        try {
            for (int idx = 0; idx < this.indexList.length; ++idx) {
                this.indexQueue.put(this.indexList[idx]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public OkuyamaTagKeysResultSet(OkuyamaClient client, String tagStr, String[] indexList, String encoding, double[] rangeSet, int matchType) {
        this(client, tagStr, indexList, encoding);
        this.rangeSet = rangeSet;
        this.matchType = matchType;
    }

    public OkuyamaTagKeysResultSet(OkuyamaClient client, String tagStr, String[] indexList, String encoding, String matchPatternStr, int matchType) {
        this(client, tagStr, indexList, encoding);
        this.matchPatternStr = matchPatternStr;
        this.matchType = matchType;
    }

    public OkuyamaTagKeysResultSet(OkuyamaClient client, String tagStr, String[] indexList, String encoding, UserDataFilter filter) {
        this.client = client;
        this.tagStr = tagStr;
        this.indexList = indexList;
        this.encoding = encoding;
        this.filter = filter;
        this.indexQueue = new LinkedBlockingQueue();
        this.keyQueue = new LinkedBlockingQueue();
        this.keyValueQueue = new LinkedBlockingQueue();
        this.closeFlg = false;
        try {
            for (int idx = 0; idx < this.indexList.length; ++idx) {
                this.indexQueue.put(this.indexList[idx]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public boolean next() throws OkuyamaClientException {
        if (this.dataNull) {
            return false;
        }
        try {
            while (true) {
                String[] keyValue;
                if (this.matchType == -1 && this.filter == null) {
                    if (this.keyValueQueue.size() > 0) {
                        keyValue = (String[])this.keyValueQueue.take();
                        this.nowKey = keyValue[0];
                        this.nowValue = keyValue[1];
                        return true;
                    }
                } else if (this.filter != null) {
                    while (this.keyValueQueue.size() > 0) {
                        keyValue = (String[])this.keyValueQueue.take();
                        this.nowKey = keyValue[0];
                        this.nowValue = keyValue[1];
                        if (!this.filter.filter(this.nowKey, this.nowValue)) continue;
                        return true;
                    }
                } else if (this.matchPatternStr != null) {
                    while (this.keyValueQueue.size() > 0) {
                        keyValue = (String[])this.keyValueQueue.take();
                        this.nowKey = keyValue[0];
                        this.nowValue = keyValue[1];
                        if (this.matchType == 1 ? this.nowKey == null || !this.nowKey.matches(this.matchPatternStr) : (this.matchType == 2 ? this.nowValue == null || !this.nowValue.matches(this.matchPatternStr) : this.matchType == 3 && (this.nowKey == null || this.nowValue == null || !this.nowKey.matches(this.matchPatternStr) || !this.nowValue.matches(this.matchPatternStr)))) continue;
                        return true;
                    }
                } else if (this.rangeSet != null) {
                    while (this.keyValueQueue.size() > 0) {
                        double check;
                        keyValue = (String[])this.keyValueQueue.take();
                        this.nowKey = keyValue[0];
                        this.nowValue = keyValue[1];
                        if (this.matchType == 1) {
                            check = Double.parseDouble(this.nowKey);
                            if (this.rangeSet[0] > check || this.rangeSet[1] < check) {
                                continue;
                            }
                        } else if (this.matchType == 2) {
                            check = Double.parseDouble(this.nowValue);
                            if (this.rangeSet[0] > check || this.rangeSet[1] < check) {
                                continue;
                            }
                        } else if (this.matchType == 3) {
                            double checkKey = Double.parseDouble(this.nowKey);
                            double checkVal = Double.parseDouble(this.nowValue);
                            if (this.rangeSet[0] > checkKey || this.rangeSet[1] < checkKey || this.rangeSet[0] > checkVal || this.rangeSet[1] < checkVal) continue;
                        }
                        return true;
                    }
                }
                while (this.keyQueue.size() > 0) {
                    String tmpKey;
                    ArrayList<String> keys = new ArrayList<String>(this.maxMultiGetSize);
                    for (int idx = 0; idx < this.maxMultiGetSize && (tmpKey = (String)this.keyQueue.poll()) != null; ++idx) {
                        keys.add(tmpKey);
                    }
                    if (keys.size() > 0) {
                        String[] getMultiKeys = new String[keys.size()];
                        for (int idx = 0; idx < keys.size(); ++idx) {
                            getMultiKeys[idx] = (String)keys.get(idx);
                        }
                        Map<String, String> keyValueRetMap = null;
                        if (getMultiKeys.length > 1) {
                            keyValueRetMap = this.client.getMultiValue(getMultiKeys, this.encoding);
                        } else {
                            keyValueRetMap = new HashMap();
                            String[] singleGetRet = this.client.getValue(getMultiKeys[0], this.encoding);
                            if (singleGetRet[0].equals("true")) {
                                keyValueRetMap.put(getMultiKeys[0], singleGetRet[1]);
                            }
                        }
                        if (keyValueRetMap != null && keyValueRetMap.size() > 0) {
                            Set entrySet = keyValueRetMap.entrySet();
                            for (Map.Entry obj : entrySet) {
                                String[] keyValueTmp = new String[]{(String)obj.getKey(), (String)obj.getValue()};
                                this.keyValueQueue.put(keyValueTmp);
                            }
                        }
                    }
                    if (this.keyValueQueue.size() <= 0) continue;
                    break;
                }
                if (this.keyValueQueue.size() > 0) continue;
                while (this.indexQueue.size() > 0) {
                    String buketIdxStr = (String)this.indexQueue.take();
                    Object[] bucketKeysRet = this.client.getTargetIndexTagKeys(this.tagStr, buketIdxStr);
                    if (bucketKeysRet[0].equals("true")) {
                        String[] keysStrList = (String[])bucketKeysRet[1];
                        for (int idx = 0; idx < keysStrList.length; ++idx) {
                            this.keyQueue.put(keysStrList[idx]);
                        }
                    }
                    if (this.keyQueue.size() <= 0) continue;
                    break;
                }
                if (this.keyQueue.size() <= 0 && this.indexQueue.size() < 1) break;
            }
        }
        catch (Exception e) {
            throw new OkuyamaClientException(e);
        }
        return false;
    }

    @Override
    public Object getKey() throws OkuyamaClientException {
        return this.nowKey;
    }

    @Override
    public Object getValue() throws OkuyamaClientException {
        return this.nowValue;
    }

    @Override
    public void close() throws OkuyamaClientException {
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
                this.tagStr = null;
                this.indexList = null;
                this.nowIndex = -1;
                this.indexQueue = null;
                this.keyQueue = null;
                this.keyValueQueue = null;
            }
            this.closeFlg = true;
        }
        catch (Exception e) {
            throw new OkuyamaClientException(e);
        }
    }

    @Override
    public boolean isClose() {
        return this.closeFlg;
    }
}

