/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.job;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;
import okuyama.base.job.AbstractJob;
import okuyama.base.job.IJob;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.util.DataDispatcher;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.StatusUtil;

public class MasterManagerJob
extends AbstractJob
implements IJob {
    private String bindIpAddress = null;
    private int portNo = 8888;
    private int backLog = 50;
    private int maxConnectParallelExecution = 10;
    private long maxConnectParallelQueue = 3L;
    private String[] maxConnectParallelQueueNames = null;
    private int maxAcceptParallelExecution = 15;
    private long maxAcceptParallelQueue = 5L;
    private String[] maxAcceptParallelQueueNames = null;
    private int maxWorkerParallelExecution = 15;
    private int maxWorkerParallelQueue = 5;
    private String[] maxWorkerParallelQueueNames = null;
    private boolean loadBalance = false;
    private Boolean noBalance = new Boolean(false);
    private int balancePattern = 10;
    private Boolean[] balanceModes = null;
    private int nowBalanceIdx = 0;
    private boolean transactionMode = false;
    private String mode = "okuyama";
    ServerSocket serverSocket = null;
    private static ILogger logger = LoggerFactory.createLogger(MasterManagerJob.class);

    @Override
    public void initJob(String initValue) {
        String queueSizeStr;
        String sizeStr;
        String executionMethodsStr;
        String[] splitInitVal;
        logger.debug("MasterManagerJob - initJob - start");
        logger.info("okuyama MasterNode Initialization Start ...");
        System.out.println("okuyama MasterNode Initialization Start ...");
        if (initValue.indexOf(":") != -1) {
            splitInitVal = initValue.split(":");
            this.bindIpAddress = splitInitVal[0];
            if (splitInitVal[1].indexOf("&") != -1) {
                splitInitVal = splitInitVal[1].split("&");
                this.portNo = Integer.parseInt(splitInitVal[0]);
                this.backLog = Integer.parseInt(splitInitVal[1]);
            } else {
                this.portNo = Integer.parseInt(splitInitVal[1]);
            }
        } else if (initValue.indexOf("&") != -1) {
            splitInitVal = initValue.split("&");
            this.portNo = Integer.parseInt(splitInitVal[0]);
            this.backLog = Integer.parseInt(splitInitVal[1]);
        } else {
            this.portNo = Integer.parseInt(initValue);
        }
        String keyMapDelayWrite = super.getPropertiesValue("KeyMapDelayWrite");
        if (keyMapDelayWrite != null && keyMapDelayWrite.equals("true")) {
            ImdstDefine.delayWriteFlg = true;
        }
        if ((executionMethodsStr = super.getPropertiesValue("ExecutionMethods")) != null && !executionMethodsStr.trim().equals("")) {
            String[] methodNoList = executionMethodsStr.split(",");
            StatusUtil.initExecuteMethodList(methodNoList);
        }
        if ((sizeStr = super.getPropertiesValue("MasterNodeMaxConnectParallelExecution")) != null && Integer.parseInt(sizeStr) > this.maxConnectParallelExecution) {
            this.maxConnectParallelExecution = Integer.parseInt(sizeStr);
        }
        if ((queueSizeStr = super.getPropertiesValue("MasterNodeMaxConnectParallelQueue")) != null && this.maxConnectParallelExecution > Integer.parseInt(queueSizeStr) * 2) {
            this.maxConnectParallelQueue = Integer.parseInt(queueSizeStr);
        } else if (queueSizeStr != null) {
            this.maxConnectParallelQueue = this.maxConnectParallelExecution / 2;
        }
        this.maxConnectParallelQueueNames = new String[new Long(this.maxConnectParallelQueue).intValue()];
        sizeStr = super.getPropertiesValue("MasterNodeMaxAcceptParallelExecution");
        if (sizeStr != null && Integer.parseInt(sizeStr) > this.maxAcceptParallelExecution) {
            this.maxAcceptParallelExecution = Integer.parseInt(sizeStr);
        }
        if ((queueSizeStr = super.getPropertiesValue("MasterNodeMaxAcceptParallelQueue")) != null && this.maxAcceptParallelExecution > Integer.parseInt(queueSizeStr) * 2) {
            this.maxAcceptParallelQueue = Integer.parseInt(queueSizeStr);
        } else if (queueSizeStr != null) {
            this.maxAcceptParallelQueue = this.maxAcceptParallelExecution / 2;
        }
        this.maxAcceptParallelQueueNames = new String[new Long(this.maxAcceptParallelQueue).intValue()];
        sizeStr = super.getPropertiesValue("MasterNodeMaxWorkerParallelExecution");
        if (sizeStr != null) {
            this.maxWorkerParallelExecution = Integer.parseInt(sizeStr);
        }
        if ((queueSizeStr = super.getPropertiesValue("MasterNodeMaxWorkerParallelQueue")) != null && this.maxWorkerParallelExecution > Integer.parseInt(queueSizeStr) * 2) {
            this.maxWorkerParallelQueue = Integer.parseInt(queueSizeStr);
        } else if (queueSizeStr != null) {
            this.maxWorkerParallelQueue = this.maxWorkerParallelExecution / 2;
        }
        this.maxWorkerParallelQueueNames = new String[new Long(this.maxWorkerParallelQueue).intValue()];
        this.balanceModes = new Boolean[this.balancePattern];
        this.balanceModes[0] = new Boolean(false);
        this.balanceModes[1] = new Boolean(false);
        this.balanceModes[2] = new Boolean(false);
        this.balanceModes[3] = new Boolean(false);
        this.balanceModes[4] = new Boolean(false);
        this.balanceModes[5] = new Boolean(false);
        this.balanceModes[6] = new Boolean(false);
        this.balanceModes[7] = new Boolean(true);
        this.balanceModes[8] = new Boolean(true);
        this.balanceModes[9] = new Boolean(true);
        int ratio = 10;
        String ratioStr = super.getPropertiesValue("BalanceRatio");
        if (ratioStr != null && !ratioStr.trim().equals("")) {
            String[] ratioStrs = ratioStr.split(":");
            try {
                if (Integer.parseInt(ratioStrs[0]) + Integer.parseInt(ratioStrs[1]) == 10) {
                    for (int i = 0; i < 10; ++i) {
                        if (i < Integer.parseInt(ratioStrs[0])) continue;
                        this.balanceModes[i] = new Boolean(true);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        logger.debug("MasterManagerJob - initJob - end");
    }

    @Override
    public String executeJob(String optionParam) throws BatchException {
        logger.debug("MasterManagerJob - executeJob - start");
        String ret = SUCCESS;
        try {
            if (DataDispatcher.isStandby() && StatusUtil.isStandby()) {
                if (StatusUtil.getDistributionAlgorithm().equals("mod")) {
                    ret = this.executeModMasterServer(optionParam);
                } else if (StatusUtil.getDistributionAlgorithm().equals("consistenthash")) {
                    ret = this.executeConsistentHashMasterServer(optionParam);
                }
            }
        }
        catch (Exception e) {
            logger.error("MasterManagerJob - executeJob - Error", e);
            throw new BatchException(e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String executeModMasterServer(String optionParam) throws Exception {
        String ret = SUCCESS;
        Object[] helperParams = null;
        int paramSize = 9;
        Object transactionManagerInfos = null;
        Socket socket = null;
        long queueIndex = 0L;
        long accessCount = 0L;
        try {
            int i;
            String userIsolationMode;
            String loadBalanceStr;
            if (optionParam != null && !optionParam.trim().equals("")) {
                this.mode = optionParam;
            }
            if ((loadBalanceStr = super.getPropertiesValue("LoadBalanceMode")) != null) {
                this.loadBalance = new Boolean(loadBalanceStr);
            }
            if ((userIsolationMode = super.getPropertiesValue("IsolationMode")) != null && userIsolationMode.equals("true")) {
                String isolationPrefix = super.getPropertiesValue("IsolationPrefix");
                if (isolationPrefix != null && isolationPrefix.trim().length() == 5) {
                    StatusUtil.initIsolationMode(true, isolationPrefix);
                    System.out.println("Isolation Mode Isolation Prefix = [" + isolationPrefix + "]");
                } else {
                    String string = ERROR;
                    return string;
                }
            }
            InetSocketAddress bindAddress = null;
            bindAddress = this.bindIpAddress == null ? new InetSocketAddress(this.portNo) : new InetSocketAddress(this.bindIpAddress, this.portNo);
            this.serverSocket = new ServerSocket();
            this.serverSocket.bind(bindAddress, this.backLog);
            super.setJobShareParam(super.getJobName() + "_ServeSocket", this.serverSocket);
            int i2 = 0;
            while ((long)i2 < this.maxConnectParallelQueue) {
                super.createUniqueHelperParamQueue("MasterManagerConnectHelper" + i2, 10000);
                this.maxConnectParallelQueueNames[i2] = "MasterManagerConnectHelper" + i2;
                ++i2;
            }
            i2 = 0;
            while ((long)i2 < this.maxAcceptParallelQueue) {
                super.createUniqueHelperParamQueue("MasterManagerAcceptHelper" + i2, 10000);
                this.maxAcceptParallelQueueNames[i2] = "MasterManagerAcceptHelper" + i2;
                ++i2;
            }
            for (i2 = 0; i2 < this.maxWorkerParallelQueue; ++i2) {
                super.createUniqueHelperParamQueue("MasterManagerHelper" + i2, 10000);
                this.maxWorkerParallelQueueNames[i2] = "MasterManagerHelper" + i2;
            }
            for (i2 = 0; i2 < this.maxConnectParallelExecution; ++i2) {
                queueIndex = (long)(i2 + 1) % this.maxConnectParallelQueue;
                helperParams = new Object[]{"MasterManagerConnectHelper" + queueIndex, this.maxAcceptParallelQueueNames};
                super.executeHelper("MasterManagerConnectHelper", helperParams, true);
            }
            for (i2 = 0; i2 < this.maxAcceptParallelExecution; ++i2) {
                queueIndex = (long)(i2 + 1) % this.maxAcceptParallelQueue;
                helperParams = new Object[]{"MasterManagerAcceptHelper" + queueIndex, this.maxWorkerParallelQueueNames};
                super.executeHelper("MasterManagerAcceptHelper", helperParams, true);
            }
            Object[] helperShareParams = new Object[this.maxWorkerParallelQueue * 2];
            queueIndex = 0L;
            for (i = 0; i < this.maxWorkerParallelQueue * 2; i += 2) {
                helperShareParams[i] = "Bind-MasterManagerHelper" + queueIndex;
                helperShareParams[i + 1] = new AtomicInteger(0);
                ++queueIndex;
            }
            queueIndex = 0L;
            for (i = 0; i < this.maxWorkerParallelExecution; ++i) {
                queueIndex = (i + 1) % this.maxWorkerParallelQueue;
                AtomicInteger queueBindHelperCount = (AtomicInteger)helperShareParams[new Long(queueIndex).intValue() * 2 + 1];
                queueBindHelperCount.getAndIncrement();
                helperShareParams[new Long((long)queueIndex).intValue() * 2 + 1] = queueBindHelperCount;
            }
            queueIndex = 0L;
            for (i = 0; i < this.maxWorkerParallelExecution; ++i) {
                queueIndex = (i + 1) % this.maxWorkerParallelQueue;
                helperParams = new Object[paramSize];
                helperParams[0] = null;
                helperParams[1] = null;
                helperParams[2] = this.mode;
                helperParams[3] = null;
                helperParams[4] = StatusUtil.isTransactionMode();
                helperParams[5] = StatusUtil.getTransactionNode();
                helperParams[6] = "MasterManagerHelper" + queueIndex;
                helperParams[7] = this.maxAcceptParallelQueueNames;
                helperParams[8] = "Bind-MasterManagerHelper" + queueIndex;
                if (i == 0) {
                    super.executeHelper("MasterManagerHelper", helperParams, true, helperShareParams);
                    continue;
                }
                super.executeHelper("MasterManagerHelper", helperParams, true);
            }
            logger.info("okuyama MasterNode Initialization End ...");
            System.out.println("okuyama MasterNode Initialization End ...");
            logger.info("okuyama MasterNode start ...");
            logger.info("listening on " + bindAddress);
            System.out.println("okuyama MasterNode start");
            System.out.println("listening on " + bindAddress);
            while (StatusUtil.getStatus() != 1) {
                if (StatusUtil.getStatus() == 2) {
                    return ret;
                }
                try {
                    Object[] queueParam = new Object[2];
                    queueParam[1] = this.loadBalance ? this.balanceModes[new Long(accessCount % (long)this.balancePattern).intValue()] : this.noBalance;
                    socket = this.serverSocket.accept();
                    queueParam[0] = socket;
                    super.addSpecificationParameterQueue("MasterManagerConnectHelper" + accessCount % this.maxConnectParallelQueue, queueParam);
                    ++accessCount;
                }
                catch (IOException ie) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException ie2) {}
                    continue;
                    finally {
                        try {
                            this.serverSocket = new ServerSocket();
                            this.serverSocket.bind(bindAddress, this.backLog);
                            super.setJobShareParam(super.getJobName() + "_ServeSocket", this.serverSocket);
                        }
                        catch (IOException ie3) {
                            return ret;
                        }
                    }
                }
                catch (Exception e) {
                    if (StatusUtil.getStatus() == 2) {
                        logger.info("MasterManagerJob - executeJob - ServerEnd");
                        return ret;
                    }
                    logger.error("", e);
                }
            }
            return ret;
        }
        catch (Exception e) {
            logger.error("MasterManagerJob - executeJob - Error", e);
            throw new BatchException(e);
        }
        finally {
            try {
                this.serverSocket.close();
            }
            catch (Exception e2) {}
            logger.info("okuyama MasterNode shutdown ...");
            System.out.println("okuyama MasterNode shutdown");
        }
    }

    private String executeConsistentHashMasterServer(String optionParam) throws Exception {
        return this.executeModMasterServer(optionParam);
    }
}

