/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.io.ByteArrayOutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import okuyama.imdst.util.CoreFileBaseKeyMap;
import okuyama.imdst.util.DelayWriteCoreFileBaseKeyMap;
import okuyama.imdst.util.FileBaseDataMapSet;
import okuyama.imdst.util.FixWriteCoreFileBaseKeyMap;
import okuyama.imdst.util.JavaSystemApi;
import org.apache.commons.codec.digest.DigestUtils;

public class FileBaseDataMap
extends AbstractMap {
    private CoreFileBaseKeyMap[] coreFileBaseKeyMaps = null;
    private CoreFileBaseKeyMap coreFileBaseKeyMap4BigData = null;
    private CoreFileBaseKeyMap coreFileBaseKeyMap4MiddleData = null;
    private int coreMapType = 0;
    private int regularSizeLimit = 0;
    private int middleSize = 0;
    private String[] dirs = null;
    private int numberOfCoreMap = 0;
    private int innerCacheSizeTotal = 1024;
    private Object syncObj = null;
    private int iteratorIndex = 0;
    private List iteratorNowDataList = null;
    private int iteratorNowDataListIdx = 0;
    protected static int paddingSymbol = 38;
    protected static byte[] paddingSymbolSet = new byte[]{38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38};
    protected static String paddingSymbolSetString = new String(paddingSymbolSet);
    protected static ByteArrayOutputStream fillStream = null;

    public FileBaseDataMap(String[] baseDirs, int numberOfKeyData) {
        this(baseDirs, numberOfKeyData, 0.4);
    }

    public FileBaseDataMap(String[] baseDirs, int numberOfKeyData, double cacheMemPercent) {
        this(baseDirs, numberOfKeyData, cacheMemPercent, 0);
    }

    public FileBaseDataMap(String[] baseDirs, int numberOfKeyData, double cacheMemPercent, int numberOfValueLength) {
        this(baseDirs, numberOfKeyData, cacheMemPercent, numberOfValueLength, 1024, 103424);
    }

    public FileBaseDataMap(String[] baseDirs, int numberOfKeyData, double cacheMemPercent, int numberOfValueLength, int regularSizeLimit, int middleSizeLimit) {
        this.regularSizeLimit = regularSizeLimit;
        this.dirs = baseDirs;
        this.numberOfCoreMap = baseDirs.length;
        this.syncObj = new Object();
        long maxMem = JavaSystemApi.getRuntimeMaxMem("K");
        long cacheMem = new Double((double)maxMem * cacheMemPercent).longValue();
        this.innerCacheSizeTotal = new Long(cacheMem).intValue() / 128;
        int oneCacheSizePer = this.innerCacheSizeTotal / this.numberOfCoreMap;
        int oneMapSizePer = numberOfKeyData / this.numberOfCoreMap;
        if (numberOfValueLength == 15) {
            this.coreFileBaseKeyMaps = new DelayWriteCoreFileBaseKeyMap[baseDirs.length];
        } else if (numberOfValueLength > 0) {
            String[] bigDataDir;
            if (numberOfValueLength > middleSizeLimit) {
                this.coreMapType = 2;
                bigDataDir = new String[]{baseDirs[0] + "/virtualbigdata1/", baseDirs[0] + "/virtualbigdata2/"};
                this.coreFileBaseKeyMap4BigData = new FixWriteCoreFileBaseKeyMap(bigDataDir, oneCacheSizePer / 3, oneMapSizePer / 3, numberOfValueLength);
                this.middleSize = middleSizeLimit;
                String[] middleDataDir = new String[]{baseDirs[0] + "/virtualmiddledata1/", baseDirs[0] + "/virtualmiddledata2/"};
                this.coreFileBaseKeyMap4MiddleData = new FixWriteCoreFileBaseKeyMap(middleDataDir, oneCacheSizePer / 3, oneMapSizePer / 3, this.middleSize);
            } else if (numberOfValueLength > regularSizeLimit) {
                this.coreMapType = 1;
                bigDataDir = new String[]{baseDirs[0] + "/virtualbigdata1/", baseDirs[0] + "/virtualbigdata2/"};
                this.coreFileBaseKeyMap4BigData = new FixWriteCoreFileBaseKeyMap(bigDataDir, oneCacheSizePer / 2, oneMapSizePer / 2, numberOfValueLength);
            }
            this.coreFileBaseKeyMaps = new FixWriteCoreFileBaseKeyMap[baseDirs.length];
        } else {
            this.coreFileBaseKeyMaps = new DelayWriteCoreFileBaseKeyMap[baseDirs.length];
        }
        for (int idx = 0; idx < baseDirs.length; ++idx) {
            String[] dir = new String[]{baseDirs[idx]};
            if (numberOfValueLength == 15) {
                this.coreFileBaseKeyMaps[idx] = new DelayWriteCoreFileBaseKeyMap(dir, oneCacheSizePer, oneMapSizePer, 15);
                continue;
            }
            if (numberOfValueLength > 0) {
                this.coreFileBaseKeyMaps[idx] = numberOfValueLength > regularSizeLimit ? new FixWriteCoreFileBaseKeyMap(dir, oneCacheSizePer, oneMapSizePer, regularSizeLimit) : new FixWriteCoreFileBaseKeyMap(dir, oneCacheSizePer, oneMapSizePer, numberOfValueLength);
                fillStream = new ByteArrayOutputStream(4096);
                for (int i = 0; i < 8; ++i) {
                    fillStream.write(paddingSymbolSet, 0, 512);
                }
                continue;
            }
            this.coreFileBaseKeyMaps[idx] = new DelayWriteCoreFileBaseKeyMap(dir, oneCacheSizePer, oneMapSizePer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        int hashCode = FileBaseDataMap.createHashCode((String)key);
        Object object = this.syncObj;
        synchronized (object) {
            if (this.coreMapType != 0) {
                String valueStr = (String)value;
                byte[] valueStrBytes = valueStr.getBytes();
                if (this.coreMapType == 1) {
                    if (valueStrBytes.length > this.regularSizeLimit) {
                        this.coreFileBaseKeyMap4BigData.put((String)key, valueStr, hashCode);
                        this.coreFileBaseKeyMaps[hashCode % this.numberOfCoreMap].put((String)key, "*", hashCode);
                    } else {
                        this.coreFileBaseKeyMaps[hashCode % this.numberOfCoreMap].put((String)key, valueStr, hashCode);
                    }
                } else if (this.coreMapType == 2) {
                    if (valueStrBytes.length > this.middleSize) {
                        this.coreFileBaseKeyMap4BigData.put((String)key, valueStr, hashCode);
                        this.coreFileBaseKeyMap4MiddleData.remove((String)key, hashCode);
                        this.coreFileBaseKeyMaps[hashCode % this.numberOfCoreMap].put((String)key, "*", hashCode);
                    } else if (valueStrBytes.length > this.regularSizeLimit) {
                        this.coreFileBaseKeyMap4MiddleData.put((String)key, valueStr, hashCode);
                        this.coreFileBaseKeyMap4BigData.remove((String)key, hashCode);
                        this.coreFileBaseKeyMaps[hashCode % this.numberOfCoreMap].put((String)key, "**", hashCode);
                    } else {
                        this.coreFileBaseKeyMaps[hashCode % this.numberOfCoreMap].put((String)key, valueStr, hashCode);
                    }
                }
            } else {
                this.coreFileBaseKeyMaps[hashCode % this.numberOfCoreMap].put((String)key, (String)value, hashCode);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        String ret = null;
        int hashCode = FileBaseDataMap.createHashCode((String)key);
        Object object = this.syncObj;
        synchronized (object) {
            ret = this.coreFileBaseKeyMaps[hashCode % this.numberOfCoreMap].get((String)key, hashCode);
            if (this.coreMapType != 0) {
                if (ret != null && ret.equals("*")) {
                    ret = this.coreFileBaseKeyMap4BigData.get((String)key, hashCode);
                } else if (ret != null && ret.equals("**")) {
                    ret = this.coreFileBaseKeyMap4MiddleData.get((String)key, hashCode);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        String ret = null;
        int hashCode = FileBaseDataMap.createHashCode((String)key);
        Object object = this.syncObj;
        synchronized (object) {
            ret = this.coreFileBaseKeyMaps[hashCode % this.numberOfCoreMap].remove((String)key, hashCode);
            if (this.coreMapType != 0 && ret != null && ret.equals("*")) {
                ret = this.coreFileBaseKeyMap4BigData.remove((String)key, hashCode);
            } else if (this.coreMapType != 0 && ret != null && ret.equals("**")) {
                ret = this.coreFileBaseKeyMap4MiddleData.remove((String)key, hashCode);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        boolean ret = true;
        int hashCode = FileBaseDataMap.createHashCode((String)key);
        Object object = this.syncObj;
        synchronized (object) {
            if (this.coreFileBaseKeyMaps[hashCode % this.numberOfCoreMap].get((String)key, hashCode) == null) {
                ret = false;
            }
        }
        return ret;
    }

    @Override
    public int size() {
        int ret = 0;
        for (int idx = 0; idx < this.coreFileBaseKeyMaps.length; ++idx) {
            ret += this.coreFileBaseKeyMaps[idx].getTotalSize().intValue();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        for (int i = 0; i < this.coreFileBaseKeyMaps.length; ++i) {
            Object object = this.syncObj;
            synchronized (object) {
                this.coreFileBaseKeyMaps[i].clear();
                this.coreFileBaseKeyMaps[i].init();
                if (this.coreMapType > 0) {
                    this.coreFileBaseKeyMap4BigData.clear();
                    this.coreFileBaseKeyMap4BigData.init();
                }
                if (this.coreMapType > 1) {
                    this.coreFileBaseKeyMap4MiddleData.clear();
                    this.coreFileBaseKeyMap4MiddleData.init();
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishClear() {
        for (int i = 0; i < this.coreFileBaseKeyMaps.length; ++i) {
            Object object = this.syncObj;
            synchronized (object) {
                this.coreFileBaseKeyMaps[i].clear();
                if (this.coreMapType > 0) {
                    this.coreFileBaseKeyMap4BigData.clear();
                }
                if (this.coreMapType > 1) {
                    this.coreFileBaseKeyMap4MiddleData.clear();
                }
                continue;
            }
        }
    }

    @Override
    public Set entrySet() {
        FileBaseDataMapSet ret = new FileBaseDataMapSet(this);
        return ret;
    }

    public void iteratorInit() {
        block2: {
            this.iteratorIndex = 0;
            this.iteratorNowDataList = new ArrayList();
            this.iteratorNowDataListIdx = 0;
            for (int i = 0; i < this.coreFileBaseKeyMaps.length; ++i) {
                this.coreFileBaseKeyMaps[i].startKeyIteration();
            }
            if (this.iteratorIndex >= this.coreFileBaseKeyMaps.length) break block2;
            do {
                this.iteratorNowDataList = this.coreFileBaseKeyMaps[this.iteratorIndex].getAllOneFileInKeys();
            } while (this.iteratorNowDataList != null && this.iteratorNowDataList.size() <= 0);
        }
    }

    public boolean hasIteratorNext() {
        if (this.iteratorNowDataList == null) {
            return false;
        }
        return this.iteratorNowDataList.size() > this.iteratorNowDataListIdx;
    }

    public Object nextIteratorKey() {
        String ret;
        block6: {
            ret = null;
            ret = (String)this.iteratorNowDataList.get(this.iteratorNowDataListIdx);
            ++this.iteratorNowDataListIdx;
            if (this.iteratorNowDataList.size() == this.iteratorNowDataListIdx) {
                if (this.iteratorIndex < this.coreFileBaseKeyMaps.length) {
                    while (true) {
                        this.iteratorNowDataList = this.coreFileBaseKeyMaps[this.iteratorIndex].getAllOneFileInKeys();
                        this.iteratorNowDataListIdx = 0;
                        if (this.iteratorNowDataList == null && this.iteratorIndex < this.coreFileBaseKeyMaps.length) {
                            ++this.iteratorIndex;
                            if (this.iteratorIndex != this.coreFileBaseKeyMaps.length) continue;
                            break block6;
                        }
                        if (this.iteratorNowDataList == null) {
                            this.iteratorNowDataList = null;
                            this.iteratorNowDataListIdx = 0;
                            ++this.iteratorIndex;
                        }
                        if (this.iteratorNowDataList.size() > 0) break;
                    }
                    this.iteratorNowDataListIdx = 0;
                } else {
                    this.iteratorNowDataList = null;
                    this.iteratorNowDataListIdx = 0;
                }
            }
        }
        return ret;
    }

    protected static int createHashCode(String key) {
        int hashCode = new String(DigestUtils.sha((byte[])key.getBytes())).hashCode();
        if (hashCode < 0) {
            hashCode = hashCode - hashCode - hashCode;
        }
        return hashCode;
    }
}

