/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import okuyama.imdst.util.CacheContainer;

class InnerCache
extends LinkedHashMap {
    private boolean fileWrite = false;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private int maxCacheSize = -1;
    public Object syncObj = new Object();

    public InnerCache() {
        super(512, 0.75f, true);
        this.maxCacheSize = 64;
    }

    public InnerCache(int maxCacheCapacity) {
        super(maxCacheCapacity, 0.75f, true);
        this.maxCacheSize = maxCacheCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        this.w.lock();
        try {
            Object object = super.put(key, value);
            return object;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        this.r.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        this.r.lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        this.w.lock();
        try {
            Object v = super.remove(key);
            return v;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.w.lock();
        try {
            Set workEntrySet = this.entrySet();
            Iterator workEntryIte = workEntrySet.iterator();
            Object workKey = null;
            while (workEntryIte.hasNext()) {
                Map.Entry obj = workEntryIte.next();
                CacheContainer accessor = (CacheContainer)obj.getValue();
                try {
                    if (accessor == null) continue;
                    if (accessor.raf != null) {
                        accessor.raf.close();
                        accessor.raf = null;
                    }
                    if (accessor.wr != null) {
                        accessor.wr.close();
                        accessor.wr = null;
                    }
                    accessor.isClosed = true;
                    obj.setValue(accessor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            super.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        boolean ret = false;
        if (this.size() > this.maxCacheSize) {
            CacheContainer accessor = (CacheContainer)eldest.getValue();
            try {
                if (accessor != null) {
                    if (accessor.raf != null) {
                        accessor.raf.close();
                        accessor.raf = null;
                    }
                    if (accessor.wr != null) {
                        accessor.wr.close();
                        accessor.wr = null;
                    }
                    accessor.isClosed = true;
                    eldest.setValue(accessor);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ret = true;
        }
        return ret;
    }

    public int getSize() {
        return this.size();
    }
}

