/*
 * Decompiled with CFR 0.152.
 */
package okuyama.base;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import okuyama.base.IJobController;
import okuyama.base.job.AbstractJob;
import okuyama.base.lang.BatchException;
import okuyama.base.parameter.config.BatchConfig;
import okuyama.base.parameter.config.ConfigFolder;
import okuyama.base.parameter.config.HelperConfigMap;
import okuyama.base.parameter.config.JobConfig;
import okuyama.base.parameter.config.JobConfigMap;
import okuyama.base.process.IErrorProcess;
import okuyama.base.process.IProcess;
import okuyama.base.util.ClassUtility;
import okuyama.base.util.HelperPool;
import okuyama.base.util.ILogger;
import okuyama.base.util.JobEndWaitWorker;
import okuyama.base.util.LoggerFactory;

public class DefaultJobController
implements IJobController {
    private ILogger logger = LoggerFactory.createLogger(DefaultJobController.class);
    private int maxLoop = 0;
    private int loopTimewait = 0;
    private String startChkFile = null;
    private int startChkTimewait = 250;
    private String normalEndFile = null;
    private String endFile = null;
    private boolean reloop = false;
    private String preProcessClass = null;
    private String preProcessOption = null;
    private String postProcessClass = null;
    private String postProcessOption = null;
    private String errProcessClass = null;
    private String errProcessOption = null;
    private Hashtable jobTable = null;
    private Hashtable allJobStatusTable = null;
    private String[] jobNameList = null;
    private JobEndWaitWorker jobEndWaitWorker = null;

    @Override
    public void execute() throws BatchException {
        this.logger.debug("execute - start");
        BatchConfig batchConfig = null;
        JobConfig jobConfig = null;
        try {
            batchConfig = ConfigFolder.getBatchConfig();
            jobConfig = ConfigFolder.getJobConfig();
            this.initConfigSet(batchConfig);
            this.executeJob(jobConfig);
        }
        catch (BatchException be) {
            this.logger.error("execute - error", be);
            throw be;
        }
        this.logger.debug("execute - end");
    }

    private void initConfigSet(BatchConfig batchConfig) throws BatchException {
        this.logger.debug("initConfigSet - start");
        try {
            this.maxLoop = Integer.parseInt(batchConfig.getBatchParam("maxloop"));
            this.loopTimewait = Integer.parseInt(batchConfig.getBatchParam("looptimewait"));
            this.normalEndFile = batchConfig.getBatchParam("normalendfile");
            this.endFile = batchConfig.getBatchParam("endfile");
            if (this.endFile == null || this.normalEndFile == null) {
                throw new BatchException("Batch ConfigFile Error EndFil Error");
            }
            this.startChkFile = batchConfig.getBatchParam("startchkfile");
            if (batchConfig.getBatchParam("reloop") != null) {
                String reloopCheck = batchConfig.getBatchParam("reloop");
                if (reloopCheck.equals("true") || reloopCheck.equals("false")) {
                    this.reloop = new Boolean(reloopCheck);
                } else {
                    throw new BatchException("Batch ConfigFile Error reloop Param");
                }
            }
            this.preProcessClass = batchConfig.getBatchParam("preprocess");
            this.preProcessOption = batchConfig.getBatchParam("preprocessoption");
            this.postProcessClass = batchConfig.getBatchParam("postprocess");
            this.postProcessOption = batchConfig.getBatchParam("postprocessoption");
            this.errProcessClass = batchConfig.getBatchParam("errorprocess");
            this.errProcessOption = batchConfig.getBatchParam("errorprocessoption");
        }
        catch (BatchException be) {
            this.logger.error("initConfigSet - error", be);
            throw be;
        }
        catch (Exception e) {
            this.logger.error("initConfigSet - error", e);
            throw new BatchException(e);
        }
        this.logger.debug("initConfigSet - end");
    }

    private void executeJob(JobConfig jobConfig) throws BatchException {
        this.logger.debug("executeJob - start");
        AbstractJob job = null;
        JobConfigMap jobConfigMap = null;
        HelperConfigMap helperConfigMap = null;
        int loopCnt = 0;
        boolean allEnd = true;
        boolean jobErrorEnd = false;
        boolean reloopFlg = true;
        String preProcessRet = null;
        String postProcessRet = null;
        String[] helperNameList = null;
        try {
            while (reloopFlg) {
                if (!this.checkBatchStart()) {
                    reloopFlg = this.reloop;
                    continue;
                }
                if (!this.checkBatchEnd()) {
                    this.jobNameList = jobConfig.getJobNameList();
                    this.jobTable = new Hashtable(this.jobNameList.length);
                    this.allJobStatusTable = new Hashtable(this.jobNameList.length);
                    preProcessRet = this.executeProcess(1);
                    for (int i = 0; i < this.jobNameList.length; ++i) {
                        jobConfigMap = jobConfig.getJobConfig(this.jobNameList[i]);
                        job = ClassUtility.createJobInstance(jobConfigMap.getJobClassName());
                        job.setConfig(jobConfigMap);
                        job.setPreProcess(preProcessRet);
                        job.setPostProcess(postProcessRet);
                        this.allJobStatusTable.put(jobConfigMap.getJobName(), job.getStatus());
                        this.jobTable.put(this.jobNameList[i], job);
                    }
                    helperNameList = jobConfig.getHelperNameList();
                    HelperPool.initializeHelperPool();
                    for (int helperNameListIndex = 0; helperNameListIndex < helperNameList.length; ++helperNameListIndex) {
                        helperConfigMap = jobConfig.getHelperConfig(helperNameList[helperNameListIndex]);
                        HelperPool.managedHelperConfig(helperConfigMap);
                    }
                    HelperPool helperPool = new HelperPool();
                    helperPool.start();
                    if (!this.checkNormalBatchEnd()) {
                        loopCnt = 0;
                        while (!this.checkBatchEnd() && !this.checkNormalBatchEnd()) {
                            this.logger.debug("Job Watch - start");
                            allEnd = true;
                            jobErrorEnd = false;
                            for (int jobIndex = 0; jobIndex < this.jobNameList.length; ++jobIndex) {
                                job = (AbstractJob)this.jobTable.get(this.jobNameList[jobIndex]);
                                jobConfigMap = jobConfig.getJobConfig(this.jobNameList[jobIndex]);
                                this.logger.debug("Job Status Check Job Name[" + jobConfigMap.getJobName() + "]");
                                if (job.getStatus().equals("job_wait")) {
                                    allEnd = false;
                                    if (!jobConfigMap.isDepend()) {
                                        job.start();
                                        this.allJobStatusTable.put(jobConfigMap.getJobName(), "job_run");
                                    } else if (this.checkDepend(jobConfigMap)) {
                                        job.start();
                                        this.allJobStatusTable.put(jobConfigMap.getJobName(), "job_run");
                                    }
                                } else {
                                    if (job.getStatus().equals("job_err")) {
                                        this.allJobStatusTable.put(jobConfigMap.getJobName(), job.getStatus());
                                        if (this.reloop) {
                                            this.logger.error("Job Status Error End Job Name[" + jobConfigMap.getJobName() + "]");
                                            this.runJobEndWait();
                                            this.executeErrorProcess();
                                            jobErrorEnd = true;
                                            break;
                                        }
                                        throw new BatchException("Job Status Error End JobName[" + jobConfigMap.getJobName() + "]");
                                    }
                                    if (job.getStatus().equals("job_run")) {
                                        this.allJobStatusTable.put(jobConfigMap.getJobName(), "job_run");
                                        allEnd = false;
                                    } else if (job.getStatus().equals("job_end")) {
                                        this.allJobStatusTable.put(jobConfigMap.getJobName(), "job_end");
                                    }
                                }
                                this.jobTable.put(this.jobNameList[jobIndex], job);
                            }
                            this.logger.debug("Now All Job Status :" + this.allJobStatusTable);
                            this.logger.debug("Job Watch - end");
                            if (jobErrorEnd) {
                                this.logger.info("Job Watch - Job Error");
                                break;
                            }
                            if (allEnd) {
                                this.logger.info("Job Watch - All Job End");
                                break;
                            }
                            if (this.maxLoop != -1 && this.maxLoop == ++loopCnt) {
                                this.logger.error("Job WatchLimitCount Over!!");
                                if (this.reloop) {
                                    this.runJobEndWait();
                                    this.executeErrorProcess();
                                    break;
                                }
                                throw new BatchException("Exception - Job WatchLimitCount Over!!");
                            }
                            this.logger.debug("Job Watch - sleep");
                            Thread.sleep(this.loopTimewait);
                        }
                        helperPool.poolEnd();
                        helperPool.join(60000L);
                        helperPool = null;
                        this.logger.debug("Job Watch - finish");
                        postProcessRet = this.executeProcess(2);
                        reloopFlg = this.reloop;
                        continue;
                    }
                }
                break;
            }
        }
        catch (BatchException be) {
            this.logger.error("executeJob - error", be);
            this.executeErrorProcess();
            throw be;
        }
        catch (Exception e) {
            this.logger.error("executeJob - error", e);
            throw new BatchException(e);
        }
        this.logger.debug("executeJob - end");
    }

    public String executeProcess(int type) throws BatchException {
        this.logger.debug("executeProcess - start");
        IProcess processClass = null;
        String processOption = null;
        String ret = null;
        try {
            if (type == 1) {
                if (this.preProcessClass != null && !this.preProcessClass.equals("")) {
                    processClass = (IProcess)ClassUtility.createInstance(this.preProcessClass);
                    processOption = this.preProcessOption;
                }
            } else if (type == 2 && this.postProcessClass != null && !this.postProcessClass.equals("")) {
                processClass = (IProcess)ClassUtility.createInstance(this.postProcessClass);
                processOption = this.postProcessOption;
            }
            if (processClass != null) {
                ret = processClass.process(processOption);
            }
        }
        catch (BatchException be) {
            this.logger.error("executeProcess - error", be);
            throw be;
        }
        catch (Exception e) {
            this.logger.error("executeProcess - error", e);
            throw new BatchException(e);
        }
        this.logger.debug("executeProcess - end");
        return ret;
    }

    public void executeErrorProcess() {
        this.logger.debug("executeErrorProcess - start");
        IErrorProcess processClass = null;
        try {
            if (this.errProcessClass != null && !this.errProcessClass.equals("")) {
                processClass = (IErrorProcess)ClassUtility.createInstance(this.errProcessClass);
                processClass.errorProcess(this.jobTable, this.allJobStatusTable, this.errProcessOption);
            }
        }
        catch (BatchException be) {
            this.logger.error("executeErrorProcess - error ", be);
        }
        catch (Exception e) {
            this.logger.error("executeErrorProcess - error ", e);
        }
        this.logger.debug("executeErrorProcess - end");
    }

    private boolean checkBatchStart() throws BatchException {
        this.logger.debug("checkBatchStart - start");
        boolean ret = true;
        try {
            if (this.startChkFile == null) {
                return ret;
            }
            File file = new File(new File(this.startChkFile).getAbsolutePath());
            if (file.exists()) {
                ret = false;
                Thread.sleep(this.startChkTimewait);
                this.logger.info("checkBatchEnd - Start NGFile Exists");
            }
        }
        catch (Exception e) {
            this.logger.error("checkBatchStart - error", e);
            throw new BatchException(e);
        }
        this.logger.debug("checkBatchStart - end");
        return ret;
    }

    private boolean checkBatchEnd() throws BatchException {
        this.logger.debug("checkBatchEnd - start");
        boolean ret = false;
        try {
            File file = new File(new File(this.endFile).getAbsolutePath());
            if (file.exists()) {
                ret = true;
                this.logger.info("checkBatchEnd - End File Exists");
            }
        }
        catch (Exception e) {
            this.logger.error("checkBatchEnd - error", e);
            throw new BatchException(e);
        }
        this.logger.debug("checkBatchEnd - end");
        return ret;
    }

    public void runJobEndWait() throws Exception {
        this.logger.debug("runJobEndWait - start");
        AbstractJob job = null;
        ArrayList<AbstractJob> jobs = null;
        boolean runJobCount = false;
        try {
            if (this.jobNameList != null && this.jobNameList.length > 0) {
                jobs = new ArrayList<AbstractJob>();
                for (int i = 0; i < this.jobNameList.length; ++i) {
                    job = (AbstractJob)this.jobTable.get(this.jobNameList[i]);
                    if (!job.getStatus().equals("job_run")) continue;
                    jobs.add(job);
                }
                this.jobEndWaitWorker = new JobEndWaitWorker();
                this.jobEndWaitWorker.setTargetJobs(jobs);
                this.jobEndWaitWorker.start();
                while (true) {
                    if (this.jobEndWaitWorker.getStatus().equals("wait_worker_err")) {
                        throw new BatchException("JobEndWaitWorker Error");
                    }
                    if (!this.jobEndWaitWorker.getStatus().equals("wait_worker_end") && !this.checkBatchEnd()) {
                        this.logger.debug("runJobEndWait - run Job Wait");
                        Thread.sleep(50000L);
                        continue;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("runJobEndWait - error", e);
            throw e;
        }
        this.logger.debug("runJobEndWait - end");
    }

    public boolean checkNormalBatchEnd() throws Exception {
        this.logger.debug("checkNormalBatchEnd - start");
        boolean ret = false;
        AbstractJob job = null;
        ArrayList<AbstractJob> jobs = null;
        boolean runJobCount = false;
        try {
            File file = new File(new File(this.normalEndFile).getAbsolutePath());
            if (file.exists()) {
                this.logger.debug("checkNormalBatchEnd - Normal End File Exists");
                ret = true;
                if (this.jobNameList != null && this.jobNameList.length > 0) {
                    jobs = new ArrayList<AbstractJob>();
                    for (int i = 0; i < this.jobNameList.length; ++i) {
                        job = (AbstractJob)this.jobTable.get(this.jobNameList[i]);
                        if (!job.getStatus().equals("job_run")) continue;
                        jobs.add(job);
                    }
                    this.jobEndWaitWorker = new JobEndWaitWorker();
                    this.jobEndWaitWorker.setTargetJobs(jobs);
                    this.jobEndWaitWorker.start();
                    while (true) {
                        if (this.jobEndWaitWorker.getStatus().equals("wait_worker_err")) {
                            throw new BatchException("JobEndWaitWorker - Error");
                        }
                        if (!this.jobEndWaitWorker.getStatus().equals("wait_worker_end") && !this.checkBatchEnd()) {
                            this.logger.info("checkNormalBatchEnd - Run Job Wait");
                            Thread.sleep(50000L);
                            continue;
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("checkNormalBatchEnd - error", e);
            throw e;
        }
        this.logger.debug("checkNormalBatchEnd - end");
        return ret;
    }

    private boolean checkDepend(JobConfigMap jobConfigMap) throws BatchException {
        this.logger.debug("checkDepend - start");
        boolean checkFlg = true;
        String[] dependJobList = null;
        String dependJobStatus = null;
        try {
            dependJobList = jobConfigMap.getJobDependList();
            for (int dependIndex = 0; dependIndex < dependJobList.length; ++dependIndex) {
                if (this.allJobStatusTable.containsKey(dependJobList[dependIndex])) {
                    dependJobStatus = (String)this.allJobStatusTable.get(dependJobList[dependIndex]);
                    if (dependJobStatus.equals("job_end")) continue;
                    checkFlg = false;
                    continue;
                }
                throw new BatchException("Depend Config Error:" + jobConfigMap.getJobName());
            }
        }
        catch (BatchException be) {
            this.logger.error("checkDepend -error", be);
            throw be;
        }
        this.logger.debug("checkDepend - end");
        return checkFlg;
    }
}

