/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.helper.AbstractMasterManagerHelper;
import okuyama.imdst.util.DataDispatcher;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.io.KeyNodeConnector;

public class KeyNodeOptimizationHelper
extends AbstractMasterManagerHelper {
    private int checkCycle = 15000;
    private BufferedReader br = null;
    private KeyNodeConnector keyNodeConnector = null;
    private String searchNodeInfo = null;
    private ArrayList removeDataKeys = null;
    private int nextData = 1;
    private HashMap connectMap = null;
    private static ILogger logger = LoggerFactory.createLogger(KeyNodeOptimizationHelper.class);

    @Override
    public void initHelper(String initValue) {
        this.connectMap = new HashMap();
        if (initValue != null && !initValue.equals("")) {
            try {
                this.checkCycle = Integer.parseInt(initValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeHelper(String optionParam) throws BatchException {
        logger.debug("KeyNodeOptimizationHelper - executeHelper - start");
        String ret = SUCCESS;
        Object serverStopMarkerFile = null;
        boolean serverRunning = true;
        String[] optimizeTargetKeys = null;
        String myInfo = null;
        String[] myInfoDt = null;
        myInfo = StatusUtil.getMyNodeInfo();
        if (myInfo == null || myInfo.trim().equals("")) {
            myInfo = "127.0.0.1:8888";
        }
        myInfoDt = myInfo.split(":");
        while (serverRunning) {
            try {
                Thread.sleep(this.checkCycle);
                if (!super.isExecuteKeyNodeOptimization()) continue;
                HashMap allNodeInfo = DataDispatcher.getAllDataNodeInfo();
                ArrayList mainNodeList = (ArrayList)allNodeInfo.get("main");
                ArrayList subNodeList = (ArrayList)allNodeInfo.get("sub");
                ArrayList thirdNodeList = (ArrayList)allNodeInfo.get("third");
                if (StatusUtil.isMainMasterNode()) {
                    super.setNowNodeDataOptimization(true);
                    for (int i = 0; i < mainNodeList.size(); ++i) {
                        String nodeInfo = (String)mainNodeList.get(i);
                        String subNodeInfo = null;
                        String thirdNodeInfo = null;
                        if (subNodeList != null) {
                            subNodeInfo = (String)subNodeList.get(i);
                        }
                        if (thirdNodeList != null) {
                            thirdNodeInfo = (String)thirdNodeList.get(i);
                        }
                        logger.info("************************************************************");
                        logger.info(nodeInfo + " Optimization Start");
                        optimizeTargetKeys = null;
                        this.closeGetConnect();
                        String[] searchNodeDt = null;
                        String[] mainNodeDt = nodeInfo.split(":");
                        String[] subNodeDt = new String[2];
                        String[] thirdNodeDt = new String[2];
                        if (subNodeInfo != null) {
                            subNodeDt = subNodeInfo.split(":");
                        }
                        if (thirdNodeInfo != null) {
                            thirdNodeDt = thirdNodeInfo.split(":");
                        }
                        if (!super.isNodeArrival(nodeInfo)) {
                            if (subNodeInfo != null && super.isNodeArrival(subNodeInfo)) {
                                searchNodeDt = subNodeInfo.split(":");
                            } else if (thirdNodeInfo != null && super.isNodeArrival(thirdNodeInfo)) {
                                searchNodeDt = thirdNodeInfo.split(":");
                            }
                        } else {
                            searchNodeDt = nodeInfo.split(":");
                        }
                        if (searchNodeDt != null) {
                            this.searchTargetData(searchNodeDt[0], Integer.parseInt(searchNodeDt[1]), i);
                            this.removeDataKeys = new ArrayList(100000);
                            while ((optimizeTargetKeys = this.nextData()) != null) {
                                for (int idx = 0; idx < optimizeTargetKeys.length; ++idx) {
                                    if (optimizeTargetKeys[idx] == null || optimizeTargetKeys[idx].trim().equals("")) continue;
                                    this.sendTargetData(optimizeTargetKeys[idx]);
                                }
                            }
                            this.closeGetConnect();
                            this.removeTargetData(mainNodeDt[0], mainNodeDt[1], subNodeDt[0], subNodeDt[1], thirdNodeDt[0], thirdNodeDt[1]);
                        }
                        logger.info(nodeInfo + " Optimization End");
                        logger.info("************************************************************");
                    }
                }
                super.executeKeyNodeOptimization(false);
                super.setNowNodeDataOptimization(false);
            }
            catch (Exception e) {
                this.closeGetConnect();
                logger.error("KeyNodeOptimizationHelper - executeHelper - Error", e);
            }
            finally {
                try {
                    super.setNowNodeDataOptimization(false);
                }
                catch (Exception e2) {}
            }
        }
        logger.debug("KeyNodeOptimizationHelper - executeHelper - end");
        return ret;
    }

    @Override
    public void endHelper() {
    }

    private void searchTargetData(String nodeName, int nodePort, int dataNodeMatchNo) throws BatchException {
        StringBuilder buf = null;
        try {
            StatusUtil.waitNodeUseStatus(nodeName + ":" + nodePort, null, null);
            StatusUtil.addNodeUse(nodeName + ":" + nodePort);
            this.searchNodeInfo = nodeName + ":" + nodePort;
            if (this.keyNodeConnector != null) {
                this.keyNodeConnector.close();
            }
            this.keyNodeConnector = new KeyNodeConnector(nodeName, nodePort, nodeName + ":" + nodePort);
            this.keyNodeConnector.connect();
            this.keyNodeConnector.setSoTimeout(21600000);
            buf = new StringBuilder();
            buf.append("26");
            buf.append(",");
            buf.append("true");
            buf.append(",");
            buf.append(dataNodeMatchNo);
            buf.append(",");
            buf.append(DataDispatcher.ruleInt);
            this.keyNodeConnector.println(buf.toString());
            this.keyNodeConnector.flush();
        }
        catch (SocketException se) {
            super.setDeadNode(nodeName + ":" + nodePort, 31, se);
            throw new BatchException(se);
        }
        catch (IOException ie) {
            super.setDeadNode(nodeName + ":" + nodePort, 32, ie);
            throw new BatchException(ie);
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
    }

    private String[] nextData() throws BatchException {
        String[] ret = null;
        String line = null;
        try {
            while ((line = this.keyNodeConnector.readLine()) != null) {
                if (line.length() <= 0) continue;
                if (line.length() != 2 || !line.equals("-1")) {
                    ret = line.split(";");
                }
                break;
            }
        }
        catch (SocketException se) {
            logger.error("", se);
            throw new BatchException(se);
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendTargetData(String targetDataLine) {
        boolean ret = false;
        KeyNodeConnector mainKeyNodeConnector = null;
        KeyNodeConnector subKeyNodeConnector = null;
        KeyNodeConnector thirdKeyNodeConnector = null;
        String[] targetDatas = null;
        String[] keyNodeInfo = null;
        Object sendTargetNodeInfo = null;
        try {
            logger.info("sendTargetData - start");
            targetDatas = targetDataLine.split(",");
            if (targetDatas[0].equals("1")) {
                keyNodeInfo = DataDispatcher.dispatchKeyNode(targetDatas[1], false);
            } else if (targetDatas[0].equals("2")) {
                keyNodeInfo = DataDispatcher.dispatchKeyNode(targetDatas[1].substring(0, targetDatas[1].lastIndexOf("_")), false);
            }
            if (keyNodeInfo.length > 2) {
                mainKeyNodeConnector = this.createSendTargetConnection(keyNodeInfo[0], Integer.parseInt(keyNodeInfo[1]), keyNodeInfo[2]);
            }
            if (keyNodeInfo.length > 5) {
                subKeyNodeConnector = this.createSendTargetConnection(keyNodeInfo[3], Integer.parseInt(keyNodeInfo[4]), keyNodeInfo[5]);
            }
            if (keyNodeInfo.length > 8) {
                thirdKeyNodeConnector = this.createSendTargetConnection(keyNodeInfo[6], Integer.parseInt(keyNodeInfo[7]), keyNodeInfo[8]);
            }
            if (mainKeyNodeConnector != null && this.sendDataLine(mainKeyNodeConnector, targetDataLine)) {
                ret = true;
            }
            if (subKeyNodeConnector != null && this.sendDataLine(subKeyNodeConnector, targetDataLine)) {
                ret = true;
            }
            if (thirdKeyNodeConnector != null && this.sendDataLine(thirdKeyNodeConnector, targetDataLine)) {
                ret = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("", e);
        }
        finally {
            if (keyNodeInfo.length > 2) {
                super.execNodeUseEnd((String)keyNodeInfo[2]);
            }
            if (keyNodeInfo.length > 5) {
                super.execNodeUseEnd(keyNodeInfo[5]);
            }
            if (keyNodeInfo.length > 8) {
                super.execNodeUseEnd(keyNodeInfo[8]);
            }
            if (ret) {
                this.removeDataKeys.add(targetDatas[0] + "," + targetDatas[1]);
            }
        }
        logger.info("sendTargetData - end");
        return ret;
    }

    private KeyNodeConnector createSendTargetConnection(String nodeName, int nodePort, String nodeFullName) throws Exception {
        KeyNodeConnector keyNodeConnector = null;
        try {
            if (super.isNodeArrival(nodeFullName)) {
                if (this.connectMap.containsKey(nodeFullName)) {
                    keyNodeConnector = (KeyNodeConnector)this.connectMap.get(nodeFullName);
                } else {
                    keyNodeConnector = new KeyNodeConnector(nodeName, nodePort, nodeFullName);
                    keyNodeConnector.connect();
                    keyNodeConnector.println("30,true");
                    keyNodeConnector.flush();
                    this.connectMap.put(nodeFullName, keyNodeConnector);
                }
            } else {
                this.connectMap.remove(nodeFullName);
            }
        }
        catch (SocketException se) {
            super.setDeadNode(nodeFullName, 31, se);
        }
        catch (IOException ie) {
            super.setDeadNode(nodeFullName, 32, ie);
        }
        catch (Exception e) {
            throw e;
        }
        return keyNodeConnector;
    }

    private boolean sendDataLine(KeyNodeConnector keyNodeConnector, String dataLine) throws Exception {
        boolean ret = false;
        try {
            keyNodeConnector.println(dataLine);
            keyNodeConnector.flush();
            String sendRet = keyNodeConnector.readLine();
            if (sendRet != null && sendRet.equals("next")) {
                ret = true;
            }
        }
        catch (SocketException se) {
            super.setDeadNode(keyNodeConnector.getNodeFullName(), 33, se);
        }
        catch (IOException ie) {
            super.setDeadNode(keyNodeConnector.getNodeFullName(), 34, ie);
        }
        catch (Exception e) {
            throw e;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTargetData(String mainNodeName, String mainNodePort, String subNodeName, String subNodePort, String thirdNodeName, String thirdNodePort) {
        PrintWriter[] removePw = new PrintWriter[3];
        BufferedReader[] removeBr = new BufferedReader[3];
        Socket[] removeSocket = new Socket[3];
        try {
            logger.info("removeTargetData - start");
            if (subNodeName != null && thirdNodeName != null) {
                StatusUtil.waitNodeUseStatus(mainNodeName + ":" + mainNodePort, subNodeName + ":" + subNodePort, thirdNodeName + ":" + thirdNodePort);
            } else if (subNodeName != null) {
                StatusUtil.waitNodeUseStatus(mainNodeName + ":" + mainNodePort, subNodeName + ":" + subNodePort, null);
            } else {
                StatusUtil.waitNodeUseStatus(mainNodeName + ":" + mainNodePort, null, null);
            }
            StatusUtil.addNodeUse(mainNodeName + ":" + mainNodePort);
            if (subNodeName != null) {
                StatusUtil.addNodeUse(subNodeName + ":" + subNodePort);
            }
            if (thirdNodeName != null) {
                StatusUtil.addNodeUse(thirdNodeName + ":" + thirdNodePort);
            }
            this.removeData(mainNodeName, Integer.parseInt(mainNodePort), mainNodeName + ":" + mainNodePort);
            if (subNodeName != null) {
                this.removeData(subNodeName, Integer.parseInt(subNodePort), subNodeName + ":" + subNodePort);
            }
            if (thirdNodeName != null) {
                this.removeData(thirdNodeName, Integer.parseInt(thirdNodePort), thirdNodeName + ":" + thirdNodePort);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                super.execNodeUseEnd(mainNodeName + ":" + mainNodePort);
                if (subNodeName != null) {
                    super.execNodeUseEnd(subNodeName + ":" + subNodePort);
                }
                if (thirdNodeName != null) {
                    super.execNodeUseEnd(thirdNodeName + ":" + thirdNodePort);
                }
            }
            catch (Exception ee) {}
        }
        logger.info("removeTargetData - end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeData(String nodeName, int nodePort, String nodeFullName) {
        KeyNodeConnector keyNodeConnector = null;
        try {
            logger.info("removeData - start");
            keyNodeConnector = new KeyNodeConnector(nodeName, nodePort, nodeFullName);
            keyNodeConnector.connect();
            keyNodeConnector.println("31,true");
            keyNodeConnector.flush();
            for (int idx = 0; idx < this.removeDataKeys.size(); ++idx) {
                keyNodeConnector.println((String)this.removeDataKeys.get(idx));
                keyNodeConnector.flush();
                String removeRet = keyNodeConnector.readLine();
            }
        }
        catch (SocketException se) {
            super.setDeadNode(keyNodeConnector.getNodeFullName(), 35, se);
        }
        catch (IOException ie) {
            super.setDeadNode(keyNodeConnector.getNodeFullName(), 36, ie);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                keyNodeConnector.println("-1");
                keyNodeConnector.flush();
                keyNodeConnector.close();
            }
            catch (Exception ee) {}
        }
        logger.info("removeData - end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeGetConnect() {
        try {
            if (this.searchNodeInfo != null) {
                super.execNodeUseEnd(this.searchNodeInfo);
                this.searchNodeInfo = null;
            }
            if (this.keyNodeConnector != null) {
                this.keyNodeConnector.println("(&imdst9999&)");
                this.keyNodeConnector.flush();
                this.keyNodeConnector.close();
                this.keyNodeConnector = null;
            }
            Set set = this.connectMap.keySet();
            for (String key : set) {
                KeyNodeConnector keyNodeConnector = (KeyNodeConnector)this.connectMap.get(key);
                keyNodeConnector.println("-1");
                keyNodeConnector.flush();
                String endMsg = keyNodeConnector.readLine();
                keyNodeConnector.close();
            }
            this.connectMap = new HashMap();
        }
        catch (Exception e2) {
            logger.error("", e2);
        }
    }
}

