/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util.serializemap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import okuyama.imdst.util.CoreMapKey;
import okuyama.imdst.util.SystemUtil;
import okuyama.imdst.util.serializemap.ISerializer;

public class ToStringSerializer
implements ISerializer {
    private String serializeMapName = null;
    private boolean typeNum = false;
    private int count = 0;
    private static String keyToValueSep = "+";
    private Map dataMap = new HashMap(10000);

    public ToStringSerializer() {
    }

    public ToStringSerializer(String type) {
        if (type != null && type.equals("num")) {
            this.typeNum = true;
        }
    }

    @Override
    public void setInstanceCreateMapName(String mapName) {
        this.serializeMapName = mapName;
    }

    @Override
    public byte[] serialize(Map serializeTarget, Class mapKeyClazz, Class mapValueClazz, Object key, int uniqueNo) {
        if (this.typeNum) {
            try {
                return SystemUtil.dataCompress(serializeTarget.toString().getBytes("UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        String sep = "";
        StringBuilder strBuf = new StringBuilder(128);
        strBuf.append("{");
        Set entrySet = serializeTarget.entrySet();
        Iterator entryIte = entrySet.iterator();
        try {
            while (entryIte.hasNext()) {
                Map.Entry obj = entryIte.next();
                if (obj == null) continue;
                CoreMapKey coreMapKey = (CoreMapKey)obj.getKey();
                String data = new String((byte[])obj.getValue(), "UTF-8");
                strBuf.append(sep);
                strBuf.append(coreMapKey.toString());
                strBuf.append(keyToValueSep);
                strBuf.append(data);
                sep = ", ";
            }
            strBuf.append("}");
            return SystemUtil.dataCompress(strBuf.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map deSerialize(byte[] deserializeTarget, Object key, int uniqueNo) {
        byte[] decompressData = SystemUtil.dataDecompress(deserializeTarget);
        try {
            String serializeStr = new String(decompressData, "UTF-8");
            if (this.typeNum) {
                return this.deserializeStringToMap(serializeStr.substring(1, serializeStr.length() - 1));
            }
            return this.deserializeStringToMapByByteData(serializeStr.substring(1, serializeStr.length() - 1));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Map deserializeStringToMap(String serializeStr) {
        HashMap<CoreMapKey, String> retMap = new HashMap<CoreMapKey, String>();
        String[] dataStrList = serializeStr.split(", ");
        for (int idx = 0; idx < dataStrList.length; ++idx) {
            if (dataStrList[idx].trim().equals("")) continue;
            int lastIndex = dataStrList[idx].lastIndexOf("=");
            retMap.put(new CoreMapKey(dataStrList[idx].substring(0, lastIndex)), dataStrList[idx].substring(lastIndex + 1));
        }
        return retMap;
    }

    private Map deserializeStringToMapByByteData(String serializeStr) {
        HashMap<CoreMapKey, byte[]> retMap = new HashMap<CoreMapKey, byte[]>();
        String[] dataStrList = serializeStr.split(", ");
        try {
            for (int idx = 0; idx < dataStrList.length; ++idx) {
                if (dataStrList[idx].trim().equals("")) continue;
                int lastIndex = dataStrList[idx].lastIndexOf(keyToValueSep);
                retMap.put(new CoreMapKey(dataStrList[idx].substring(0, lastIndex)), dataStrList[idx].substring(lastIndex + 1).getBytes("UTF-8"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return retMap;
    }

    @Override
    public void clearParentMap() {
    }
}

