/*
 * Decompiled with CFR 0.152.
 */
package okuyama.base.parameter.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import okuyama.base.lang.BatchException;
import okuyama.base.parameter.config.JobConfig;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;

public class BatchConfig {
    private String configFile = null;
    private ILogger logger = LoggerFactory.createLogger(BatchConfig.class);
    private Hashtable configTable = new Hashtable();

    public BatchConfig(String fileName) throws BatchException {
        this.configFile = fileName;
        File jobConfigFile = new File(fileName);
        if (jobConfigFile.exists()) {
            try {
                this.initConfig(new FileInputStream(fileName));
            }
            catch (Exception e) {
                throw new BatchException(e);
            }
        } else {
            this.initConfig(JobConfig.class.getResourceAsStream(fileName));
        }
    }

    private void initConfig(InputStream is) throws BatchException {
        this.logger.debug("BatchConfig - initConfig - start");
        Properties prop = null;
        Object var3_3 = null;
        boolean index = false;
        try {
            prop = new Properties();
            prop.load(is);
            Set<Object> keys = prop.keySet();
            for (String string : keys) {
                this.configTable.put(string, prop.getProperty(string));
            }
            this.checkConfig();
        }
        catch (Exception e) {
            this.logger.error("BatchConfig - initConfig - Exception", e);
            throw new BatchException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ie) {
                this.logger.error("initConfig - File Stream Close Error");
            }
        }
        this.logger.debug("BatchConfig - initConfig - end");
    }

    private void checkConfig() {
    }

    public String getBatchParam(String key) {
        String ret = null;
        if (this.configTable.containsKey(key)) {
            ret = (String)this.configTable.get(key);
        }
        return ret;
    }
}

