/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import com.sun.mail.util.BASE64EncoderStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.JavaSystemApi;

public class StatusUtil {
    private static int masterManagerStatus = 0;
    private static HashMap nodeStatusMap = new HashMap();
    private static Object nodeSync = new Object();
    private static ConcurrentHashMap checkErrorMap = new ConcurrentHashMap(50, 40.0f, 300);
    private static ConcurrentHashMap nodeExecMap = new ConcurrentHashMap(50, 40.0f, 300);
    private static ConcurrentHashMap nodeRebootTimeMap = new ConcurrentHashMap(50, 40.0f, 300);
    private static ConcurrentHashMap nodeStatusDtMap = new ConcurrentHashMap(50, 40.0f, 300);
    private static ConcurrentHashMap nodeDataSizeDtMap = new ConcurrentHashMap(50, 40.0f, 300);
    private static String nowMemoryStatus = null;
    private static String nowCpuStatus = null;
    private static boolean memoryLimitOver = false;
    private static Integer memoryLimitMinSize = new Integer(90);
    private static int status = 0;
    private static String msg = null;
    private static String myNodeInfo = null;
    private static Boolean mainMasterNode = null;
    private static String mainMasterNodeInfo = null;
    private static String slaveMainMasterNodeInfo = null;
    private static String allMasterNodeInfo = null;
    private static String checkTargetMasterNodes = null;
    private static Boolean transactionMode = null;
    private static String[] transactionInfo = null;
    private static String distributionAlgorithm = null;
    private static boolean isolationMode = false;
    private static String isolationPrefixStr = null;
    private static Map isolationCnvExclusionMap = null;
    public static Map configDataKeyMap = null;
    private static int[] methodList = null;
    private static boolean debugMode = false;
    private static AtomicLong[] accessCountList = new AtomicLong[24];

    public static void setDebugOption(boolean debugMode) {
        StatusUtil.debugMode = debugMode;
    }

    public static boolean getDebugOption() {
        return debugMode;
    }

    public static void initNodeExecMap(String[] nodeInfos) {
        for (int i = 0; i < nodeInfos.length; ++i) {
            if (nodeExecMap.containsKey(nodeInfos[i])) continue;
            nodeExecMap.put(nodeInfos[i], new AtomicInteger(0));
        }
    }

    public static void initIsolationMode(boolean mode, String prefix) {
        isolationMode = mode;
        isolationPrefixStr = "#" + prefix;
        if (isolationMode) {
            isolationCnvExclusionMap = configDataKeyMap;
        }
    }

    public static void useMemoryLimitOver() {
        memoryLimitOver = true;
    }

    public static boolean isUseMemoryLimitOver() {
        return memoryLimitOver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMemoryLimitMinSize(int limitSize) {
        Integer n = memoryLimitMinSize;
        synchronized (n) {
            if (memoryLimitMinSize > limitSize) {
                memoryLimitMinSize = new Integer(limitSize);
            }
        }
    }

    public static int getMemoryLimitMinSize() {
        return memoryLimitMinSize;
    }

    public static void setStatus(int status) {
        StatusUtil.status = status;
    }

    public static void setStatusAndMessage(int status, String msg) {
        StatusUtil.status = status;
        StatusUtil.msg = msg;
    }

    public static int getStatus() {
        return status;
    }

    public static String getStatusMessage() {
        return msg;
    }

    public static void initExecuteMethodList(String[] methodNoList) {
        if (methodNoList != null) {
            int i;
            methodList = new int[1000];
            for (i = 0; i < 1000; ++i) {
                StatusUtil.methodList[i] = -1;
            }
            for (i = 0; i < methodNoList.length; ++i) {
                StatusUtil.methodList[Integer.parseInt((String)methodNoList[i])] = 1;
            }
        }
    }

    public static int isExecuteMethod(int methodNo) {
        if (methodList == null) {
            return methodNo;
        }
        if (methodList[methodNo] == 1) {
            return methodNo;
        }
        return -1;
    }

    public static void setMyNodeInfo(String my) {
        myNodeInfo = my;
    }

    public static String getMyNodeInfo() {
        return myNodeInfo;
    }

    public static void setAllMasterNodeInfo(String str) {
        allMasterNodeInfo = str;
    }

    public static String getAllMasterNodeInfo() {
        return allMasterNodeInfo;
    }

    public static void setCheckTargetMasterNodes(String masterNodes) {
        checkTargetMasterNodes = masterNodes;
    }

    public static String getCheckTargetMasterNodes() {
        return checkTargetMasterNodes;
    }

    public static void setNodeDataSize(Integer nodeNo, String[] sizeList) {
        nodeDataSizeDtMap.put(nodeNo, sizeList);
    }

    public static Map getNodeDataSize() {
        HashMap<String, Long> allDataMap = new HashMap<String, Long>();
        for (int i = 0; i < nodeDataSizeDtMap.size(); ++i) {
            String[] sizeList = (String[])nodeDataSizeDtMap.get(new Integer(i));
            if (sizeList == null) continue;
            for (int t = 0; t < sizeList.length; ++t) {
                String[] sizeDt = sizeList[t].split("=");
                Long size = (Long)allDataMap.get(sizeDt[0]);
                if (size == null) {
                    allDataMap.put(sizeDt[0], new Long(sizeDt[1]));
                    continue;
                }
                long calcLong = size;
                allDataMap.put(sizeDt[0], new Long(calcLong += new Long(sizeDt[1]).longValue()));
            }
        }
        return allDataMap;
    }

    public static boolean isNodeArrival(String nodeInfo) {
        return !checkErrorMap.containsKey(nodeInfo);
    }

    public static void setArriveNode(String nodeInfo) {
        checkErrorMap.remove(nodeInfo);
        StatusUtil.setNodeRebootTime(nodeInfo, new Long(JavaSystemApi.currentTimeMillis));
    }

    public static void setDeadNode(String nodeInfo) {
        checkErrorMap.put(nodeInfo, new Boolean(false));
    }

    public static void setNodeRebootTime(String nodeInfo, Long time) {
        nodeRebootTimeMap.put(nodeInfo, time);
    }

    public static Long getNodeRebootTime(String nodeInfo) {
        return (Long)nodeRebootTimeMap.get(nodeInfo);
    }

    public static boolean isWaitStatus(String nodeInfo) {
        return nodeStatusMap.containsKey(nodeInfo);
    }

    public static void waitNodeUseStatus(String mainNodeInfo, String subNodeInfo, String thirdNodeInfo) {
        boolean noWaitFlg = false;
        while (true) {
            noWaitFlg = false;
            if (thirdNodeInfo != null) {
                if (!(StatusUtil.isWaitStatus(mainNodeInfo) || StatusUtil.isWaitStatus(subNodeInfo) || StatusUtil.isWaitStatus(thirdNodeInfo))) {
                    noWaitFlg = true;
                }
            } else if (subNodeInfo != null) {
                if (!StatusUtil.isWaitStatus(mainNodeInfo) && !StatusUtil.isWaitStatus(subNodeInfo)) {
                    noWaitFlg = true;
                }
            } else if (mainNodeInfo != null && !StatusUtil.isWaitStatus(mainNodeInfo)) {
                noWaitFlg = true;
            }
            if (noWaitFlg) break;
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWaitStatus(String nodeInfo) {
        Object object = nodeSync;
        synchronized (object) {
            nodeStatusMap.put(nodeInfo, new Boolean(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWaitStatus(String nodeInfo) {
        Object object = nodeSync;
        synchronized (object) {
            nodeStatusMap.remove(nodeInfo);
        }
    }

    public static void addNodeUse(String nodeInfo) {
        AtomicInteger cnt = (AtomicInteger)nodeExecMap.get(nodeInfo);
        cnt.incrementAndGet();
        nodeExecMap.put(nodeInfo, cnt);
    }

    public static void endNodeUse(String nodeInfo) {
        AtomicInteger cnt = (AtomicInteger)nodeExecMap.get(nodeInfo);
        cnt.decrementAndGet();
        nodeExecMap.put(nodeInfo, cnt);
    }

    public static int getNodeUseStatus(String nodeInfo) {
        return ((AtomicInteger)nodeExecMap.get(nodeInfo)).intValue();
    }

    public static void setNodeStatusDt(String nodeInfo, String dtText) {
        nodeStatusDtMap.put(nodeInfo, dtText);
    }

    public static String getNodeStatusDt(String nodeInfo) {
        return (String)nodeStatusDtMap.get(nodeInfo);
    }

    public static void setNowMemoryStatus(String statusStr) {
        nowMemoryStatus = statusStr;
    }

    public static void setNowCpuStatus(String statusStr) {
        nowCpuStatus = statusStr;
    }

    public static String getNowMemoryStatus() {
        return nowMemoryStatus;
    }

    public static String getNowCpuStatus() {
        return nowCpuStatus;
    }

    public static void setMainMasterNodeInfo(String str) {
        mainMasterNodeInfo = str;
    }

    public static String getMainMasterNodeInfo() {
        return mainMasterNodeInfo;
    }

    public static void setMainMasterNode(boolean flg, int no) {
        mainMasterNode = new Boolean(flg);
        if (!mainMasterNode.booleanValue()) {
            ImdstDefine.compulsionRetryConnectMode = true;
        }
    }

    public static boolean isMainMasterNode() {
        while (mainMasterNode == null) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
        return mainMasterNode;
    }

    public static void setSlaveMasterNodes(String infos) {
        slaveMainMasterNodeInfo = infos;
    }

    public static String getSlaveMasterNodes() {
        while (mainMasterNode == null) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
        return slaveMainMasterNodeInfo;
    }

    public static void setTransactionMode(boolean flg) {
        transactionMode = new Boolean(flg);
    }

    public static boolean isTransactionMode() {
        while (transactionMode == null) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
        return transactionMode;
    }

    public static void setTransactionNode(String[] info) {
        transactionInfo = info;
    }

    public static String[] getTransactionNode() {
        while (transactionMode == null) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
        return transactionInfo;
    }

    public static boolean getIsolationMode() {
        return isolationMode;
    }

    public static boolean isIsolationEncodeTarget(String str) {
        if (str.length() > 121) {
            return !isolationCnvExclusionMap.containsKey(str);
        }
        return true;
    }

    public static String getIsolationPrefix() {
        return isolationPrefixStr;
    }

    public static void setDistributionAlgorithm(String algorithm) {
        distributionAlgorithm = algorithm;
    }

    public static String getDistributionAlgorithm() {
        return distributionAlgorithm;
    }

    public static void incrementMethodExecuteCount() {
        accessCountList[JavaSystemApi.currentDateHour].getAndIncrement();
    }

    public static String getMethodExecuteCount() {
        StringBuffer strBuf = new StringBuffer(100);
        for (int i = 0; i < 24; ++i) {
            strBuf.append("Hour=");
            strBuf.append(i);
            strBuf.append("");
            strBuf.append(" Count=[");
            strBuf.append(accessCountList[i].toString());
            strBuf.append("], ");
        }
        return strBuf.toString();
    }

    public static boolean isStandby() {
        while (mainMasterNode == null || transactionMode == null || distributionAlgorithm == null) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        return true;
    }

    static {
        for (int i = 0; i < 24; ++i) {
            StatusUtil.accessCountList[i] = new AtomicLong();
        }
        try {
            configDataKeyMap = new HashMap();
            configDataKeyMap.put(new String(BASE64EncoderStream.encode((byte[])"MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ addNode4ConsistentHashMode".getBytes("UTF-8")), "UTF-8"), null);
            configDataKeyMap.put(new String(BASE64EncoderStream.encode((byte[])"MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ MainMasterNodeInfo".getBytes("UTF-8")), "UTF-8"), null);
            configDataKeyMap.put(new String(BASE64EncoderStream.encode((byte[])"MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ KeyMapNodesInfo".getBytes("UTF-8")), "UTF-8"), null);
            configDataKeyMap.put(new String(BASE64EncoderStream.encode((byte[])"MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ SubKeyMapNodesInfo".getBytes("UTF-8")), "UTF-8"), null);
            configDataKeyMap.put(new String(BASE64EncoderStream.encode((byte[])"MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ ThirdKeyMapNodesInfo".getBytes("UTF-8")), "UTF-8"), null);
            configDataKeyMap.put(new String(BASE64EncoderStream.encode((byte[])"MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ KeyMapNodesRule".getBytes("UTF-8")), "UTF-8"), null);
            configDataKeyMap.put(new String(BASE64EncoderStream.encode((byte[])"MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ LoadBalanceMode".getBytes("UTF-8")), "UTF-8"), null);
            configDataKeyMap.put(new String(BASE64EncoderStream.encode((byte[])"MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ TransactionMode".getBytes("UTF-8")), "UTF-8"), null);
            configDataKeyMap.put(new String(BASE64EncoderStream.encode((byte[])"MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ TransactionManagerInfo".getBytes("UTF-8")), "UTF-8"), null);
            configDataKeyMap.put(new String(BASE64EncoderStream.encode((byte[])"MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ MainMasterNodeMode".getBytes("UTF-8")), "UTF-8"), null);
            configDataKeyMap.put(new String(BASE64EncoderStream.encode((byte[])"MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ SlaveMasterNodes".getBytes("UTF-8")), "UTF-8"), null);
            configDataKeyMap.put(new String(BASE64EncoderStream.encode((byte[])"MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ AllMasterNodeInfo".getBytes("UTF-8")), "UTF-8"), null);
            configDataKeyMap.put(new String(BASE64EncoderStream.encode((byte[])"MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ DistributionAlgorithm".getBytes("UTF-8")), "UTF-8"), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

