/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okuyama.imdst.util.ImdstDefine;

class InnerCustomRandomAccessFile
extends Thread {
    private ArrayBlockingQueue delayWriteQueue = new ArrayBlockingQueue(ImdstDefine.dataFileWriteDelayMaxSize);
    private ConcurrentHashMap delayWriteDifferenceMap = new ConcurrentHashMap(ImdstDefine.dataFileWriteDelayMaxSize, ImdstDefine.dataFileWriteDelayMaxSize - 20, 64);
    private RandomAccessFile readRaf = null;
    private RandomAccessFile writeRaf = null;
    private boolean throwExceptionFlg = false;
    private Exception throwException = null;
    private boolean endFlg = false;
    private boolean delayWriteEndStatus = false;
    private boolean execute = false;
    private int parallelSize = 4999;
    private Object[] syncObjList = null;
    private int defaultStart = 0;
    private int defaultSize = 0;

    public InnerCustomRandomAccessFile(File target, String type, int defaultStart, int defaultSize) throws FileNotFoundException {
        this.readRaf = new RandomAccessFile(target, type);
        this.writeRaf = new RandomAccessFile(target, type);
        this.syncObjList = new Object[this.parallelSize];
        for (int i = 0; i < this.parallelSize; ++i) {
            this.syncObjList[i] = new Object();
        }
        this.defaultStart = defaultStart;
        this.defaultSize = defaultSize;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long continuousnessWrite = 0L;
        int writeTimingCount = ImdstDefine.dataFileWriteDelayMaxSize / 10;
        int waitTimingCount = new Double((double)writeTimingCount * 0.7).intValue();
        boolean nowWrite = false;
        while (true) {
            Long seekPoint = null;
            if (this.endFlg) {
                this.delayWriteEndStatus = true;
                break;
            }
            try {
                int nowQueueSize = this.delayWriteQueue.size();
                if (this.execute || nowWrite || writeTimingCount < nowQueueSize) {
                    nowWrite = waitTimingCount <= nowQueueSize;
                    if (continuousnessWrite % 1000L == 0L) {
                        FileDescriptor fd = this.writeRaf.getFD();
                        fd.sync();
                    }
                    if ((seekPoint = (Long)this.delayWriteQueue.poll(500L, TimeUnit.MILLISECONDS)) == null) continue;
                    long longSeekPoint = seekPoint;
                    Object object = this.syncObjList[new Long(seekPoint % (long)this.parallelSize).intValue()];
                    synchronized (object) {
                        byte[] data = null;
                        data = (byte[])this.delayWriteDifferenceMap.get(seekPoint);
                        if (data != null) {
                            this.writeRaf.seek(longSeekPoint);
                            this.writeRaf.write(data, this.defaultStart, this.defaultSize);
                        }
                        ++continuousnessWrite;
                    }
                    this.delayWriteDifferenceMap.remove(seekPoint);
                    continue;
                }
                continuousnessWrite = 0L;
                Thread.sleep(500L);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.throwException = e;
                this.throwExceptionFlg = true;
                this.delayWriteEndStatus = true;
                break;
            }
        }
    }

    public void seekAndWrite(long seekPoint, byte[] data) throws IOException {
        this.seekAndWrite(seekPoint, data, this.defaultStart, this.defaultSize);
    }

    public void seekAndWrite(long seekPoint, byte[] data, int start, int size) throws IOException {
        if (this.throwExceptionFlg) {
            throw new IOException("delayDataFileWriteError [" + this.throwException.getMessage() + "]");
        }
        Long seekPointObj = new Long(seekPoint);
        this.delayWriteDifferenceMap.put(seekPointObj, data);
        try {
            this.delayWriteQueue.put(seekPointObj);
        }
        catch (Exception e) {
            throw new IOException("delayWriteQueue - put Error Message[" + e.getMessage() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int seekAndRead(long seekPoint, byte[] data, int start, int size) throws IOException {
        int ret;
        block7: {
            ret = 0;
            Long seekPointObj = new Long(seekPoint);
            byte[] readData = (byte[])this.delayWriteDifferenceMap.get(seekPointObj);
            if (readData != null) {
                for (int i = start; i < size; ++i) {
                    data[i] = readData[ret];
                    ++ret;
                }
                break block7;
            }
            Object object = this.syncObjList[new Long(seekPoint % (long)this.parallelSize).intValue()];
            synchronized (object) {
                this.readRaf.seek(seekPoint);
                ret = this.readRaf.read(data, start, size);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.execute = true;
            if (this.delayWriteEndStatus) {
                if (this.throwExceptionFlg) {
                    throw new IOException(this.throwException);
                }
                return;
            }
            while (this.delayWriteQueue.size() > 0) {
                Thread.sleep(10L);
            }
            this.endFlg = true;
            this.join();
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception ie) {
        }
        finally {
            if (this.readRaf != null) {
                this.readRaf.close();
                this.readRaf = null;
            }
            if (this.writeRaf != null) {
                this.writeRaf.close();
                this.writeRaf = null;
            }
        }
    }
}

