/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
public class MetricsTimeVaryingRate
extends MetricsBase {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.metrics.util");
    private Metrics currentData = new Metrics();
    private Metrics previousIntervalData = new Metrics();
    private MinMax minMax = new MinMax();

    public MetricsTimeVaryingRate(String nam, MetricsRegistry registry, String description) {
        super(nam, description);
        registry.add(nam, this);
    }

    public MetricsTimeVaryingRate(String nam, MetricsRegistry registry) {
        this(nam, registry, "NoDescription");
    }

    public synchronized void inc(int numOps, long time) {
        this.currentData.numOperations += numOps;
        this.currentData.time += time;
        long timePerOps = time / (long)numOps;
        this.minMax.update(timePerOps);
    }

    public synchronized void inc(long time) {
        ++this.currentData.numOperations;
        this.currentData.time += time;
        this.minMax.update(time);
    }

    private synchronized void intervalHeartBeat() {
        this.previousIntervalData.numOperations = this.currentData.numOperations;
        this.previousIntervalData.time = this.currentData.numOperations == 0 ? 0L : this.currentData.time / (long)this.currentData.numOperations;
        this.currentData.reset();
    }

    @Override
    public synchronized void pushMetric(MetricsRecord mr) {
        this.intervalHeartBeat();
        try {
            mr.incrMetric(this.getName() + "_num_ops", this.getPreviousIntervalNumOps());
            mr.setMetric(this.getName() + "_avg_time", this.getPreviousIntervalAverageTime());
        }
        catch (Exception e) {
            LOG.info((Object)("pushMetric failed for " + this.getName() + "\n" + StringUtils.stringifyException(e)));
        }
    }

    public synchronized int getPreviousIntervalNumOps() {
        return this.previousIntervalData.numOperations;
    }

    public synchronized long getPreviousIntervalAverageTime() {
        return this.previousIntervalData.time;
    }

    public synchronized long getMinTime() {
        return this.minMax.minTime;
    }

    public synchronized long getMaxTime() {
        return this.minMax.maxTime;
    }

    public synchronized void resetMinMax() {
        this.minMax.reset();
    }

    static class MinMax {
        long minTime = -1L;
        long maxTime = 0L;

        MinMax() {
        }

        void set(MinMax newVal) {
            this.minTime = newVal.minTime;
            this.maxTime = newVal.maxTime;
        }

        void reset() {
            this.minTime = -1L;
            this.maxTime = 0L;
        }

        void update(long time) {
            this.minTime = this.minTime == -1L ? time : Math.min(this.minTime, time);
            this.minTime = Math.min(this.minTime, time);
            this.maxTime = Math.max(this.maxTime, time);
        }
    }

    static class Metrics {
        int numOperations = 0;
        long time = 0L;

        Metrics() {
        }

        void set(Metrics resetTo) {
            this.numOperations = resetTo.numOperations;
            this.time = resetTo.time;
        }

        void reset() {
            this.numOperations = 0;
            this.time = 0L;
        }
    }
}

