/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.record.Record;
import org.apache.hadoop.record.RecordOutput;
import org.apache.hadoop.record.Utils;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class CsvRecordOutput
implements RecordOutput {
    private PrintStream stream;
    private boolean isFirst = true;

    private void throwExceptionOnError(String tag) throws IOException {
        if (this.stream.checkError()) {
            throw new IOException("Error serializing " + tag);
        }
    }

    private void printCommaUnlessFirst() {
        if (!this.isFirst) {
            this.stream.print(",");
        }
        this.isFirst = false;
    }

    public CsvRecordOutput(OutputStream out) {
        try {
            this.stream = new PrintStream(out, true, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void writeByte(byte b, String tag) throws IOException {
        this.writeLong(b, tag);
    }

    @Override
    public void writeBool(boolean b, String tag) throws IOException {
        this.printCommaUnlessFirst();
        String val = b ? "T" : "F";
        this.stream.print(val);
        this.throwExceptionOnError(tag);
    }

    @Override
    public void writeInt(int i, String tag) throws IOException {
        this.writeLong(i, tag);
    }

    @Override
    public void writeLong(long l, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print(l);
        this.throwExceptionOnError(tag);
    }

    @Override
    public void writeFloat(float f, String tag) throws IOException {
        this.writeDouble(f, tag);
    }

    @Override
    public void writeDouble(double d, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print(d);
        this.throwExceptionOnError(tag);
    }

    @Override
    public void writeString(String s, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print(Utils.toCSVString(s));
        this.throwExceptionOnError(tag);
    }

    @Override
    public void writeBuffer(Buffer buf, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print(Utils.toCSVBuffer(buf));
        this.throwExceptionOnError(tag);
    }

    @Override
    public void startRecord(Record r, String tag) throws IOException {
        if (tag != null && !"".equals(tag)) {
            this.printCommaUnlessFirst();
            this.stream.print("s{");
            this.isFirst = true;
        }
    }

    @Override
    public void endRecord(Record r, String tag) throws IOException {
        if (tag == null || "".equals(tag)) {
            this.stream.print("\n");
            this.isFirst = true;
        } else {
            this.stream.print("}");
            this.isFirst = false;
        }
    }

    @Override
    public void startVector(ArrayList v, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print("v{");
        this.isFirst = true;
    }

    @Override
    public void endVector(ArrayList v, String tag) throws IOException {
        this.stream.print("}");
        this.isFirst = false;
    }

    @Override
    public void startMap(TreeMap v, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print("m{");
        this.isFirst = true;
    }

    @Override
    public void endMap(TreeMap v, String tag) throws IOException {
        this.stream.print("}");
        this.isFirst = false;
    }
}

