/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Evolving
public class TokenStorage
implements Writable {
    private Map<Text, byte[]> secretKeysMap = new HashMap<Text, byte[]>();
    private Map<Text, Token<? extends TokenIdentifier>> tokenMap = new HashMap<Text, Token<? extends TokenIdentifier>>();

    public byte[] getSecretKey(Text alias) {
        return this.secretKeysMap.get(alias);
    }

    public Token<? extends TokenIdentifier> getToken(Text alias) {
        return this.tokenMap.get(alias);
    }

    public void addToken(Text alias, Token<? extends TokenIdentifier> t) {
        this.tokenMap.put(alias, t);
    }

    public Collection<Token<? extends TokenIdentifier>> getAllTokens() {
        return this.tokenMap.values();
    }

    public int numberOfTokens() {
        return this.tokenMap.size();
    }

    public int numberOfSecretKeys() {
        return this.secretKeysMap.size();
    }

    public void addSecretKey(Text alias, byte[] key) {
        this.secretKeysMap.put(alias, key);
    }

    public static void readTokensAndLoadInUGI(String filename, Configuration conf, UserGroupInformation ugi) throws IOException {
        Path localTokensFile = new Path(filename);
        LocalFileSystem localFS = FileSystem.getLocal(conf);
        FSDataInputStream in = localFS.open(localTokensFile);
        TokenStorage ts = new TokenStorage();
        ts.readFields(in);
        for (Token<? extends TokenIdentifier> token : ts.getAllTokens()) {
            ugi.addToken(token);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.tokenMap.size());
        for (Map.Entry<Text, Token<? extends TokenIdentifier>> entry : this.tokenMap.entrySet()) {
            entry.getKey().write(out);
            entry.getValue().write(out);
        }
        WritableUtils.writeVInt(out, this.secretKeysMap.size());
        for (Map.Entry<Text, Token<? extends TokenIdentifier>> entry : this.secretKeysMap.entrySet()) {
            entry.getKey().write(out);
            WritableUtils.writeCompressedByteArray(out, (byte[])entry.getValue());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        Text alias;
        int i;
        this.secretKeysMap.clear();
        this.tokenMap.clear();
        int size = WritableUtils.readVInt(in);
        for (i = 0; i < size; ++i) {
            alias = new Text();
            alias.readFields(in);
            Token t = new Token();
            t.readFields(in);
            this.tokenMap.put(alias, t);
        }
        size = WritableUtils.readVInt(in);
        for (i = 0; i < size; ++i) {
            alias = new Text();
            alias.readFields(in);
            byte[] key = WritableUtils.readCompressedByteArray(in);
            this.secretKeysMap.put(alias, key);
        }
    }
}

