/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RunJar {
    public static final Pattern MATCH_ANY = Pattern.compile(".*");

    public static void unJar(File jarFile, File toDir) throws IOException {
        RunJar.unJar(jarFile, toDir, MATCH_ANY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unJar(File jarFile, File toDir, Pattern unpackRegex) throws IOException {
        JarFile jar = new JarFile(jarFile);
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !unpackRegex.matcher(entry.getName()).matches()) continue;
                InputStream in = jar.getInputStream(entry);
                try {
                    File file = new File(toDir, entry.getName());
                    RunJar.ensureDirectory(file.getParentFile());
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        IOUtils.copyBytes(in, (OutputStream)out, 8192);
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            jar.close();
        }
    }

    private static void ensureDirectory(File dir) throws IOException {
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + dir.toString());
        }
    }

    public static void main(String[] args) throws Throwable {
        JarFile jarFile;
        String usage = "RunJar jarFile [mainClass] args...";
        if (args.length < 1) {
            System.err.println(usage);
            System.exit(-1);
        }
        int firstArg = 0;
        String fileName = args[firstArg++];
        File file = new File(fileName);
        String mainClassName = null;
        try {
            jarFile = new JarFile(fileName);
        }
        catch (IOException io) {
            throw new IOException("Error opening job jar: " + fileName).initCause(io);
        }
        Manifest manifest = jarFile.getManifest();
        if (manifest != null) {
            mainClassName = manifest.getMainAttributes().getValue("Main-Class");
        }
        jarFile.close();
        if (mainClassName == null) {
            if (args.length < 2) {
                System.err.println(usage);
                System.exit(-1);
            }
            mainClassName = args[firstArg++];
        }
        mainClassName = mainClassName.replaceAll("/", ".");
        File tmpDir = new File(new Configuration().get("hadoop.tmp.dir"));
        RunJar.ensureDirectory(tmpDir);
        final File workDir = File.createTempFile("hadoop-unjar", "", tmpDir);
        if (!workDir.delete()) {
            System.err.println("Delete failed for " + workDir);
            System.exit(-1);
        }
        RunJar.ensureDirectory(workDir);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    FileUtil.fullyDelete(workDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        RunJar.unJar(file, workDir);
        ArrayList<URL> classPath = new ArrayList<URL>();
        classPath.add(new File(workDir + "/").toURI().toURL());
        classPath.add(file.toURI().toURL());
        classPath.add(new File(workDir, "classes/").toURI().toURL());
        File[] libs = new File(workDir, "lib").listFiles();
        if (libs != null) {
            for (int i = 0; i < libs.length; ++i) {
                classPath.add(libs[i].toURI().toURL());
            }
        }
        URLClassLoader loader = new URLClassLoader(classPath.toArray(new URL[0]));
        Thread.currentThread().setContextClassLoader(loader);
        Class<?> mainClass = Class.forName(mainClassName, true, loader);
        Method main = mainClass.getMethod("main", Array.newInstance(String.class, 0).getClass());
        String[] newArgs = Arrays.asList(args).subList(firstArg, args.length).toArray(new String[0]);
        try {
            main.invoke(null, new Object[]{newArgs});
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

