/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.helper;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import okuyama.base.job.AbstractHelper;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.client.ImdstKeyValueClient;

public class HttpGatewayServerHelper
extends AbstractHelper {
    private static ILogger logger = LoggerFactory.createLogger(HttpGatewayServerHelper.class);

    @Override
    public void initHelper(String initValue) {
    }

    @Override
    public String executeHelper(String optionParam) throws BatchException {
        String retString = null;
        Socket socket = null;
        ImdstKeyValueClient imdstKeyValueClient = null;
        BufferedWriter outStr = null;
        BufferedOutputStream bos = null;
        BufferedReader in = null;
        Object[] parameters = super.getParameters();
        try {
            String inputLine;
            imdstKeyValueClient = new ImdstKeyValueClient();
            imdstKeyValueClient.setConnectionInfos((String[])parameters[1]);
            imdstKeyValueClient.autoConnect();
            socket = (Socket)parameters[0];
            outStr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            bos = new BufferedOutputStream(socket.getOutputStream());
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            int counter = 0;
            HashMap<String, String> headerMap = new HashMap<String, String>();
            String addSep = "";
            String body = null;
            int headerCounter = 0;
            while ((inputLine = in.readLine()) != null) {
                int i;
                String[] parts;
                StringBuilder dataBuf = new StringBuilder(1024);
                if (inputLine.trim().equals("") && ++counter == 1) {
                    if (headerMap.get("content-length") == null) break;
                    int contentSize = Integer.parseInt(((String)headerMap.get("content-length")).trim());
                    byte[] datas = new byte[contentSize];
                    for (int tt = 0; tt < contentSize; ++tt) {
                        datas[tt] = new Integer(in.read()).byteValue();
                    }
                    body = new String(datas, "utf-8");
                    break;
                }
                if (headerCounter != 0) {
                    parts = inputLine.trim().split(":");
                    addSep = "";
                    for (i = 1; i < parts.length; ++i) {
                        dataBuf.append(addSep);
                        dataBuf.append(parts[i]);
                        addSep = ":";
                    }
                    headerMap.put(parts[0].trim().toLowerCase(), dataBuf.toString());
                } else {
                    parts = inputLine.trim().split(" ");
                    addSep = "";
                    for (i = 1; i < parts.length; ++i) {
                        dataBuf.append(addSep);
                        dataBuf.append(parts[i]);
                        addSep = " ";
                    }
                    headerMap.put(parts[0].trim().toLowerCase(), dataBuf.toString().trim());
                }
                ++headerCounter;
            }
            if (headerMap.get("get") != null) {
                Object[] ret = null;
                String key = ((String)headerMap.get("get")).split(" ")[0].trim();
                String[] types = key.split("\\.");
                ret = imdstKeyValueClient.getByteValue(key);
                if (ret[0].equals("true")) {
                    byte[] fileByte = null;
                    fileByte = (byte[])ret[1];
                    outStr.write("HTTP/1.1 200 OK\r\n");
                    outStr.write("Date: " + new Date().toString() + "\r\n");
                    outStr.write("Server: Server: okuyama kvs web server\r\n");
                    outStr.write("Last-Modified: " + new Date().toString() + "\r\n");
                    outStr.write("ETag: None\r\n");
                    outStr.write("Accept-Ranges: bytes\r\n");
                    outStr.write("Content-Length: " + fileByte.length + "\r\n");
                    outStr.write("Keep-Alive: timeout=5, max=100\r\n");
                    outStr.write("Connection: Keep-Alive\r\n");
                    if (types[types.length - 1].equals("gif")) {
                        outStr.write("Content-Type: image/gif\r\n");
                    } else if (types[types.length - 1].equals("html")) {
                        outStr.write("Content-Type: text/html\r\n");
                    } else {
                        outStr.write("Content-Type: text/plain\r\n");
                    }
                    outStr.write("\r\n");
                    outStr.flush();
                    bos.write(fileByte);
                    bos.flush();
                } else if (ret[0].equals("false")) {
                    outStr.write("HTTP/1.1 404 Not Found\r\n");
                    outStr.write("Date: " + new Date().toString() + "\r\n");
                    outStr.write("Server: okuyama kvs web server\r\n");
                    outStr.write("Content-Length: " + "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>Not Found.</p></body></html>".length() + "\r\n");
                    outStr.write("Keep-Alive: timeout=5, max=100\r\n");
                    outStr.write("Connection: Keep-Alive\r\n");
                    outStr.write("Content-Type: text/html; charset=iso-8859-1\r\n");
                    outStr.write("\r\n");
                    outStr.write("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>Not Found.</p></body></html>\r\n");
                    outStr.write("\r\n");
                } else if (ret[0].equals("error")) {
                    outStr.write("HTTP/1.1 500 Internal Server Error\r\n");
                    outStr.write("Date: " + new Date().toString() + "\r\n");
                    outStr.write("Server: okuyama kvs web server\r\n");
                    outStr.write("Content-Length: " + "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><html><head><title>500 Internal Server Error</title></head><body><h1>Error</h1><p>Error.</p></body></html>".length() + "\r\n");
                    outStr.write("Keep-Alive: timeout=5, max=100\r\n");
                    outStr.write("Connection: Keep-Alive\r\n");
                    outStr.write("Content-Type: text/html; charset=iso-8859-1\r\n");
                    outStr.write("\r\n");
                    outStr.write("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><html><head><title>500 Internal Server Error</title></head><body><h1>Error</h1><p>Error.</p></body></html>\r\n");
                    outStr.write("\r\n");
                }
            } else {
                outStr.write("HTTP/1.1 501 Not Implemented\r\n");
                outStr.write("Date: " + new Date().toString() + "\r\n");
                outStr.write("Server: okuyama kvs web server\r\n");
                outStr.write("Content-Length: " + "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><html><head><title>501 Not Implemented</title></head><body><h1>Request Type Error</h1><p>The Request Type GET Only.</p></body></html>".length() + "\r\n");
                outStr.write("Keep-Alive: timeout=5, max=100\r\n");
                outStr.write("Connection: Keep-Alive\r\n");
                outStr.write("Content-Type: text/html; charset=iso-8859-1\r\n");
                outStr.write("\r\n");
                outStr.write("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><html><head><title>501 Not Implemented</title></head><body><h1>Request Type Error</h1><p>The Request Type GET Only.</p></body></html>\r\n");
                outStr.write("\r\n");
            }
            outStr.flush();
            retString = AbstractHelper.SUCCESS;
        }
        catch (Exception e) {
            logger.error("HttpGatewayServerHelper - executeHelper - Error", e);
            e.printStackTrace();
            retString = AbstractHelper.ERROR;
            throw new BatchException(e);
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                    socket = null;
                }
                if (imdstKeyValueClient != null) {
                    imdstKeyValueClient.close();
                    imdstKeyValueClient = null;
                }
            }
            catch (Exception e2) {
                logger.error("HttpGatewayServerHelper - executeHelper - Error2", e2);
                retString = AbstractHelper.ERROR;
                throw new BatchException(e2);
            }
        }
        return retString;
    }

    @Override
    public void endHelper() {
    }
}

