/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class IsolationRunner {
    private static final Log LOG = LogFactory.getLog((String)IsolationRunner.class.getName());

    private ClassLoader makeClassLoader(JobConf conf, File workDir) throws IOException {
        ArrayList<String> classPaths = new ArrayList<String>();
        String jar = conf.getJar();
        if (jar != null) {
            TaskRunner.appendJobJarClasspaths(conf.getJar(), classPaths);
        }
        classPaths.add(workDir.toString());
        URL[] urls = new URL[classPaths.size()];
        for (int i = 0; i < classPaths.size(); ++i) {
            urls[i] = new File((String)classPaths.get(i)).toURL();
        }
        return new URLClassLoader(urls);
    }

    boolean run(String[] args) throws ClassNotFoundException, IOException, InterruptedException {
        boolean isMap;
        if (args.length < 1) {
            System.out.println("Usage: IsolationRunner <path>/job.xml <optional-user-name>");
            return false;
        }
        File jobFilename = new File(args[0]);
        if (!jobFilename.exists() || !jobFilename.isFile()) {
            System.out.println(jobFilename + " is not a valid job file.");
            return false;
        }
        String user = args.length > 1 ? args[1] : UserGroupInformation.getCurrentUser().getShortUserName();
        JobConf conf = new JobConf(new Path(jobFilename.toString()));
        conf.setUser(user);
        TaskAttemptID taskId = TaskAttemptID.forName(conf.get("mapreduce.task.attempt.id"));
        if (taskId == null) {
            System.out.println("mapreduce.task.attempt.id not found in configuration; job.xml is not a task config");
        }
        if (!(isMap = conf.getBoolean("mapreduce.task.ismap", true))) {
            System.out.println("Only map tasks are supported.");
            return false;
        }
        int partition = conf.getInt("mapreduce.task.partition", 0);
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapreduce.cluster.local.dir");
        File workDirName = TaskRunner.formWorkDir(lDirAlloc, taskId, false, conf);
        local.setWorkingDirectory(new Path(workDirName.toString()));
        FileSystem.get((Configuration)conf).setWorkingDirectory(conf.getWorkingDirectory());
        ClassLoader classLoader = this.makeClassLoader(conf, new File(workDirName.toString()));
        Thread.currentThread().setContextClassLoader(classLoader);
        conf.setClassLoader(classLoader);
        Path localMetaSplit = new LocalDirAllocator("mapreduce.cluster.local.dir").getLocalPathToRead(TaskTracker.getLocalSplitMetaFile(conf.getUser(), taskId.getJobID().toString(), taskId.toString()), (Configuration)conf);
        FSDataInputStream splitFile = FileSystem.getLocal((Configuration)conf).open(localMetaSplit);
        JobSplit.TaskSplitIndex splitIndex = new JobSplit.TaskSplitIndex();
        splitIndex.readFields((DataInput)splitFile);
        splitFile.close();
        MapTask task = new MapTask(jobFilename.toString(), taskId, partition, splitIndex, 1);
        task.setConf(conf);
        ((Task)task).run(conf, new FakeUmbilical());
        return true;
    }

    public static void main(String[] args) throws ClassNotFoundException, IOException, InterruptedException {
        if (!new IsolationRunner().run(args)) {
            System.exit(1);
        }
    }

    static class FakeUmbilical
    implements TaskUmbilicalProtocol {
        FakeUmbilical() {
        }

        public long getProtocolVersion(String protocol, long clientVersion) {
            return 19L;
        }

        @Override
        public void done(TaskAttemptID taskid) throws IOException {
            LOG.info((Object)("Task " + taskid + " reporting done."));
        }

        @Override
        public void fsError(TaskAttemptID taskId, String message) throws IOException {
            LOG.info((Object)("Task " + taskId + " reporting file system error: " + message));
        }

        @Override
        public void shuffleError(TaskAttemptID taskId, String message) throws IOException {
            LOG.info((Object)("Task " + taskId + " reporting shuffle error: " + message));
        }

        @Override
        public void fatalError(TaskAttemptID taskId, String msg) throws IOException {
            LOG.info((Object)("Task " + taskId + " reporting fatal error: " + msg));
        }

        @Override
        public JvmTask getTask(JvmContext context) throws IOException {
            return null;
        }

        @Override
        public boolean ping(TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public void commitPending(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            this.statusUpdate(taskId, taskStatus);
        }

        @Override
        public boolean canCommit(TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public boolean statusUpdate(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            StringBuffer buf = new StringBuffer("Task ");
            buf.append(taskId);
            buf.append(" making progress to ");
            buf.append(taskStatus.getProgress());
            String state = taskStatus.getStateString();
            if (state != null) {
                buf.append(" and state of ");
                buf.append(state);
            }
            LOG.info((Object)buf.toString());
            return true;
        }

        @Override
        public void reportDiagnosticInfo(TaskAttemptID taskid, String trace) throws IOException {
            LOG.info((Object)("Task " + taskid + " has problem " + trace));
        }

        @Override
        public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, TaskAttemptID id) throws IOException {
            return new MapTaskCompletionEventsUpdate(TaskCompletionEvent.EMPTY_ARRAY, false);
        }

        @Override
        public void reportNextRecordRange(TaskAttemptID taskid, SortedRanges.Range range) throws IOException {
            LOG.info((Object)("Task " + taskid + " reportedNextRecordRange " + range));
        }
    }
}

