/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.DeprecatedQueueConfigurationParser;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.Queue;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.QueueConfigurationParser;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapreduce.QueueState;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;

class QueueManager {
    private static final Log LOG = LogFactory.getLog(QueueManager.class);
    private Map<String, Queue> leafQueues = new HashMap<String, Queue>();
    private Map<String, Queue> allQueues = new HashMap<String, Queue>();
    static final String QUEUE_CONF_FILE_NAME = "mapred-queues.xml";
    static final String QUEUE_CONF_DEFAULT_FILE_NAME = "mapred-queues-default.xml";
    static final String QUEUE_CONF_PROPERTY_NAME_PREFIX = "mapred.queue.";
    private Queue root = null;
    private boolean isAclEnabled = false;
    static final String MSG_REFRESH_FAILURE_WITH_CHANGE_OF_HIERARCHY = "Unable to refresh queues because queue-hierarchy changed. Retaining existing configuration. ";
    static final String MSG_REFRESH_FAILURE_WITH_SCHEDULER_FAILURE = "Scheduler couldn't refresh it's queues with the new configuration properties. Retaining existing configuration throughout the system.";

    static QueueConfigurationParser getQueueConfigurationParser(Configuration conf, boolean reloadConf) {
        if (conf != null && conf.get("mapred.queue.names") != null) {
            if (reloadConf) {
                conf.reloadConfiguration();
            }
            return new DeprecatedQueueConfigurationParser(conf);
        }
        URL xmlInUrl = Thread.currentThread().getContextClassLoader().getResource(QUEUE_CONF_FILE_NAME);
        if (xmlInUrl == null) {
            xmlInUrl = Thread.currentThread().getContextClassLoader().getResource(QUEUE_CONF_DEFAULT_FILE_NAME);
            assert (xmlInUrl != null);
        }
        InputStream stream = null;
        try {
            stream = xmlInUrl.openStream();
            QueueConfigurationParser queueConfigurationParser = new QueueConfigurationParser(new BufferedInputStream(stream));
            return queueConfigurationParser;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldn't open queue configuration at " + xmlInUrl, ioe);
        }
        finally {
            IOUtils.closeStream((Closeable)stream);
        }
    }

    public QueueManager() {
        this.initialize(QueueManager.getQueueConfigurationParser(null, false));
    }

    public QueueManager(Configuration conf) {
        this.initialize(QueueManager.getQueueConfigurationParser(conf, false));
    }

    QueueManager(String confFile) {
        QueueConfigurationParser cp = new QueueConfigurationParser(confFile);
        this.initialize(cp);
    }

    private void initialize(QueueConfigurationParser cp) {
        this.root = cp.getRoot();
        this.leafQueues.clear();
        this.allQueues.clear();
        this.leafQueues = this.getRoot().getLeafQueues();
        this.allQueues.putAll(this.getRoot().getInnerQueues());
        this.allQueues.putAll(this.leafQueues);
        LOG.info((Object)("AllQueues : " + this.allQueues + "; LeafQueues : " + this.leafQueues));
        this.isAclEnabled = cp.isAclsEnabled();
    }

    public synchronized Set<String> getLeafQueueNames() {
        return this.leafQueues.keySet();
    }

    public synchronized boolean hasAccess(String queueName, Queue.QueueOperation oper, UserGroupInformation ugi) {
        return this.hasAccess(queueName, null, oper, ugi);
    }

    public synchronized boolean hasAccess(String queueName, JobInProgress job, Queue.QueueOperation oper, UserGroupInformation ugi) {
        Queue q = this.leafQueues.get(queueName);
        if (q == null) {
            LOG.info((Object)("Queue " + queueName + " is not present"));
            return false;
        }
        if (q.getChildren() != null && !q.getChildren().isEmpty()) {
            LOG.info((Object)("Cannot submit job to parent queue " + q.getName()));
            return false;
        }
        if (!this.isAclsEnabled()) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("checking access for : " + QueueManager.toFullPropertyName(queueName, oper.getAclName())));
        }
        if (oper.isJobOwnerAllowed() && job != null && job.getJobConf().getUser().equals(ugi.getShortUserName())) {
            return true;
        }
        AccessControlList acl = q.getAcls().get(QueueManager.toFullPropertyName(queueName, oper.getAclName()));
        if (acl == null) {
            return false;
        }
        boolean allowed = acl.isAllAllowed();
        if (!allowed && acl.isUserAllowed(ugi)) {
            allowed = true;
        }
        return allowed;
    }

    synchronized boolean isRunning(String queueName) {
        Queue q = this.leafQueues.get(queueName);
        if (q != null) {
            return q.getState().equals((Object)QueueState.RUNNING);
        }
        return false;
    }

    public synchronized void setSchedulerInfo(String queueName, Object queueInfo) {
        if (this.allQueues.get(queueName) != null) {
            this.allQueues.get(queueName).setSchedulingInfo(queueInfo);
        }
    }

    public synchronized Object getSchedulerInfo(String queueName) {
        if (this.allQueues.get(queueName) != null) {
            return this.allQueues.get(queueName).getSchedulingInfo();
        }
        return null;
    }

    synchronized void refreshQueues(Configuration conf, TaskScheduler.QueueRefresher schedulerRefresher) throws IOException {
        QueueConfigurationParser cp = QueueManager.getQueueConfigurationParser(conf, true);
        if (!this.root.isHierarchySameAs(cp.getRoot())) {
            LOG.warn((Object)MSG_REFRESH_FAILURE_WITH_CHANGE_OF_HIERARCHY);
            throw new IOException(MSG_REFRESH_FAILURE_WITH_CHANGE_OF_HIERARCHY);
        }
        if (schedulerRefresher != null) {
            try {
                schedulerRefresher.refreshQueues(cp.getRoot().getJobQueueInfo().getChildren());
            }
            catch (Throwable e) {
                StringBuilder msg = new StringBuilder("Scheduler's refresh-queues failed with the exception : " + StringUtils.stringifyException((Throwable)e));
                msg.append("\n");
                msg.append(MSG_REFRESH_FAILURE_WITH_SCHEDULER_FAILURE);
                LOG.error((Object)msg.toString());
                throw new IOException(msg.toString());
            }
        }
        cp.getRoot().copySchedulingInfo(this.root);
        this.initialize(cp);
        LOG.info((Object)"Queue configuration is refreshed successfully.");
    }

    static final String toFullPropertyName(String queue, String property) {
        return QUEUE_CONF_PROPERTY_NAME_PREFIX + queue + "." + property;
    }

    synchronized JobQueueInfo[] getJobQueueInfos() {
        ArrayList<JobQueueInfo> queueInfoList = new ArrayList<JobQueueInfo>();
        for (String queue : this.allQueues.keySet()) {
            JobQueueInfo queueInfo = this.getJobQueueInfo(queue);
            if (queueInfo == null) continue;
            queueInfoList.add(queueInfo);
        }
        return queueInfoList.toArray(new JobQueueInfo[queueInfoList.size()]);
    }

    synchronized JobQueueInfo getJobQueueInfo(String queue) {
        if (this.allQueues.containsKey(queue)) {
            return this.allQueues.get(queue).getJobQueueInfo();
        }
        return null;
    }

    synchronized Map<String, JobQueueInfo> getJobQueueInfoMapping() {
        HashMap<String, JobQueueInfo> m = new HashMap<String, JobQueueInfo>();
        for (String key : this.allQueues.keySet()) {
            m.put(key, this.allQueues.get(key).getJobQueueInfo());
        }
        return m;
    }

    synchronized QueueAclsInfo[] getQueueAcls(UserGroupInformation ugi) throws IOException {
        ArrayList<QueueAclsInfo> queueAclsInfolist = new ArrayList<QueueAclsInfo>();
        Queue.QueueOperation[] operations = Queue.QueueOperation.values();
        for (String queueName : this.leafQueues.keySet()) {
            QueueAclsInfo queueAclsInfo = null;
            ArrayList<String> operationsAllowed = null;
            for (Queue.QueueOperation operation : operations) {
                if (!this.hasAccess(queueName, operation, ugi)) continue;
                if (operationsAllowed == null) {
                    operationsAllowed = new ArrayList<String>();
                }
                operationsAllowed.add(operation.getAclName());
            }
            if (operationsAllowed == null) continue;
            queueAclsInfo = new QueueAclsInfo(queueName, operationsAllowed.toArray(new String[operationsAllowed.size()]));
            queueAclsInfolist.add(queueAclsInfo);
        }
        return queueAclsInfolist.toArray(new QueueAclsInfo[queueAclsInfolist.size()]);
    }

    synchronized void setQueues(Queue[] queues) {
        this.root.getChildren().clear();
        this.leafQueues.clear();
        this.allQueues.clear();
        for (Queue queue : queues) {
            this.root.addChild(queue);
        }
        this.leafQueues = this.getRoot().getLeafQueues();
        this.allQueues.putAll(this.getRoot().getInnerQueues());
        this.allQueues.putAll(this.leafQueues);
    }

    JobQueueInfo[] getRootQueues() {
        List<JobQueueInfo> list = this.getRoot().getJobQueueInfo().getChildren();
        return list.toArray(new JobQueueInfo[list.size()]);
    }

    JobQueueInfo[] getChildQueues(String queueName) {
        List<JobQueueInfo> list = this.allQueues.get(queueName).getJobQueueInfo().getChildren();
        if (list != null) {
            return list.toArray(new JobQueueInfo[list.size()]);
        }
        return new JobQueueInfo[0];
    }

    Queue getQueue(String queueName) {
        return this.allQueues.get(queueName);
    }

    boolean isAclsEnabled() {
        return this.isAclEnabled;
    }

    Queue getRoot() {
        return this.root;
    }

    static void dumpConfiguration(Writer out, Configuration conf) throws IOException {
        QueueManager.dumpConfiguration(out, null, conf);
    }

    static void dumpConfiguration(Writer out, String configFile, Configuration conf) throws IOException {
        if (conf != null && conf.get("mapred.queue.names") != null) {
            return;
        }
        JsonFactory dumpFactory = new JsonFactory();
        JsonGenerator dumpGenerator = dumpFactory.createJsonGenerator(out);
        QueueConfigurationParser parser = configFile != null && !"".equals(configFile) ? new QueueConfigurationParser(configFile) : QueueManager.getQueueConfigurationParser(null, false);
        dumpGenerator.writeStartObject();
        dumpGenerator.writeBooleanField("acls_enabled", parser.isAclsEnabled());
        dumpGenerator.writeFieldName("queues");
        dumpGenerator.writeStartArray();
        QueueManager.dumpConfiguration(dumpGenerator, parser.getRoot().getChildren());
        dumpGenerator.writeEndArray();
        dumpGenerator.writeEndObject();
        dumpGenerator.flush();
    }

    private static void dumpConfiguration(JsonGenerator dumpGenerator, Set<Queue> rootQueues) throws JsonGenerationException, IOException {
        for (Queue queue : rootQueues) {
            dumpGenerator.writeStartObject();
            dumpGenerator.writeStringField("name", queue.getName());
            dumpGenerator.writeStringField("state", queue.getState().toString());
            AccessControlList submitJobList = null;
            AccessControlList administerJobsList = null;
            if (queue.getAcls() != null) {
                submitJobList = queue.getAcls().get(QueueManager.toFullPropertyName(queue.getName(), Queue.QueueOperation.SUBMIT_JOB.getAclName()));
                administerJobsList = queue.getAcls().get(QueueManager.toFullPropertyName(queue.getName(), Queue.QueueOperation.ADMINISTER_JOBS.getAclName()));
            }
            StringBuilder aclsSubmitJobValue = new StringBuilder();
            if (submitJobList != null) {
                aclsSubmitJobValue = QueueManager.getAclsInfo(submitJobList);
            }
            dumpGenerator.writeStringField("acl_submit_job", aclsSubmitJobValue.toString());
            StringBuilder aclsAdministerValue = new StringBuilder();
            if (administerJobsList != null) {
                aclsAdministerValue = QueueManager.getAclsInfo(administerJobsList);
            }
            dumpGenerator.writeStringField("acl_administer_jobs", aclsAdministerValue.toString());
            dumpGenerator.writeFieldName("properties");
            dumpGenerator.writeStartArray();
            if (queue.getProperties() != null) {
                for (Map.Entry<Object, Object> property : queue.getProperties().entrySet()) {
                    dumpGenerator.writeStartObject();
                    dumpGenerator.writeStringField("key", (String)property.getKey());
                    dumpGenerator.writeStringField("value", (String)property.getValue());
                    dumpGenerator.writeEndObject();
                }
            }
            dumpGenerator.writeEndArray();
            Set<Queue> childQueues = queue.getChildren();
            dumpGenerator.writeFieldName("children");
            dumpGenerator.writeStartArray();
            if (childQueues != null && childQueues.size() > 0) {
                QueueManager.dumpConfiguration(dumpGenerator, childQueues);
            }
            dumpGenerator.writeEndArray();
            dumpGenerator.writeEndObject();
        }
    }

    private static StringBuilder getAclsInfo(AccessControlList accessControlList) {
        return new StringBuilder(accessControlList.toString());
    }
}

