/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class NLineInputFormat
extends FileInputFormat<LongWritable, Text>
implements JobConfigurable {
    private int N = 1;

    @Override
    public RecordReader<LongWritable, Text> getRecordReader(InputSplit genericSplit, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(genericSplit.toString());
        return new LineRecordReader(job, (FileSplit)genericSplit);
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        for (FileStatus status : this.listStatus(job)) {
            for (org.apache.hadoop.mapreduce.lib.input.FileSplit split : org.apache.hadoop.mapreduce.lib.input.NLineInputFormat.getSplitsForFile(status, job, this.N)) {
                splits.add(new FileSplit(split));
            }
        }
        return splits.toArray(new FileSplit[splits.size()]);
    }

    @Override
    public void configure(JobConf conf) {
        this.N = conf.getInt("mapreduce.input.lineinputformat.linespermap", 1);
    }
}

