/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInfoChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInitedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobPriorityChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmittedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskUpdatedEvent;
import org.apache.hadoop.security.authorize.AccessControlList;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobHistoryParser {
    private final FSDataInputStream in;
    JobInfo info = null;

    public JobHistoryParser(FileSystem fs, String file) throws IOException {
        this(fs, new Path(file));
    }

    public JobHistoryParser(FileSystem fs, Path historyFile) throws IOException {
        this(fs.open(historyFile));
    }

    public JobHistoryParser(FSDataInputStream in) {
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JobInfo parse() throws IOException {
        if (this.info != null) {
            return this.info;
        }
        EventReader reader = new EventReader((DataInputStream)this.in);
        this.info = new JobInfo();
        try {
            HistoryEvent event;
            while ((event = reader.getNextEvent()) != null) {
                this.handleEvent(event);
            }
        }
        finally {
            this.in.close();
        }
        return this.info;
    }

    private void handleEvent(HistoryEvent event) throws IOException {
        EventType type = event.getEventType();
        switch (type) {
            case JOB_SUBMITTED: {
                this.handleJobSubmittedEvent((JobSubmittedEvent)event);
                break;
            }
            case JOB_STATUS_CHANGED: {
                break;
            }
            case JOB_INFO_CHANGED: {
                this.handleJobInfoChangeEvent((JobInfoChangeEvent)event);
                break;
            }
            case JOB_INITED: {
                this.handleJobInitedEvent((JobInitedEvent)event);
                break;
            }
            case JOB_PRIORITY_CHANGED: {
                this.handleJobPriorityChangeEvent((JobPriorityChangeEvent)event);
                break;
            }
            case JOB_FAILED: 
            case JOB_KILLED: {
                this.handleJobFailedEvent((JobUnsuccessfulCompletionEvent)event);
                break;
            }
            case JOB_FINISHED: {
                this.handleJobFinishedEvent((JobFinishedEvent)event);
                break;
            }
            case TASK_STARTED: {
                this.handleTaskStartedEvent((TaskStartedEvent)event);
                break;
            }
            case TASK_FAILED: {
                this.handleTaskFailedEvent((TaskFailedEvent)event);
                break;
            }
            case TASK_UPDATED: {
                this.handleTaskUpdatedEvent((TaskUpdatedEvent)event);
                break;
            }
            case TASK_FINISHED: {
                this.handleTaskFinishedEvent((TaskFinishedEvent)event);
                break;
            }
            case MAP_ATTEMPT_STARTED: 
            case CLEANUP_ATTEMPT_STARTED: 
            case REDUCE_ATTEMPT_STARTED: 
            case SETUP_ATTEMPT_STARTED: {
                this.handleTaskAttemptStartedEvent((TaskAttemptStartedEvent)event);
                break;
            }
            case MAP_ATTEMPT_FAILED: 
            case CLEANUP_ATTEMPT_FAILED: 
            case REDUCE_ATTEMPT_FAILED: 
            case SETUP_ATTEMPT_FAILED: 
            case MAP_ATTEMPT_KILLED: 
            case CLEANUP_ATTEMPT_KILLED: 
            case REDUCE_ATTEMPT_KILLED: 
            case SETUP_ATTEMPT_KILLED: {
                this.handleTaskAttemptFailedEvent((TaskAttemptUnsuccessfulCompletionEvent)event);
                break;
            }
            case MAP_ATTEMPT_FINISHED: {
                this.handleMapAttemptFinishedEvent((MapAttemptFinishedEvent)event);
                break;
            }
            case REDUCE_ATTEMPT_FINISHED: {
                this.handleReduceAttemptFinishedEvent((ReduceAttemptFinishedEvent)event);
                break;
            }
            case SETUP_ATTEMPT_FINISHED: 
            case CLEANUP_ATTEMPT_FINISHED: {
                this.handleTaskAttemptFinishedEvent((TaskAttemptFinishedEvent)event);
                break;
            }
        }
    }

    private void handleTaskAttemptFinishedEvent(TaskAttemptFinishedEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        TaskAttemptInfo attemptInfo = taskInfo.attemptsMap.get(event.getAttemptId());
        attemptInfo.finishTime = event.getFinishTime();
        attemptInfo.status = event.getTaskStatus();
        attemptInfo.state = event.getState();
        attemptInfo.counters = event.getCounters();
        attemptInfo.hostname = event.getHostname();
    }

    private void handleReduceAttemptFinishedEvent(ReduceAttemptFinishedEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        TaskAttemptInfo attemptInfo = taskInfo.attemptsMap.get(event.getAttemptId());
        attemptInfo.finishTime = event.getFinishTime();
        attemptInfo.status = event.getTaskStatus();
        attemptInfo.state = event.getState();
        attemptInfo.shuffleFinishTime = event.getShuffleFinishTime();
        attemptInfo.sortFinishTime = event.getSortFinishTime();
        attemptInfo.counters = event.getCounters();
        attemptInfo.hostname = event.getHostname();
    }

    private void handleMapAttemptFinishedEvent(MapAttemptFinishedEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        TaskAttemptInfo attemptInfo = taskInfo.attemptsMap.get(event.getAttemptId());
        attemptInfo.finishTime = event.getFinishTime();
        attemptInfo.status = event.getTaskStatus();
        attemptInfo.state = event.getState();
        attemptInfo.mapFinishTime = event.getMapFinishTime();
        attemptInfo.counters = event.getCounters();
        attemptInfo.hostname = event.getHostname();
    }

    private void handleTaskAttemptFailedEvent(TaskAttemptUnsuccessfulCompletionEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        TaskAttemptInfo attemptInfo = taskInfo.attemptsMap.get(event.getTaskAttemptId());
        attemptInfo.finishTime = event.getFinishTime();
        attemptInfo.error = event.getError();
        attemptInfo.status = event.getTaskStatus();
        attemptInfo.hostname = event.getHostname();
        attemptInfo.shuffleFinishTime = event.getFinishTime();
        attemptInfo.sortFinishTime = event.getFinishTime();
        attemptInfo.mapFinishTime = event.getFinishTime();
    }

    private void handleTaskAttemptStartedEvent(TaskAttemptStartedEvent event) {
        TaskAttemptID attemptId = event.getTaskAttemptId();
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        TaskAttemptInfo attemptInfo = new TaskAttemptInfo();
        attemptInfo.startTime = event.getStartTime();
        attemptInfo.attemptId = event.getTaskAttemptId();
        attemptInfo.httpPort = event.getHttpPort();
        attemptInfo.trackerName = event.getTrackerName();
        attemptInfo.taskType = event.getTaskType();
        taskInfo.attemptsMap.put(attemptId, attemptInfo);
    }

    private void handleTaskFinishedEvent(TaskFinishedEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        taskInfo.counters = event.getCounters();
        taskInfo.finishTime = event.getFinishTime();
        taskInfo.status = TaskStatus.State.SUCCEEDED.toString();
    }

    private void handleTaskUpdatedEvent(TaskUpdatedEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        taskInfo.finishTime = event.getFinishTime();
    }

    private void handleTaskFailedEvent(TaskFailedEvent event) {
        TaskInfo taskInfo = this.info.tasksMap.get(event.getTaskId());
        taskInfo.status = TaskStatus.State.FAILED.toString();
        taskInfo.finishTime = event.getFinishTime();
        taskInfo.error = event.getError();
        taskInfo.failedDueToAttemptId = event.getFailedAttemptID();
    }

    private void handleTaskStartedEvent(TaskStartedEvent event) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.taskId = event.getTaskId();
        taskInfo.startTime = event.getStartTime();
        taskInfo.taskType = event.getTaskType();
        taskInfo.splitLocations = event.getSplitLocations();
        this.info.tasksMap.put(event.getTaskId(), taskInfo);
    }

    private void handleJobFailedEvent(JobUnsuccessfulCompletionEvent event) {
        this.info.finishTime = event.getFinishTime();
        this.info.finishedMaps = event.getFinishedMaps();
        this.info.finishedReduces = event.getFinishedReduces();
        this.info.jobStatus = event.getStatus();
    }

    private void handleJobFinishedEvent(JobFinishedEvent event) {
        this.info.finishTime = event.getFinishTime();
        this.info.finishedMaps = event.getFinishedMaps();
        this.info.finishedReduces = event.getFinishedReduces();
        this.info.failedMaps = event.getFailedMaps();
        this.info.failedReduces = event.getFailedReduces();
        this.info.totalCounters = event.getTotalCounters();
        this.info.mapCounters = event.getMapCounters();
        this.info.reduceCounters = event.getReduceCounters();
        this.info.jobStatus = JobStatus.getJobRunState(JobStatus.SUCCEEDED);
    }

    private void handleJobPriorityChangeEvent(JobPriorityChangeEvent event) {
        this.info.priority = event.getPriority();
    }

    private void handleJobInitedEvent(JobInitedEvent event) {
        this.info.launchTime = event.getLaunchTime();
        this.info.totalMaps = event.getTotalMaps();
        this.info.totalReduces = event.getTotalReduces();
    }

    private void handleJobInfoChangeEvent(JobInfoChangeEvent event) {
        this.info.submitTime = event.getSubmitTime();
        this.info.launchTime = event.getLaunchTime();
    }

    private void handleJobSubmittedEvent(JobSubmittedEvent event) {
        this.info.jobid = event.getJobId();
        this.info.jobname = event.getJobName();
        this.info.username = event.getUserName();
        this.info.submitTime = event.getSubmitTime();
        this.info.jobConfPath = event.getJobConfPath();
        this.info.jobACLs = event.getJobAcls();
    }

    public static class TaskAttemptInfo {
        TaskAttemptID attemptId;
        long startTime = -1L;
        long finishTime = -1L;
        long shuffleFinishTime = -1L;
        long sortFinishTime = -1L;
        long mapFinishTime = -1L;
        String error = "";
        String status;
        String state = "";
        TaskType taskType;
        String trackerName = "";
        Counters counters;
        int httpPort = -1;
        String hostname = "";

        public void printAll() {
            System.out.println("ATTEMPT_ID:" + this.attemptId.toString());
            System.out.println("START_TIME: " + this.startTime);
            System.out.println("FINISH_TIME:" + this.finishTime);
            System.out.println("ERROR:" + this.error);
            System.out.println("TASK_STATUS:" + this.status);
            System.out.println("STATE:" + this.state);
            System.out.println("TASK_TYPE:" + (Object)((Object)this.taskType));
            System.out.println("TRACKER_NAME:" + this.trackerName);
            System.out.println("HTTP_PORT:" + this.httpPort);
            if (this.counters != null) {
                System.out.println("COUNTERS:" + this.counters.toString());
            }
        }

        public TaskAttemptID getAttemptId() {
            return this.attemptId;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getFinishTime() {
            return this.finishTime;
        }

        public long getShuffleFinishTime() {
            return this.shuffleFinishTime;
        }

        public long getSortFinishTime() {
            return this.sortFinishTime;
        }

        public long getMapFinishTime() {
            return this.mapFinishTime;
        }

        public String getError() {
            return this.error;
        }

        public String getState() {
            return this.state;
        }

        public String getTaskStatus() {
            return this.status;
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        public String getTrackerName() {
            return this.trackerName;
        }

        public String getHostname() {
            return this.hostname;
        }

        public Counters getCounters() {
            return this.counters;
        }

        public int getHttpPort() {
            return this.httpPort;
        }
    }

    public static class TaskInfo {
        TaskID taskId;
        long startTime = -1L;
        long finishTime = -1L;
        TaskType taskType;
        String splitLocations = "";
        Counters counters;
        String status;
        String error = "";
        TaskAttemptID failedDueToAttemptId;
        Map<TaskAttemptID, TaskAttemptInfo> attemptsMap = new HashMap<TaskAttemptID, TaskAttemptInfo>();

        public void printAll() {
            System.out.println("TASK_ID:" + this.taskId.toString());
            System.out.println("START_TIME: " + this.startTime);
            System.out.println("FINISH_TIME:" + this.finishTime);
            System.out.println("TASK_TYPE:" + (Object)((Object)this.taskType));
            if (this.counters != null) {
                System.out.println("COUNTERS:" + this.counters.toString());
            }
            for (TaskAttemptInfo tinfo : this.attemptsMap.values()) {
                tinfo.printAll();
            }
        }

        public TaskID getTaskId() {
            return this.taskId;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getFinishTime() {
            return this.finishTime;
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        public String getSplitLocations() {
            return this.splitLocations;
        }

        public Counters getCounters() {
            return this.counters;
        }

        public String getTaskStatus() {
            return this.status;
        }

        public TaskAttemptID getFailedDueToAttemptId() {
            return this.failedDueToAttemptId;
        }

        public String getError() {
            return this.error;
        }

        public Map<TaskAttemptID, TaskAttemptInfo> getAllTaskAttempts() {
            return this.attemptsMap;
        }
    }

    public static class JobInfo {
        long submitTime = -1L;
        long finishTime = -1L;
        JobID jobid;
        String username = "";
        String jobname = "";
        String jobConfPath = "";
        long launchTime = -1L;
        int totalMaps = 0;
        int totalReduces = 0;
        int failedMaps = 0;
        int failedReduces = 0;
        int finishedMaps = 0;
        int finishedReduces = 0;
        String jobStatus;
        Counters totalCounters;
        Counters mapCounters;
        Counters reduceCounters;
        JobPriority priority;
        Map<JobACL, AccessControlList> jobACLs;
        Map<TaskID, TaskInfo> tasksMap = new HashMap<TaskID, TaskInfo>();

        public JobInfo() {
            this.jobACLs = new HashMap<JobACL, AccessControlList>();
        }

        public void printAll() {
            System.out.println("JOBNAME: " + this.jobname);
            System.out.println("USERNAME: " + this.username);
            System.out.println("SUBMIT_TIME" + this.submitTime);
            System.out.println("LAUNCH_TIME: " + this.launchTime);
            System.out.println("JOB_STATUS: " + this.jobStatus);
            System.out.println("PRIORITY: " + (Object)((Object)this.priority));
            System.out.println("TOTAL_MAPS: " + this.totalMaps);
            System.out.println("TOTAL_REDUCES: " + this.totalReduces);
            System.out.println("MAP_COUNTERS:" + this.mapCounters.toString());
            System.out.println("REDUCE_COUNTERS:" + this.reduceCounters.toString());
            System.out.println("TOTAL_COUNTERS: " + this.totalCounters.toString());
            for (TaskInfo ti : this.tasksMap.values()) {
                ti.printAll();
            }
        }

        public long getSubmitTime() {
            return this.submitTime;
        }

        public long getFinishTime() {
            return this.finishTime;
        }

        public JobID getJobId() {
            return this.jobid;
        }

        public String getUsername() {
            return this.username;
        }

        public String getJobname() {
            return this.jobname;
        }

        public String getJobConfPath() {
            return this.jobConfPath;
        }

        public long getLaunchTime() {
            return this.launchTime;
        }

        public long getTotalMaps() {
            return this.totalMaps;
        }

        public long getTotalReduces() {
            return this.totalReduces;
        }

        public long getFailedMaps() {
            return this.failedMaps;
        }

        public long getFailedReduces() {
            return this.failedReduces;
        }

        public long getFinishedMaps() {
            return this.finishedMaps;
        }

        public long getFinishedReduces() {
            return this.finishedReduces;
        }

        public String getJobStatus() {
            return this.jobStatus;
        }

        public Counters getTotalCounters() {
            return this.totalCounters;
        }

        public Counters getMapCounters() {
            return this.mapCounters;
        }

        public Counters getReduceCounters() {
            return this.reduceCounters;
        }

        public Map<TaskID, TaskInfo> getAllTasks() {
            return this.tasksMap;
        }

        public String getPriority() {
            return this.priority.toString();
        }

        public Map<JobACL, AccessControlList> getJobACLs() {
            return this.jobACLs;
        }
    }
}

