/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinished;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskAttemptFinishedEvent
implements HistoryEvent {
    private TaskAttemptFinished datum = new TaskAttemptFinished();

    public TaskAttemptFinishedEvent(TaskAttemptID id, TaskType taskType, String taskStatus, long finishTime, String hostname, String state, Counters counters) {
        this.datum.taskid = new Utf8(id.getTaskID().toString());
        this.datum.attemptId = new Utf8(id.toString());
        this.datum.taskType = new Utf8(taskType.name());
        this.datum.taskStatus = new Utf8(taskStatus);
        this.datum.finishTime = finishTime;
        this.datum.hostname = new Utf8(hostname);
        this.datum.state = new Utf8(state);
        this.datum.counters = EventWriter.toAvro(counters);
    }

    TaskAttemptFinishedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (TaskAttemptFinished)((Object)datum);
    }

    public TaskID getTaskId() {
        return TaskID.forName(this.datum.taskid.toString());
    }

    public TaskAttemptID getAttemptId() {
        return TaskAttemptID.forName(this.datum.attemptId.toString());
    }

    public TaskType getTaskType() {
        return TaskType.valueOf(this.datum.taskType.toString());
    }

    public String getTaskStatus() {
        return this.datum.taskStatus.toString();
    }

    public long getFinishTime() {
        return this.datum.finishTime;
    }

    public String getHostname() {
        return this.datum.hostname.toString();
    }

    public String getState() {
        return this.datum.state.toString();
    }

    Counters getCounters() {
        return EventReader.fromAvro(this.datum.counters);
    }

    @Override
    public EventType getEventType() {
        return this.getTaskId().getTaskType() == TaskType.MAP ? EventType.MAP_ATTEMPT_FINISHED : EventType.REDUCE_ATTEMPT_FINISHED;
    }
}

