/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.security.BlockAccessToken;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface DataTransferProtocol {
    public static final int DATA_TRANSFER_VERSION = 19;
    @Deprecated
    public static final byte OP_WRITE_BLOCK = Op.WRITE_BLOCK.code;
    @Deprecated
    public static final byte OP_READ_BLOCK = Op.READ_BLOCK.code;
    @Deprecated
    public static final byte OP_READ_METADATA = Op.READ_METADATA.code;
    @Deprecated
    public static final byte OP_REPLACE_BLOCK = Op.REPLACE_BLOCK.code;
    @Deprecated
    public static final byte OP_COPY_BLOCK = Op.COPY_BLOCK.code;
    @Deprecated
    public static final byte OP_BLOCK_CHECKSUM = Op.BLOCK_CHECKSUM.code;
    @Deprecated
    public static final int OP_STATUS_SUCCESS = Status.access$000(Status.SUCCESS);
    @Deprecated
    public static final int OP_STATUS_ERROR = Status.access$000(Status.ERROR);
    @Deprecated
    public static final int OP_STATUS_ERROR_CHECKSUM = Status.access$000(Status.ERROR_CHECKSUM);
    @Deprecated
    public static final int OP_STATUS_ERROR_INVALID = Status.access$000(Status.ERROR_INVALID);
    @Deprecated
    public static final int OP_STATUS_ERROR_EXISTS = Status.access$000(Status.ERROR_EXISTS);
    @Deprecated
    public static final int OP_STATUS_ERROR_ACCESS_TOKEN = Status.access$000(Status.ERROR_ACCESS_TOKEN);
    @Deprecated
    public static final int OP_STATUS_CHECKSUM_OK = Status.access$000(Status.CHECKSUM_OK);
    public static final String __PARANAMER_DATA = "";

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class PipelineAck
    implements Writable {
        private long seqno;
        private Status[] replies;
        public static final long UNKOWN_SEQNO = -2L;
        public static final String __PARANAMER_DATA = "<init> long,org.apache.hadoop.hdfs.protocol.DataTransferProtocol.Status[] seqno,replies \ngetReply int i \nreadFields java.io.DataInput in \nwrite java.io.DataOutput out \n";

        public PipelineAck() {
        }

        public PipelineAck(long seqno, Status[] replies) {
            this.seqno = seqno;
            this.replies = replies;
        }

        public long getSeqno() {
            return this.seqno;
        }

        public short getNumOfReplies() {
            return (short)this.replies.length;
        }

        public Status getReply(int i) {
            if (i < 0 || i >= this.replies.length) {
                throw new IllegalArgumentException("The input parameter " + i + " should in the range of [0, " + this.replies.length);
            }
            return this.replies[i];
        }

        public boolean isSuccess() {
            for (Status reply : this.replies) {
                if (reply == Status.SUCCESS) continue;
                return false;
            }
            return true;
        }

        public void readFields(DataInput in) throws IOException {
            this.seqno = in.readLong();
            int numOfReplies = in.readShort();
            this.replies = new Status[numOfReplies];
            for (int i = 0; i < numOfReplies; ++i) {
                this.replies[i] = Status.read(in);
            }
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.seqno);
            out.writeShort((short)this.replies.length);
            for (Status reply : this.replies) {
                reply.write(out);
            }
        }

        public String toString() {
            StringBuilder ack = new StringBuilder("Replies for seqno ");
            ack.append(this.seqno).append(" are");
            for (Status reply : this.replies) {
                ack.append(" ");
                ack.append((Object)reply);
            }
            return ack.toString();
        }
    }

    public static abstract class Receiver {
        public static final String __PARANAMER_DATA = "readOp java.io.DataInputStream in \nopBlockChecksum java.io.DataInputStream,long,long,org.apache.hadoop.hdfs.security.BlockAccessToken in,blockId,blockGs,accesstoken \nopCopyBlock java.io.DataInputStream,long,long,org.apache.hadoop.hdfs.security.BlockAccessToken in,blockId,blockGs,accesstoken \nopReadBlock java.io.DataInputStream,long,long,long,long,java.lang.String,org.apache.hadoop.hdfs.security.BlockAccessToken in,blockId,blockGs,offset,length,client,accesstoken \nopReplaceBlock java.io.DataInputStream,long,long,java.lang.String,org.apache.hadoop.hdfs.protocol.DatanodeInfo,org.apache.hadoop.hdfs.security.BlockAccessToken in,blockId,blockGs,sourceId,src,accesstoken \nopWriteBlock java.io.DataInputStream,long,long,int,org.apache.hadoop.hdfs.protocol.DataTransferProtocol.BlockConstructionStage,long,long,long,java.lang.String,org.apache.hadoop.hdfs.protocol.DatanodeInfo,org.apache.hadoop.hdfs.protocol.DatanodeInfo[],org.apache.hadoop.hdfs.security.BlockAccessToken in,blockId,blockGs,pipelineSize,stage,newGs,minBytesRcvd,maxBytesRcvd,client,src,targets,accesstoken \nprocessOp org.apache.hadoop.hdfs.protocol.DataTransferProtocol.Op,java.io.DataInputStream op,in \n";

        protected final Op readOp(DataInputStream in) throws IOException {
            short version = in.readShort();
            if (version != 19) {
                throw new IOException("Version Mismatch (Expected: 19, Received: " + version + " )");
            }
            return Op.read(in);
        }

        protected final void processOp(Op op, DataInputStream in) throws IOException {
            switch (op) {
                case READ_BLOCK: {
                    this.opReadBlock(in);
                    break;
                }
                case WRITE_BLOCK: {
                    this.opWriteBlock(in);
                    break;
                }
                case REPLACE_BLOCK: {
                    this.opReplaceBlock(in);
                    break;
                }
                case COPY_BLOCK: {
                    this.opCopyBlock(in);
                    break;
                }
                case BLOCK_CHECKSUM: {
                    this.opBlockChecksum(in);
                    break;
                }
                default: {
                    throw new IOException("Unknown op " + (Object)((Object)op) + " in data stream");
                }
            }
        }

        private void opReadBlock(DataInputStream in) throws IOException {
            long blockId = in.readLong();
            long blockGs = in.readLong();
            long offset = in.readLong();
            long length = in.readLong();
            String client = Text.readString((DataInput)in);
            BlockAccessToken accesstoken = Receiver.readAccessToken(in);
            this.opReadBlock(in, blockId, blockGs, offset, length, client, accesstoken);
        }

        protected abstract void opReadBlock(DataInputStream var1, long var2, long var4, long var6, long var8, String var10, BlockAccessToken var11) throws IOException;

        private void opWriteBlock(DataInputStream in) throws IOException {
            long blockId = in.readLong();
            long blockGs = in.readLong();
            int pipelineSize = in.readInt();
            BlockConstructionStage stage = BlockConstructionStage.readFields(in);
            long newGs = WritableUtils.readVLong((DataInput)in);
            long minBytesRcvd = WritableUtils.readVLong((DataInput)in);
            long maxBytesRcvd = WritableUtils.readVLong((DataInput)in);
            String client = Text.readString((DataInput)in);
            DatanodeInfo src = in.readBoolean() ? DatanodeInfo.read(in) : null;
            int nTargets = in.readInt();
            if (nTargets < 0) {
                throw new IOException("Mislabelled incoming datastream.");
            }
            DatanodeInfo[] targets = new DatanodeInfo[nTargets];
            for (int i = 0; i < targets.length; ++i) {
                targets[i] = DatanodeInfo.read(in);
            }
            BlockAccessToken accesstoken = Receiver.readAccessToken(in);
            this.opWriteBlock(in, blockId, blockGs, pipelineSize, stage, newGs, minBytesRcvd, maxBytesRcvd, client, src, targets, accesstoken);
        }

        protected abstract void opWriteBlock(DataInputStream var1, long var2, long var4, int var6, BlockConstructionStage var7, long var8, long var10, long var12, String var14, DatanodeInfo var15, DatanodeInfo[] var16, BlockAccessToken var17) throws IOException;

        private void opReplaceBlock(DataInputStream in) throws IOException {
            long blockId = in.readLong();
            long blockGs = in.readLong();
            String sourceId = Text.readString((DataInput)in);
            DatanodeInfo src = DatanodeInfo.read(in);
            BlockAccessToken accesstoken = Receiver.readAccessToken(in);
            this.opReplaceBlock(in, blockId, blockGs, sourceId, src, accesstoken);
        }

        protected abstract void opReplaceBlock(DataInputStream var1, long var2, long var4, String var6, DatanodeInfo var7, BlockAccessToken var8) throws IOException;

        private void opCopyBlock(DataInputStream in) throws IOException {
            long blockId = in.readLong();
            long blockGs = in.readLong();
            BlockAccessToken accesstoken = Receiver.readAccessToken(in);
            this.opCopyBlock(in, blockId, blockGs, accesstoken);
        }

        protected abstract void opCopyBlock(DataInputStream var1, long var2, long var4, BlockAccessToken var6) throws IOException;

        private void opBlockChecksum(DataInputStream in) throws IOException {
            long blockId = in.readLong();
            long blockGs = in.readLong();
            BlockAccessToken accesstoken = Receiver.readAccessToken(in);
            this.opBlockChecksum(in, blockId, blockGs, accesstoken);
        }

        protected abstract void opBlockChecksum(DataInputStream var1, long var2, long var4, BlockAccessToken var6) throws IOException;

        private static BlockAccessToken readAccessToken(DataInputStream in) throws IOException {
            BlockAccessToken t = new BlockAccessToken();
            t.readFields(in);
            return t;
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class Sender {
        public static final String __PARANAMER_DATA = "op java.io.DataOutputStream,org.apache.hadoop.hdfs.protocol.DataTransferProtocol.Op out,op \nopBlockChecksum java.io.DataOutputStream,long,long,org.apache.hadoop.hdfs.security.BlockAccessToken out,blockId,blockGs,accesstoken \nopCopyBlock java.io.DataOutputStream,long,long,org.apache.hadoop.hdfs.security.BlockAccessToken out,blockId,blockGs,accesstoken \nopReadBlock java.io.DataOutputStream,long,long,long,long,java.lang.String,org.apache.hadoop.hdfs.security.BlockAccessToken out,blockId,blockGs,blockOffset,blockLen,clientName,accessToken \nopReplaceBlock java.io.DataOutputStream,long,long,java.lang.String,org.apache.hadoop.hdfs.protocol.DatanodeInfo,org.apache.hadoop.hdfs.security.BlockAccessToken out,blockId,blockGs,storageId,src,accesstoken \nopWriteBlock java.io.DataOutputStream,long,long,int,org.apache.hadoop.hdfs.protocol.DataTransferProtocol.BlockConstructionStage,long,long,long,java.lang.String,org.apache.hadoop.hdfs.protocol.DatanodeInfo,org.apache.hadoop.hdfs.protocol.DatanodeInfo[],org.apache.hadoop.hdfs.security.BlockAccessToken out,blockId,blockGs,pipelineSize,stage,newGs,minBytesRcvd,maxBytesRcvd,client,src,targets,accesstoken \n";

        public static void op(DataOutputStream out, Op op) throws IOException {
            out.writeShort(19);
            op.write(out);
        }

        public static void opReadBlock(DataOutputStream out, long blockId, long blockGs, long blockOffset, long blockLen, String clientName, BlockAccessToken accessToken) throws IOException {
            Sender.op(out, Op.READ_BLOCK);
            out.writeLong(blockId);
            out.writeLong(blockGs);
            out.writeLong(blockOffset);
            out.writeLong(blockLen);
            Text.writeString((DataOutput)out, (String)clientName);
            accessToken.write(out);
            out.flush();
        }

        public static void opWriteBlock(DataOutputStream out, long blockId, long blockGs, int pipelineSize, BlockConstructionStage stage, long newGs, long minBytesRcvd, long maxBytesRcvd, String client, DatanodeInfo src, DatanodeInfo[] targets, BlockAccessToken accesstoken) throws IOException {
            Sender.op(out, Op.WRITE_BLOCK);
            out.writeLong(blockId);
            out.writeLong(blockGs);
            out.writeInt(pipelineSize);
            stage.write(out);
            WritableUtils.writeVLong((DataOutput)out, (long)newGs);
            WritableUtils.writeVLong((DataOutput)out, (long)minBytesRcvd);
            WritableUtils.writeVLong((DataOutput)out, (long)maxBytesRcvd);
            Text.writeString((DataOutput)out, (String)client);
            out.writeBoolean(src != null);
            if (src != null) {
                src.write(out);
            }
            out.writeInt(targets.length - 1);
            for (int i = 1; i < targets.length; ++i) {
                targets[i].write(out);
            }
            accesstoken.write(out);
        }

        public static void opReplaceBlock(DataOutputStream out, long blockId, long blockGs, String storageId, DatanodeInfo src, BlockAccessToken accesstoken) throws IOException {
            Sender.op(out, Op.REPLACE_BLOCK);
            out.writeLong(blockId);
            out.writeLong(blockGs);
            Text.writeString((DataOutput)out, (String)storageId);
            src.write(out);
            accesstoken.write(out);
            out.flush();
        }

        public static void opCopyBlock(DataOutputStream out, long blockId, long blockGs, BlockAccessToken accesstoken) throws IOException {
            Sender.op(out, Op.COPY_BLOCK);
            out.writeLong(blockId);
            out.writeLong(blockGs);
            accesstoken.write(out);
            out.flush();
        }

        public static void opBlockChecksum(DataOutputStream out, long blockId, long blockGs, BlockAccessToken accesstoken) throws IOException {
            Sender.op(out, Op.BLOCK_CHECKSUM);
            out.writeLong(blockId);
            out.writeLong(blockGs);
            accesstoken.write(out);
            out.flush();
        }
    }

    public static enum BlockConstructionStage {
        PIPELINE_SETUP_APPEND,
        PIPELINE_SETUP_APPEND_RECOVERY,
        DATA_STREAMING,
        PIPELINE_SETUP_STREAMING_RECOVERY,
        PIPELINE_CLOSE,
        PIPELINE_CLOSE_RECOVERY,
        PIPELINE_SETUP_CREATE;

        private static final byte RECOVERY_BIT = 1;
        public static final String __PARANAMER_DATA = "";

        public BlockConstructionStage getRecoveryStage() {
            if (this == PIPELINE_SETUP_CREATE) {
                throw new IllegalArgumentException("Unexpected blockStage " + (Object)((Object)this));
            }
            return BlockConstructionStage.values()[this.ordinal() | 1];
        }

        private static BlockConstructionStage valueOf(byte code) {
            return code < 0 || code >= BlockConstructionStage.values().length ? null : BlockConstructionStage.values()[code];
        }

        private static BlockConstructionStage readFields(DataInput in) throws IOException {
            return BlockConstructionStage.valueOf(in.readByte());
        }

        private void write(DataOutput out) throws IOException {
            out.writeByte(this.ordinal());
        }
    }

    public static enum Status {
        SUCCESS(0),
        ERROR(1),
        ERROR_CHECKSUM(2),
        ERROR_INVALID(3),
        ERROR_EXISTS(4),
        ERROR_ACCESS_TOKEN(5),
        CHECKSUM_OK(6);

        private final int code;
        private static final int FIRST_CODE;
        public static final String __PARANAMER_DATA = "read java.io.DataInput in \nwrite java.io.DataOutput out \nwriteOutputStream java.io.OutputStream out \n";

        private Status(int code) {
            this.code = code;
        }

        private static Status valueOf(int code) {
            int i = code - FIRST_CODE;
            return i < 0 || i >= Status.values().length ? null : Status.values()[i];
        }

        public static Status read(DataInput in) throws IOException {
            return Status.valueOf(in.readShort());
        }

        public void write(DataOutput out) throws IOException {
            out.writeShort(this.code);
        }

        public void writeOutputStream(OutputStream out) throws IOException {
            out.write(new byte[]{(byte)(this.code >>> 8), (byte)this.code});
        }

        static /* synthetic */ int access$000(Status x0) {
            return x0.code;
        }

        static {
            FIRST_CODE = Status.values()[0].code;
        }
    }

    public static enum Op {
        WRITE_BLOCK(80),
        READ_BLOCK(81),
        READ_METADATA(82),
        REPLACE_BLOCK(83),
        COPY_BLOCK(84),
        BLOCK_CHECKSUM(85);

        public final byte code;
        private static final int FIRST_CODE;
        public static final String __PARANAMER_DATA = "read java.io.DataInput in \nwrite java.io.DataOutput out \n";

        private Op(byte code) {
            this.code = code;
        }

        private static Op valueOf(byte code) {
            int i = (code & 0xFF) - FIRST_CODE;
            return i < 0 || i >= Op.values().length ? null : Op.values()[i];
        }

        public static Op read(DataInput in) throws IOException {
            return Op.valueOf(in.readByte());
        }

        public void write(DataOutput out) throws IOException {
            out.write(this.code);
        }

        static {
            FIRST_CODE = Op.values()[0].code;
        }
    }
}

