/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class FileDataServlet
extends DfsServlet {
    private static final long serialVersionUID = 1L;

    protected URI createUri(String parent, HdfsFileStatus i, UserGroupInformation ugi, ClientProtocol nnproxy, HttpServletRequest request) throws IOException, URISyntaxException {
        String scheme = request.getScheme();
        DatanodeID host = this.pickSrcDatanode(parent, i, nnproxy);
        String hostname = host instanceof DatanodeInfo ? ((DatanodeInfo)host).getHostName() : host.getHost();
        return new URI(scheme, null, hostname, "https".equals(scheme) ? ((Integer)this.getServletContext().getAttribute("datanode.https.port")).intValue() : host.getInfoPort(), "/streamFile", "filename=" + i.getFullName(parent) + "&ugi=" + ugi.getShortUserName(), null);
    }

    private DatanodeID pickSrcDatanode(String parent, HdfsFileStatus i, ClientProtocol nnproxy) throws IOException {
        LocatedBlocks blks = nnproxy.getBlockLocations(i.getFullPath(new Path(parent)).toUri().getPath(), 0L, 1L);
        if (i.getLen() == 0L || blks.getLocatedBlocks().size() <= 0) {
            NameNode nn = (NameNode)this.getServletContext().getAttribute("name.node");
            return nn.getNamesystem().getRandomDatanode();
        }
        return JspHelper.bestNode(blks.get(0));
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("name.conf");
        UserGroupInformation ugi = this.getUGI(request, conf);
        try {
            ClientProtocol nnproxy = (ClientProtocol)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ClientProtocol>(){

                @Override
                public ClientProtocol run() throws IOException {
                    return FileDataServlet.this.createNameNodeProxy();
                }
            });
            String path = request.getPathInfo() != null ? request.getPathInfo() : "/";
            HdfsFileStatus info = nnproxy.getFileInfo(path);
            if (info != null && !info.isDir()) {
                response.sendRedirect(this.createUri(path, info, ugi, nnproxy, request).toURL().toString());
            } else if (info == null) {
                response.sendError(400, "cat: File not found " + path);
            } else {
                response.sendError(400, "cat: " + path + ": is a directory");
            }
        }
        catch (URISyntaxException e) {
            response.getWriter().println(e.toString());
        }
        catch (IOException e) {
            response.sendError(400, e.getMessage());
        }
        catch (InterruptedException e) {
            response.sendError(400, e.getMessage());
        }
    }
}

