/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.INode;

@InterfaceAudience.Private
public class INodeSymlink
extends INode {
    private byte[] symlink;

    INodeSymlink(String value, long modTime, long atime, PermissionStatus permissions) {
        super(permissions, modTime, atime);
        assert (value != null);
        this.setLinkValue(value);
        this.setModificationTimeForce(modTime);
        this.setAccessTime(atime);
    }

    @Override
    public boolean isLink() {
        return true;
    }

    void setLinkValue(String value) {
        this.symlink = DFSUtil.string2Bytes(value);
    }

    public String getLinkValue() {
        return DFSUtil.bytes2String(this.symlink);
    }

    public byte[] getSymlink() {
        return this.symlink;
    }

    @Override
    INode.DirCounts spaceConsumedInTree(INode.DirCounts counts) {
        ++counts.nsCount;
        return counts;
    }

    @Override
    int collectSubtreeBlocksAndClear(List<Block> v) {
        return 1;
    }

    @Override
    long[] computeContentSummary(long[] summary) {
        summary[1] = summary[1] + 1L;
        return summary;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }
}

