/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.security.ExportedAccessKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.BackupNode;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryServlet;
import org.apache.hadoop.hdfs.server.namenode.DelegationTokenServlet;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileChecksumServlets;
import org.apache.hadoop.hdfs.server.namenode.FileDataServlet;
import org.apache.hadoop.hdfs.server.namenode.FsckServlet;
import org.apache.hadoop.hdfs.server.namenode.GetImageServlet;
import org.apache.hadoop.hdfs.server.namenode.ListPathsServlet;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.NodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.RefreshUserToGroupMappingsProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class NameNode
implements NamenodeProtocols,
FSConstants {
    public static final int DEFAULT_PORT = 8020;
    public static final Log LOG;
    public static final Log stateChangeLog;
    protected FSNamesystem namesystem;
    protected HdfsConstants.NamenodeRole role;
    protected Server server;
    protected InetSocketAddress rpcAddress = null;
    protected HttpServer httpServer;
    protected InetSocketAddress httpAddress = null;
    private Thread emptier;
    protected boolean stopRequested = false;
    protected NamenodeRegistration nodeRegistration;
    private boolean serviceAuthEnabled = false;
    private List<ServicePlugin> plugins;
    static NameNodeMetrics myMetrics;

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(ClientProtocol.class.getName())) {
            return 60L;
        }
        if (protocol.equals(DatanodeProtocol.class.getName())) {
            return 24L;
        }
        if (protocol.equals(NamenodeProtocol.class.getName())) {
            return 4L;
        }
        if (protocol.equals(RefreshAuthorizationPolicyProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(RefreshUserToGroupMappingsProtocol.class.getName())) {
            return 1L;
        }
        throw new IOException("Unknown protocol to name node: " + protocol);
    }

    public static void format(Configuration conf) throws IOException {
        NameNode.format(conf, false);
    }

    FSNamesystem getNamesystem() {
        return this.namesystem;
    }

    static void initMetrics(Configuration conf, HdfsConstants.NamenodeRole role) {
        myMetrics = new NameNodeMetrics(conf, role);
    }

    public static NameNodeMetrics getNameNodeMetrics() {
        return myMetrics;
    }

    public static InetSocketAddress getAddress(String address) {
        return NetUtils.createSocketAddr((String)address, (int)8020);
    }

    public static InetSocketAddress getAddress(Configuration conf) {
        URI filesystemURI = FileSystem.getDefaultUri((Configuration)conf);
        String authority = filesystemURI.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException(String.format("Invalid URI for NameNode address (check %s): %s has no authority.", "fs.defaultFS", filesystemURI.toString()));
        }
        if (!"hdfs".equalsIgnoreCase(filesystemURI.getScheme())) {
            throw new IllegalArgumentException(String.format("Invalid URI for NameNode address (check %s): %s is not of scheme '%s'.", "fs.defaultFS", filesystemURI.toString(), "hdfs"));
        }
        return NameNode.getAddress(authority);
    }

    public static URI getUri(InetSocketAddress namenode) {
        int port = namenode.getPort();
        String portString = port == 8020 ? "" : ":" + port;
        return URI.create("hdfs://" + namenode.getHostName() + portString);
    }

    public static String getHostPortString(InetSocketAddress addr) {
        return addr.getHostName() + ":" + addr.getPort();
    }

    public HdfsConstants.NamenodeRole getRole() {
        return this.role;
    }

    boolean isRole(HdfsConstants.NamenodeRole that) {
        return this.role.equals((Object)that);
    }

    protected InetSocketAddress getRpcServerAddress(Configuration conf) throws IOException {
        return NameNode.getAddress(conf);
    }

    protected void setRpcServerAddress(Configuration conf) {
        FileSystem.setDefaultUri((Configuration)conf, (URI)NameNode.getUri(this.rpcAddress));
    }

    protected InetSocketAddress getHttpServerAddress(Configuration conf) {
        return NetUtils.createSocketAddr((String)conf.get("dfs.namenode.http-address", "0.0.0.0:50070"));
    }

    protected void setHttpServerAddress(Configuration conf) {
        conf.set("dfs.namenode.http-address", NameNode.getHostPortString(this.httpAddress));
    }

    protected void loadNamesystem(Configuration conf) throws IOException {
        this.namesystem = new FSNamesystem(conf);
    }

    NamenodeRegistration getRegistration() {
        return this.nodeRegistration;
    }

    NamenodeRegistration setRegistration() {
        this.nodeRegistration = new NamenodeRegistration(NameNode.getHostPortString(this.rpcAddress), NameNode.getHostPortString(this.httpAddress), this.getFSImage(), this.getRole(), this.getFSImage().getCheckpointTime());
        return this.nodeRegistration;
    }

    protected void initialize(Configuration conf) throws IOException {
        InetSocketAddress socAddr = this.getRpcServerAddress(conf);
        int handlerCount = conf.getInt("dfs.namenode.handler.count", 10);
        this.serviceAuthEnabled = conf.getBoolean("hadoop.security.authorization", false);
        if (this.serviceAuthEnabled) {
            ServiceAuthorizationManager.refresh((Configuration)conf, (PolicyProvider)new HDFSPolicyProvider());
        }
        NameNode.initMetrics(conf, this.getRole());
        this.loadNamesystem(conf);
        this.server = RPC.getServer(NamenodeProtocols.class, (Object)this, (String)socAddr.getHostName(), (int)socAddr.getPort(), (int)handlerCount, (boolean)false, (Configuration)conf, (SecretManager)this.namesystem.getDelegationTokenSecretManager());
        this.rpcAddress = this.server.getListenerAddress();
        this.setRpcServerAddress(conf);
        this.activate(conf);
        LOG.info((Object)((Object)((Object)this.getRole()) + " up at: " + this.rpcAddress));
    }

    void activate(Configuration conf) throws IOException {
        if (this.isRole(HdfsConstants.NamenodeRole.ACTIVE) && UserGroupInformation.isSecurityEnabled()) {
            this.namesystem.activateSecretManager();
        }
        this.namesystem.activate(conf);
        this.startHttpServer(conf);
        this.server.start();
        this.startTrashEmptier(conf);
        this.plugins = conf.getInstances("dfs.namenode.plugins", ServicePlugin.class);
        for (ServicePlugin p : this.plugins) {
            try {
                p.start((Object)this);
            }
            catch (Throwable t) {
                LOG.warn((Object)("ServicePlugin " + p + " could not be started"), t);
            }
        }
    }

    private void startTrashEmptier(Configuration conf) throws IOException {
        long trashInterval = conf.getLong("fs.trash.interval", 0L);
        if (trashInterval == 0L) {
            return;
        }
        this.emptier = new Thread(new Trash(conf).getEmptier(), "Trash Emptier");
        this.emptier.setDaemon(true);
        this.emptier.start();
    }

    private void startHttpServer(Configuration conf) throws IOException {
        int infoPort;
        InetSocketAddress infoSocAddr = this.getHttpServerAddress(conf);
        String infoHost = infoSocAddr.getHostName();
        this.httpServer = new HttpServer("hdfs", infoHost, infoPort, (infoPort = infoSocAddr.getPort()) == 0, conf);
        if (conf.getBoolean("dfs.https.enable", false)) {
            boolean needClientAuth = conf.getBoolean("dfs.client.https.need-auth", false);
            InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr((String)conf.get("dfs.namenode.https-address", infoHost + ":" + 0));
            HdfsConfiguration sslConf = new HdfsConfiguration(false);
            sslConf.addResource(conf.get("dfs.https.server.keystore.resource", "ssl-server.xml"));
            this.httpServer.addSslListener(secInfoSocAddr, (Configuration)sslConf, needClientAuth);
            InetSocketAddress datanodeSslPort = NetUtils.createSocketAddr((String)conf.get("dfs.datanode.https.address", infoHost + ":" + 50475));
            this.httpServer.setAttribute("datanode.https.port", (Object)datanodeSslPort.getPort());
        }
        this.httpServer.setAttribute("name.node", (Object)this);
        this.httpServer.setAttribute("name.node.address", (Object)this.getNameNodeAddress());
        this.httpServer.setAttribute("name.system.image", (Object)this.getFSImage());
        this.httpServer.setAttribute("name.conf", (Object)conf);
        this.httpServer.addInternalServlet("getDelegationToken", "/getDelegationToken", DelegationTokenServlet.class);
        this.httpServer.addInternalServlet("fsck", "/fsck", FsckServlet.class);
        this.httpServer.addInternalServlet("getimage", "/getimage", GetImageServlet.class);
        this.httpServer.addInternalServlet("listPaths", "/listPaths/*", ListPathsServlet.class);
        this.httpServer.addInternalServlet("data", "/data/*", FileDataServlet.class);
        this.httpServer.addInternalServlet("checksum", "/fileChecksum/*", FileChecksumServlets.RedirectServlet.class);
        this.httpServer.addInternalServlet("contentSummary", "/contentSummary/*", ContentSummaryServlet.class);
        this.httpServer.start();
        infoPort = this.httpServer.getPort();
        this.httpAddress = new InetSocketAddress(infoHost, infoPort);
        this.setHttpServerAddress(conf);
        LOG.info((Object)((Object)((Object)this.getRole()) + " Web-server up at: " + this.httpAddress));
    }

    public NameNode(Configuration conf) throws IOException {
        this(conf, HdfsConstants.NamenodeRole.ACTIVE);
    }

    protected NameNode(Configuration conf, HdfsConstants.NamenodeRole role) throws IOException {
        UserGroupInformation.setConfiguration((Configuration)conf);
        DFSUtil.login(conf, "dfs.namenode.keytab.file", "dfs.namenode.user.name.key");
        this.role = role;
        try {
            this.initialize(conf);
        }
        catch (IOException e) {
            this.stop();
            throw e;
        }
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        NameNode nameNode = this;
        synchronized (nameNode) {
            if (this.stopRequested) {
                return;
            }
            this.stopRequested = true;
        }
        if (this.plugins != null) {
            for (ServicePlugin p : this.plugins) {
                try {
                    p.stop();
                }
                catch (Throwable t) {
                    LOG.warn((Object)("ServicePlugin " + p + " could not be stopped"), t);
                }
            }
        }
        try {
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
        }
        if (this.namesystem != null) {
            this.namesystem.close();
        }
        if (this.emptier != null) {
            this.emptier.interrupt();
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (myMetrics != null) {
            myMetrics.shutdown();
        }
        if (this.namesystem != null) {
            this.namesystem.shutdown();
        }
    }

    synchronized boolean isStopRequested() {
        return this.stopRequested;
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        if (size <= 0L) {
            throw new IllegalArgumentException("Unexpected not positive size: " + size);
        }
        return this.namesystem.getBlocks(datanode, size);
    }

    @Override
    public ExportedAccessKeys getAccessKeys() throws IOException {
        return this.namesystem.getAccessKeys();
    }

    @Override
    public void errorReport(NamenodeRegistration registration, int errorCode, String msg) throws IOException {
        this.verifyRequest(registration);
        LOG.info((Object)("Error report from " + registration + ": " + msg));
        if (errorCode == 1) {
            this.namesystem.releaseBackupNode(registration);
        }
    }

    @Override
    public NamenodeRegistration register(NamenodeRegistration registration) throws IOException {
        this.verifyVersion(registration.getVersion());
        this.namesystem.registerBackupNode(registration);
        return this.setRegistration();
    }

    @Override
    public NamenodeCommand startCheckpoint(NamenodeRegistration registration) throws IOException {
        this.verifyRequest(registration);
        if (!this.isRole(HdfsConstants.NamenodeRole.ACTIVE)) {
            throw new IOException("Only an ACTIVE node can invoke startCheckpoint.");
        }
        return this.namesystem.startCheckpoint(registration, this.setRegistration());
    }

    @Override
    public void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.verifyRequest(registration);
        if (!this.isRole(HdfsConstants.NamenodeRole.ACTIVE)) {
            throw new IOException("Only an ACTIVE node can invoke endCheckpoint.");
        }
        this.namesystem.endCheckpoint(registration, sig);
    }

    @Override
    public long journalSize(NamenodeRegistration registration) throws IOException {
        this.verifyRequest(registration);
        return this.namesystem.getEditLogSize();
    }

    @Override
    public void journal(NamenodeRegistration registration, int jAction, int length, byte[] args) throws IOException {
        throw new UnsupportedActionException("journal");
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.namesystem.getDelegationToken(renewer);
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        return this.namesystem.renewDelegationToken(token);
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.namesystem.cancelDelegationToken(token);
    }

    @Override
    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        NameNode.myMetrics.numGetBlockLocations.inc();
        return this.namesystem.getBlockLocations(NameNode.getClientMachine(), src, offset, length);
    }

    LocatedBlocks getBlockLocationsNoATime(String src, long offset, long length) throws IOException {
        NameNode.myMetrics.numGetBlockLocations.inc();
        return this.namesystem.getBlockLocations(src, offset, length, false);
    }

    private static String getClientMachine() {
        String clientMachine = Server.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = "";
        }
        return clientMachine;
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.namesystem.getServerDefaults();
    }

    @Override
    public void create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws IOException {
        String clientMachine = NameNode.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.create: file " + src + " for " + clientName + " at " + clientMachine));
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("create: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.startFile(src, new PermissionStatus(UserGroupInformation.getCurrentUser().getShortUserName(), null, masked), clientName, clientMachine, flag.get(), createParent, replication, blockSize);
        NameNode.myMetrics.numFilesCreated.inc();
        NameNode.myMetrics.numCreateFileOps.inc();
    }

    @Override
    public LocatedBlock append(String src, String clientName) throws IOException {
        String clientMachine = NameNode.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.append: file " + src + " for " + clientName + " at " + clientMachine));
        }
        LocatedBlock info = this.namesystem.appendFile(src, clientName, clientMachine);
        NameNode.myMetrics.numFilesAppended.inc();
        return info;
    }

    @Override
    public boolean setReplication(String src, short replication) throws IOException {
        return this.namesystem.setReplication(src, replication);
    }

    @Override
    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.namesystem.setPermission(src, permissions);
    }

    @Override
    public void setOwner(String src, String username, String groupname) throws IOException {
        this.namesystem.setOwner(src, username, groupname);
    }

    @Override
    public LocatedBlock addBlock(String src, String clientName, Block previous, DatanodeInfo[] excludedNodes) throws IOException {
        LocatedBlock locatedBlock;
        stateChangeLog.debug((Object)("*BLOCK* NameNode.addBlock: file " + src + " for " + clientName));
        HashMap<Node, Node> excludedNodesSet = null;
        if (excludedNodes != null) {
            excludedNodesSet = new HashMap<Node, Node>(excludedNodes.length);
            for (DatanodeInfo node : excludedNodes) {
                excludedNodesSet.put(node, node);
            }
        }
        if ((locatedBlock = this.namesystem.getAdditionalBlock(src, clientName, previous, excludedNodesSet)) != null) {
            NameNode.myMetrics.numAddBlockOps.inc();
        }
        return locatedBlock;
    }

    @Override
    public void abandonBlock(Block b, String src, String holder) throws IOException {
        stateChangeLog.debug((Object)("*BLOCK* NameNode.abandonBlock: " + b + " of file " + src));
        if (!this.namesystem.abandonBlock(b, src, holder)) {
            throw new IOException("Cannot abandon block during write to " + src);
        }
    }

    @Override
    public boolean complete(String src, String clientName, Block last) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.complete: " + src + " for " + clientName));
        FSNamesystem.CompleteFileStatus returnCode = this.namesystem.completeFile(src, clientName, last);
        if (returnCode == FSNamesystem.CompleteFileStatus.STILL_WAITING) {
            return false;
        }
        if (returnCode == FSNamesystem.CompleteFileStatus.COMPLETE_SUCCESS) {
            return true;
        }
        throw new IOException("Could not complete write to file " + src + " by " + clientName);
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        stateChangeLog.info((Object)"*DIR* NameNode.reportBadBlocks");
        for (int i = 0; i < blocks.length; ++i) {
            Block blk = blocks[i].getBlock();
            DatanodeInfo[] nodes = blocks[i].getLocations();
            for (int j = 0; j < nodes.length; ++j) {
                DatanodeInfo dn = nodes[j];
                this.namesystem.markBlockAsCorrupt(blk, dn);
            }
        }
    }

    @Override
    public LocatedBlock updateBlockForPipeline(Block block, String clientName) throws IOException {
        return this.namesystem.updateBlockForPipeline(block, clientName);
    }

    @Override
    public void updatePipeline(String clientName, Block oldBlock, Block newBlock, DatanodeID[] newNodes) throws IOException {
        this.namesystem.updatePipeline(clientName, oldBlock, newBlock, newNodes);
    }

    @Override
    public void commitBlockSynchronization(Block block, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets) throws IOException {
        this.namesystem.commitBlockSynchronization(block, newgenerationstamp, newlength, closeFile, deleteblock, newtargets);
    }

    @Override
    public long getPreferredBlockSize(String filename) throws IOException {
        return this.namesystem.getPreferredBlockSize(filename);
    }

    @Override
    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.rename: " + src + " to " + dst));
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        boolean ret = this.namesystem.renameTo(src, dst);
        if (ret) {
            NameNode.myMetrics.numFilesRenamed.inc();
        }
        return ret;
    }

    @Override
    public void concat(String trg, String[] src) throws IOException {
        this.namesystem.concat(trg, src);
    }

    @Override
    public void rename(String src, String dst, Options.Rename ... options) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.rename: " + src + " to " + dst));
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.renameTo(src, dst, options);
        NameNode.myMetrics.numFilesRenamed.inc();
    }

    @Override
    @Deprecated
    public boolean delete(String src) throws IOException {
        return this.delete(src, true);
    }

    @Override
    public boolean delete(String src, boolean recursive) throws IOException {
        boolean ret;
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* Namenode.delete: src=" + src + ", recursive=" + recursive));
        }
        if (ret = this.namesystem.delete(src, recursive)) {
            NameNode.myMetrics.numDeleteFileOps.inc();
        }
        return ret;
    }

    private boolean checkPathLength(String src) {
        Path srcPath = new Path(src);
        return src.length() <= 8000 && srcPath.depth() <= 1000;
    }

    @Override
    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.mkdirs: " + src));
        if (!this.checkPathLength(src)) {
            throw new IOException("mkdirs: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        return this.namesystem.mkdirs(src, new PermissionStatus(UserGroupInformation.getCurrentUser().getShortUserName(), null, masked), createParent);
    }

    @Override
    public void renewLease(String clientName) throws IOException {
        this.namesystem.renewLease(clientName);
    }

    @Override
    public DirectoryListing getListing(String src, byte[] startAfter) throws IOException {
        DirectoryListing files = this.namesystem.getListing(src, startAfter);
        if (files != null) {
            NameNode.myMetrics.numGetListingOps.inc();
            NameNode.myMetrics.numFilesInGetListingOps.inc(files.getPartialListing().length);
        }
        return files;
    }

    @Override
    public HdfsFileStatus getFileInfo(String src) throws IOException {
        NameNode.myMetrics.numFileInfoOps.inc();
        return this.namesystem.getFileInfo(src, true);
    }

    @Override
    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        NameNode.myMetrics.numFileInfoOps.inc();
        return this.namesystem.getFileInfo(src, false);
    }

    @Override
    public long[] getStats() {
        return this.namesystem.getStats();
    }

    @Override
    public DatanodeInfo[] getDatanodeReport(FSConstants.DatanodeReportType type) throws IOException {
        DatanodeInfo[] results = this.namesystem.datanodeReport(type);
        if (results == null) {
            throw new IOException("Cannot find datanode report");
        }
        return results;
    }

    @Override
    public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        return this.namesystem.setSafeMode(action);
    }

    public boolean isInSafeMode() {
        return this.namesystem.isInSafeMode();
    }

    @Override
    public boolean restoreFailedStorage(String arg) throws AccessControlException {
        return this.namesystem.restoreFailedStorage(arg);
    }

    @Override
    public void saveNamespace() throws IOException {
        this.namesystem.saveNamespace();
    }

    @Override
    public void refreshNodes() throws IOException {
        this.namesystem.refreshNodes(new HdfsConfiguration());
    }

    @Override
    @Deprecated
    public long getEditLogSize() throws IOException {
        return this.namesystem.getEditLogSize();
    }

    @Override
    @Deprecated
    public CheckpointSignature rollEditLog() throws IOException {
        return this.namesystem.rollEditLog();
    }

    @Override
    @Deprecated
    public void rollFsImage() throws IOException {
        this.namesystem.rollFSImage();
    }

    @Override
    public void finalizeUpgrade() throws IOException {
        this.namesystem.finalizeUpgrade();
    }

    @Override
    public UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        return this.namesystem.distributedUpgradeProgress(action);
    }

    @Override
    public void metaSave(String filename) throws IOException {
        this.namesystem.metaSave(filename);
    }

    @Override
    public FileStatus[] getCorruptFiles() throws AccessControlException, IOException {
        return this.namesystem.getCorruptFiles();
    }

    @Override
    public ContentSummary getContentSummary(String path) throws IOException {
        return this.namesystem.getContentSummary(path);
    }

    @Override
    public void setQuota(String path, long namespaceQuota, long diskspaceQuota) throws IOException {
        this.namesystem.setQuota(path, namespaceQuota, diskspaceQuota);
    }

    @Override
    public void fsync(String src, String clientName) throws IOException {
        this.namesystem.fsync(src, clientName);
    }

    @Override
    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.namesystem.setTimes(src, mtime, atime);
    }

    @Override
    public void createSymlink(String target, String link, FsPermission dirPerms, boolean createParent) throws IOException {
        NameNode.myMetrics.numcreateSymlinkOps.inc();
        if (!this.checkPathLength(link)) {
            throw new IOException("Symlink path exceeds 8000 character limit");
        }
        if ("".equals(target)) {
            throw new IOException("Invalid symlink target");
        }
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.namesystem.createSymlink(target, link, new PermissionStatus(ugi.getUserName(), null, dirPerms), createParent);
    }

    @Override
    public String getLinkTarget(String path) throws IOException {
        NameNode.myMetrics.numgetLinkTargetOps.inc();
        try {
            HdfsFileStatus stat = this.namesystem.getFileInfo(path, false);
            if (stat != null) {
                return stat.getSymlink();
            }
        }
        catch (UnresolvedPathException e) {
            return e.getResolvedPath().toString();
        }
        catch (UnresolvedLinkException e) {
            throw new AssertionError((Object)"UnresolvedLinkException thrown");
        }
        return null;
    }

    @Override
    public DatanodeRegistration registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.verifyVersion(nodeReg.getVersion());
        this.namesystem.registerDatanode(nodeReg);
        return nodeReg;
    }

    @Override
    public DatanodeCommand[] sendHeartbeat(DatanodeRegistration nodeReg, long capacity, long dfsUsed, long remaining, int xmitsInProgress, int xceiverCount) throws IOException {
        this.verifyRequest(nodeReg);
        return this.namesystem.handleHeartbeat(nodeReg, capacity, dfsUsed, remaining, xceiverCount, xmitsInProgress);
    }

    @Override
    public DatanodeCommand blockReport(DatanodeRegistration nodeReg, long[] blocks) throws IOException {
        this.verifyRequest(nodeReg);
        BlockListAsLongs blist = new BlockListAsLongs(blocks);
        stateChangeLog.debug((Object)("*BLOCK* NameNode.blockReport: from " + nodeReg.getName() + " " + blist.getNumberOfBlocks() + " blocks"));
        this.namesystem.processReport(nodeReg, blist);
        if (this.getFSImage().isUpgradeFinalized()) {
            return DatanodeCommand.FINALIZE;
        }
        return null;
    }

    @Override
    public void blockReceived(DatanodeRegistration nodeReg, Block[] blocks, String[] delHints) throws IOException {
        this.verifyRequest(nodeReg);
        stateChangeLog.debug((Object)("*BLOCK* NameNode.blockReceived: from " + nodeReg.getName() + " " + blocks.length + " blocks."));
        for (int i = 0; i < blocks.length; ++i) {
            this.namesystem.blockReceived(nodeReg, blocks[i], delHints[i]);
        }
    }

    @Override
    public void errorReport(DatanodeRegistration nodeReg, int errorCode, String msg) throws IOException {
        String dnName = nodeReg == null ? "unknown DataNode" : nodeReg.getName();
        LOG.info((Object)("Error report from " + dnName + ": " + msg));
        if (errorCode == 0) {
            return;
        }
        this.verifyRequest(nodeReg);
        if (errorCode == 1) {
            LOG.warn((Object)("Volume failed on " + dnName));
        } else if (errorCode == 3) {
            this.namesystem.removeDatanode(nodeReg);
        }
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        return this.namesystem.getNamespaceInfo();
    }

    @Override
    public UpgradeCommand processUpgradeCommand(UpgradeCommand comm) throws IOException {
        return this.namesystem.processDistributedUpgradeCommand(comm);
    }

    public void verifyRequest(NodeRegistration nodeReg) throws IOException {
        this.verifyVersion(nodeReg.getVersion());
        if (!this.namesystem.getRegistrationID().equals(nodeReg.getRegistrationID())) {
            throw new UnregisteredNodeException(nodeReg);
        }
    }

    public void verifyVersion(int version) throws IOException {
        if (version != -24) {
            throw new IncorrectVersionException(version, "data node");
        }
    }

    public File getFsImageName() throws IOException {
        return this.getFSImage().getFsImageName();
    }

    public FSImage getFSImage() {
        return this.namesystem.dir.fsImage;
    }

    public File[] getFsImageNameCheckpoint() throws IOException {
        return this.getFSImage().getFsImageNameCheckpoint();
    }

    public InetSocketAddress getNameNodeAddress() {
        return this.rpcAddress;
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    NetworkTopology getNetworkTopology() {
        return this.namesystem.clusterMap;
    }

    private static boolean format(Configuration conf, boolean isConfirmationNeeded) throws IOException {
        Collection<URI> dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        Collection<URI> editDirsToFormat = FSNamesystem.getNamespaceEditsDirs(conf);
        Iterator<URI> it = dirsToFormat.iterator();
        while (it.hasNext()) {
            File curDir = new File(it.next().getPath());
            if (!curDir.exists() || !isConfirmationNeeded) continue;
            System.err.print("Re-format filesystem in " + curDir + " ? (Y or N) ");
            if (System.in.read() != 89) {
                System.err.println("Format aborted in " + curDir);
                return true;
            }
            while (System.in.read() != 10) {
            }
        }
        FSNamesystem nsys = new FSNamesystem(new FSImage(dirsToFormat, editDirsToFormat), conf);
        nsys.dir.fsImage.format();
        return false;
    }

    private static boolean finalize(Configuration conf, boolean isConfirmationNeeded) throws IOException {
        Collection<URI> dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        Collection<URI> editDirsToFormat = FSNamesystem.getNamespaceEditsDirs(conf);
        FSNamesystem nsys = new FSNamesystem(new FSImage(dirsToFormat, editDirsToFormat), conf);
        System.err.print("\"finalize\" will remove the previous state of the files system.\nRecent upgrade will become permanent.\nRollback option will not be available anymore.\n");
        if (isConfirmationNeeded) {
            System.err.print("Finalize filesystem state ? (Y or N) ");
            if (System.in.read() != 89) {
                System.err.println("Finalize aborted.");
                return true;
            }
            while (System.in.read() != 10) {
            }
        }
        nsys.dir.fsImage.finalizeUpgrade();
        return false;
    }

    public void refreshServiceAcl() throws IOException {
        if (!this.serviceAuthEnabled) {
            throw new AuthorizationException("Service Level Authorization not enabled!");
        }
        ServiceAuthorizationManager.refresh((Configuration)new Configuration(), (PolicyProvider)new HDFSPolicyProvider());
    }

    public void refreshUserToGroupsMappings(Configuration conf) throws IOException {
        LOG.info((Object)("Refreshing all user-to-groups mappings. Requested by user: " + UserGroupInformation.getCurrentUser().getShortUserName()));
        Groups.getUserToGroupsMappingService((Configuration)conf).refresh();
    }

    private static void printUsage() {
        System.err.println("Usage: java NameNode [" + HdfsConstants.StartupOption.BACKUP.getName() + "] | [" + HdfsConstants.StartupOption.CHECKPOINT.getName() + "] | [" + HdfsConstants.StartupOption.FORMAT.getName() + "] | [" + HdfsConstants.StartupOption.UPGRADE.getName() + "] | [" + HdfsConstants.StartupOption.ROLLBACK.getName() + "] | [" + HdfsConstants.StartupOption.FINALIZE.getName() + "] | [" + HdfsConstants.StartupOption.IMPORT.getName() + "]");
    }

    private static HdfsConstants.StartupOption parseArguments(String[] args) {
        int argsLen = args == null ? 0 : args.length;
        HdfsConstants.StartupOption startOpt = HdfsConstants.StartupOption.REGULAR;
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if (HdfsConstants.StartupOption.FORMAT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.FORMAT;
                continue;
            }
            if (HdfsConstants.StartupOption.REGULAR.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.REGULAR;
                continue;
            }
            if (HdfsConstants.StartupOption.BACKUP.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.BACKUP;
                continue;
            }
            if (HdfsConstants.StartupOption.CHECKPOINT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.CHECKPOINT;
                continue;
            }
            if (HdfsConstants.StartupOption.UPGRADE.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.UPGRADE;
                continue;
            }
            if (HdfsConstants.StartupOption.ROLLBACK.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.ROLLBACK;
                continue;
            }
            if (HdfsConstants.StartupOption.FINALIZE.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.FINALIZE;
                continue;
            }
            if (HdfsConstants.StartupOption.IMPORT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.IMPORT;
                continue;
            }
            return null;
        }
        return startOpt;
    }

    private static void setStartupOption(Configuration conf, HdfsConstants.StartupOption opt) {
        conf.set("dfs.namenode.startup", opt.toString());
    }

    static HdfsConstants.StartupOption getStartupOption(Configuration conf) {
        return HdfsConstants.StartupOption.valueOf(conf.get("dfs.namenode.startup", HdfsConstants.StartupOption.REGULAR.toString()));
    }

    public static NameNode createNameNode(String[] argv, Configuration conf) throws IOException {
        HdfsConstants.StartupOption startOpt;
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        if ((startOpt = NameNode.parseArguments(argv)) == null) {
            NameNode.printUsage();
            return null;
        }
        NameNode.setStartupOption(conf, startOpt);
        switch (startOpt) {
            case FORMAT: {
                boolean aborted = NameNode.format(conf, true);
                System.exit(aborted ? 1 : 0);
                return null;
            }
            case FINALIZE: {
                boolean aborted = NameNode.finalize(conf, true);
                System.exit(aborted ? 1 : 0);
                return null;
            }
            case BACKUP: 
            case CHECKPOINT: {
                return new BackupNode(conf, startOpt.toNodeRole());
            }
        }
        return new NameNode(conf);
    }

    public static void main(String[] argv) throws Exception {
        try {
            StringUtils.startupShutdownMessage(NameNode.class, (String[])argv, (Log)LOG);
            NameNode namenode = NameNode.createNameNode(argv, null);
            if (namenode != null) {
                namenode.join();
            }
        }
        catch (Throwable e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            System.exit(-1);
        }
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        LOG = LogFactory.getLog((String)NameNode.class.getName());
        stateChangeLog = LogFactory.getLog((String)"org.apache.hadoop.hdfs.StateChange");
    }
}

