class Pick::MailtoController < Pick::LumpController
  include Picker::Controller

  skip_before_filter :check_rfw_params
  skip_before_filter :filter_rfw_params
  before_filter :check_rfw_params, :except => [:test]
  before_filter :filter_rfw_params, :only => [:search]
  before_filter :restore_params, :only => [:search]

  def search
  end

  private

  def check_rfw_params
    if params[:rfw].nil? ||
        params[:rfw][:mailto_ids].blank? ||
        params[:rfw][:mailto_names].blank? ||
        params[:rfw][:mailto_type].blank? ||
        params[:rfw][:mail_comment].blank? ||
        params[:rfw][:mail_attachment].blank?
      raise ClientError, 'rfw parameters are missing'
    end
  end

  def filter_rfw_params
    params[:rfw] = {
      :mailto_ids => params[:rfw][:mailto_ids],
      :mailto_names => params[:rfw][:mailto_names],
      :mailto_type => params[:rfw][:mailto_type],
      :mail_comment => params[:rfw][:mail_comment],
      :mail_attachment => params[:rfw][:mail_attachment],
    }
  end

  def restore_params
    params[:rfw].each{|key, value|
      if /(.+?)\[(.+?)\]/ =~ value
        instance_variable_set("@#{key}", params[$1][$2])
      else
        instance_variable_set("@#{key}", params[value])
      end
    }
    @mailto_people = picker_model_class("Person").joints(@mailto_ids).select(&:can_be_recipient?)
    @mailto_type = 'to' if @mailto_type.blank?
    @mail_attachment = '0' if @mail_attachment.blank?
    true
  end

end
