module Pick::OrganizationHelper
  include Picker::Helper

  def has_children?(company_id)
    picker_model_class("organization", "Organization").exists?(:company_id => company_id) && Organization.find(:all, :select => 'id, name', :conditions=>{:company_id => company_id}, :order => 'name') != []
  end

  def expanded?
    !@organization_name.blank?
  end

  def link_to_pick_result(organization)
    if params[:rfw][:company_id]
      rfw_link_to_pick(h(organization.name),
                       {
                         :organization_id   => organization.id,
                         :organization_name => organization.name,
                         :company_id        => organization.company.id,
                         :company_name      => organization.company.name,
                       })
    else
      rfw_link_to_pick(h(organization.name),
                       {
                         :organization_id   => organization.id,
                         :organization_name => organization.name,
                       })
    end
  end

end
