module PjcTaskPickerHelper
    def task_picker_button_box
        @task_picker_button_box ||= lcr_button_box({
            :left => link_to_close({"_" => "&suffix;"}, @task_return_to_url, :class => "button"),
            :center => task_decision_button,
          }, "w_lcr_button_box_70")
        return @task_picker_button_box
    end
    
    # 決定ボタン
    def task_decision_button
        decision_button = ""
        decision_button += @task_picker_submit_tag
    end
    
    # タスク選択のタスク名リンク
    def picker_list_task_leaf(it)
       task_name =[it.name]
       name = it.parent_task_name(it,task_name).reverse.join("/").to_s
       if params[:return_field]
         return_field =params[:return_field]
         session[:picker_task_leaf] =params[:return_field]
       else
         return_field =session[:picker_task_leaf]
       end
       link_name =link_to_view_motion((h name),
                                        @current_view, "task_#{it.id}", 
                                        {},
                                        {:controller => "pjc_task_picker",
                                         :action => "task_select",
                                         :task_return_field =>it.name,
                                         :task_return_id =>it.id,
                                         :return_field =>return_field,
                                         :pick =>true}, 
                                         :class => "pick")
       return link_name
    end
    
    # 定型タスク選択と個人タスク選択 のタスクリンク
    def picker_list_regular_task_leaf(it)
       if params[:return_field]
         return_field =params[:return_field]
         session[:picker_regular_task_leaf] =params[:return_field]
       else
         return_field =session[:picker_regular_task_leaf]
       end
       name = it.name
       link_name =link_to_view_motion((h name),
                                        @current_view, "task_#{it.id}", 
                                        {},
                                        {:controller => "pjc_task_picker",
                                         :action => "regular_task_select",
                                         :task_return_field =>it.name,
                                         :task_return_id =>it.id,
                                         :return_field => return_field,
                                         :pick =>true}, 
                                         :class => "pick")
       return link_name
    end
    
    # pickerの閉じる処理
    def task_select_picker_button_box
        @task_picker_button_box ||= lcr_button_box({
            :left => link_to_close({"_" => "&suffix;"}, @task_return_to_url, :class => "button")
          }, "w_popup_70")
        return @task_picker_button_box
    end
    
    # プロジェクトコード、プロジェクト名、業務名を返却する
    def project_segment_name_total(it)
       begin
         project=Project.find(it.project_id)
       rescue ActiveRecord::RecordNotFound
         raise "project not found"
       end
       begin
         segment= ProjectSegment.find(it.segment_id)
       rescue ActiveRecord::RecordNotFound
         raise "segment not found"         
       end
       return "#{project.code}  #{project.name} - #{segment.name}"     
    end
    
    # 作業中タスクと未作業タスクボタンの切り替える処理
    def link_to_task_working_change(name)
        work_change =@work_change
        work_change ||="unwork"
        link_to_view_motion((h name),
                                @sub_view, "task_working_change", 
                                {"_" => "_task_working_change"},
                                {:controller => "pjc_task_picker",
                                 :action => "task_select",                           
                                 :task_working_change =>work_change}, 
                                 :class => "button reloadable_link")
    end
    
    # 検索ボタン
    def link_to_task_name_select(name)
      e =""
      e << submit_tag(s_("rfw|Picker|search"), :class =>"button reloadable_link", :name =>name)
      return e                          
    end
end
