# -*- coding: utf-8 -*-
# ポータルのヘルパーを与える。
module PortalHelper
  # ポートレットから各画面に遷移するリンクを返す。
  def jump(portlet)
    menu = portlet.portlettable
    html_options = {
      :class => "link_m reloadable_link button",
    }
    if menu.respond_to?(:with_ajax?) && menu.with_ajax?
      html_options[:onclick] = "return onMenu(#{menu.id})"
      link_to h(s_("rfw|Portal|Jump")), menu.url_options, html_options
    else
      link_to h(s_("rfw|Portal|Jump")), {:controller => "menu", :action => "index"}, html_options
    end
  end

  # ポートレットの設定へのリンクを返す。
  def link_to_portlet_config(portlet)
    rfw_link_to_open(h(s_("rfw|Portal|Config")), {
                       :controller => "portlet",
                       :action => "config",
                       :id => portlet.id,
                     },
                     "c",
                     "sibling",
                     0,
                     { :class=>"button" })
  end

  # ポータルの設定を閉じるリンクを返す。
  def link_to_config_close(x)
    link_to_remote(h(s_("rfw|button|Close")), {
                     :update => "view_m",
                     :url => {:action => "index", :id => @portal.id}
                   }, {:class => "button"})
  end

  # ポータルのレイアウトを設定する部品を返す。
  def layout_box
    onclick = <<-JAVASCRIPT
if (this.checked) {
    new Ajax.Request('#{url_for(:action => "update_pattern")}?pattern=' + this.value, {
    onSuccess: function() {
      document.getElementsByClassName('portal_config_pane').each(function(x) {
        v = x.id.match(/^portal_config_pane_([abc])$/);
        new Ajax.Updater(x, '#{url_for(:action => "pane")}?pane=' + v[1], {
          evalScripts: true
        });
      })
    }
  });
}
    JAVASCRIPT
    Portal::LABEL_PATTERN.map do |label, pattern|
      radio_button_tag_with_label("foo", pattern, label, (pattern == @portal.pattern), {
                                    :onclick => onclick
                                  })
    end.join
  end

  # ポートレットのグループの一覧を返す。
  def group_table(members, portlets, size)
    @groups.map do |group|
      if group.fit?(size)
        x = link_to_remote(h(group.name), {
                             :url => {:action => "portlettable_members", :group_id => group.id},
                             :update => members,
                             :complete => "Sortable.create('#{members}', {onUpdate: function(container){}, dropOnEmpty: true, containment: ['#{members}', '#{portlets}'], constraint: false})",
                           }, {
#                             :id => "portlettable_group_#{group.id}",
                             :class => "portlettable_group"
                           })
        "<li>#{x}</li>"
      end
    end.join
  end

  # グループごとのポートレットの一覧を返す。
  def portlet_table(pane)
    i = Portal::POSITION[pane] - 1
    return unless @current_panes[i]
    @current_panes[i].portlets.map do |portlet|
      content_tag(:li, h(portlet.title), :id => "portlet_#{portlet.id}")
    end.join
  end
end
