# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: grant_ons
#
#  id                     :integer       not null, primary key
#  domain_id              :integer       not null
#  value                  :string(255)   not null
#  inception              :string(8)     not null
#  expiry                 :string(8)     not null
#  position               :integer
#  created_at             :string(14)
#  updated_at             :string(14)
#  created_by             :integer
#  updated_by             :integer
#  created_in             :integer
#  updated_in             :integer
#  lock_version           :integer       default(0), not null
#  grant_targettable_id   :integer
#  grant_targettable_type :string(255)
#  roleable_id            :integer
#  roleable_type          :string(255)
#

# 権限の設定のモデル (管理用)
class GrantOnWithoutPeriodic < ActiveRecord::Base
  set_table_name "grant_ons"

  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :roleable, :polymorphic => true
  belongs_to :grant_targettable, :polymorphic => true
  alias header grant_targettable
  alias header= grant_targettable=
  has_many :permissions, :foreign_key => :grant_on_id
  acts_as_list :scope => 'grant_targettable_id = #{quote_value(grant_targettable_id)} AND grant_targettable_type = #{quote_value(grant_targettable_type)}'

  #validates_presence_of :grant_targettable_id, :grant_targettable_type

  after_create PermissionObserver.new
  after_update PermissionObserver.new
  after_destroy PermissionObserver.new

  def validate
    if errors.empty?
      unless check_type?
        errors.add(:roleable,"GrantOnWithoutPeriodic|notice|PersonGroup can't be selected.")
        return nil
      end
    end
  end

  def check_type?
    model_names = ConfigPicker.find(:all , :conditions=>{:controller_name => "lump" , :source_name => ["Domain","Company","Organization","Person","Group"] }).map(&:model_name)
    if self.roleable
      if model_names.include?("#{self.roleable.class.to_s}") == true
        return true
      else
        return false
      end
    end
    return true
  end
end
