# == Schema Information
# Schema version: 20080822052847
#
# Table name: companies
#
#  id                          :integer(4)      not null, primary key
#  domain_id                   :integer(4)      not null
#  code                        :string(255)
#  name                        :string(255)
#  phonetic                    :string(255)
#  official_company_name       :string(255)
#  company_abbreviation_name   :string(255)
#  customer_connection         :string(255)
#  industry                    :string(255)
#  relationship_to_our_company :string(255)
#  phone_number                :string(255)
#  fax_number                  :string(255)
#  mail_address                :string(255)
#  url                         :string(255)
#  base_postcode               :string(255)
#  base_state                  :string(255)
#  base_city                   :string(255)
#  base_address1               :string(255)
#  base_address2               :string(255)
#  bill_postcode               :string(255)
#  bill_state                  :string(255)
#  bill_city                   :string(255)
#  bill_address1               :string(255)
#  bill_address2               :string(255)
#  representative_name         :string(255)
#  person_in_charge_name       :string(255)
#  e_mail_of_person_in_charge  :string(255)
#  capital_funds               :string(255)
#  establishment_date          :string(255)
#  number_of_employees         :string(255)
#  annual_sale_volume          :string(255)
#  remarks                     :text
#  created_at                  :string(14)
#  updated_at                  :string(14)
#  created_by                  :integer(4)
#  updated_by                  :integer(4)
#  created_in                  :integer(4)
#  updated_in                  :integer(4)
#  lock_version                :integer(4)      default(0), not null
#

# PJC参照用 企業のモデル
class PjcCompany < ActiveRecord::Base
  set_table_name "companies"

  untranslate_all
  timestamps_as_string
  user_monitor

  acts_as_permissible

  has_many :pjc_people, :class_name => "PjcPerson", :foreign_key => "default_company_id"

  belongs_to :domain
  has_many :company_members, :class_name => "PjcCompanyMember", :foreign_key => "company_id"
  has_many :posts, :class_name => "PjcPost", :foreign_key => "company_id",:dependent => :destroy
  has_many :organizations,:class_name => "PjcOrganization", :foreign_key => "company_id", :dependent => :destroy
  has_many :people, :class_name => "PjcPerson", :foreign_key => "company_id", :through => :company_members
  has_many :grant_ons, :as => :roleable, :dependent => :destroy

  validates_presence_of :code, :name
  validates_uniqueness_of :code

  # <em>p</em> と <em>q</em> が同一の企業に所属しているかどうかを判定する。
  def self.exists_with_people?(p, q)
    return !((p.companies & q.companies).empty?)
  end

  def name_with_in
    name
  end
end
