# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: projects
#
#  id                      :integer       not null, primary key
#  domain_id               :integer       not null
#  code                    :string(255)   not null
#  name                    :string(255)   not null
#  retrieval_division_id1  :integer
#  retrieval_division_id2  :integer
#  retrieval_division_id3  :integer
#  retrieval_division_id4  :integer
#  retrieval_division_id5  :integer
#  retrieval_division_id6  :integer
#  retrieval_division_id7  :integer
#  retrieval_division_id8  :integer
#  retrieval_division_id9  :integer
#  retrieval_division_id10 :integer
#  created_at              :string(14)
#  updated_at              :string(14)
#  created_by              :integer
#  updated_by              :integer
#  created_in              :integer
#  updated_in              :integer
#  lock_version            :integer       default(0), not null
#

# プロジェクトのモデル。
class Project < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_permissible

  (1..10).each do |i|
    belongs_to :"retrieval_division_#{i}", :class_name => "RetrievalDivision", :foreign_key => "retrieval_division_id#{i}"
  end
  has_many :segments, :class_name => "ProjectSegment", :foreign_key => "project_id", :dependent => :destroy

  def to_text
    "#{code} #{name}"
  end

end
