# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: project_segments
#
#  id                 :integer       not null, primary key
#  domain_id          :integer       not null
#  project_id         :integer       not null
#  code               :string(255)   not null
#  name               :string(255)   not null
#  segment_end_date   :string(8)
#  plan_of_start_date :string(8)
#  plan_of_end_date   :string(8)
#  created_at         :string(14)
#  updated_at         :string(14)
#  created_by         :integer
#  updated_by         :integer
#  created_in         :integer
#  updated_in         :integer
#  lock_version       :integer       default(0), not null
#

# 業務のモデル。
class ProjectSegment < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_permissible

  belongs_to :project

  # 選択された場合の書式
  def picked_name
    to_text
  end

  def to_text
    "#{project.to_text} - #{name}"
  end

end
