# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: shared_lists
#
#  id            :integer       not null, primary key
#  domain_id     :integer       not null
#  display_id    :integer       not null
#  roleable_id   :integer       not null
#  roleable_type :string(255)   not null
#  created_at    :string(14)
#  updated_at    :string(14)
#  created_by    :integer
#  updated_by    :integer
#  created_in    :integer
#  updated_in    :integer
#  lock_version  :integer       default(0), not null
#

# 共有一覧のエントリを表すモデル。
class SharedList < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :domain
  belongs_to :display
  belongs_to :roleable, :polymorphic => true

  delegate :name, :to => :display

  # 共有一覧の作成者を返す。
  def creator
    display.person
  end

  # 共有一覧から新しい個人一覧を作成する。
  # 成功した場合には個人一覧を返す。
  # さもなくばエラーを挙げる。
  def export(person)
    if include?(person)
      return display.export(person.id)
    end
    raise ArgumentError, "not allowed to export: #{person.inspect}"
  end

  # 共有先に含まれる利用者かどうかを判定する。
  def include?(person)
    return false unless person
    return false unless roleable
    roleable.people.map(&:id).include?(person.id)
  end
end
