#!/usr/bin/env ruby
require File.dirname(__FILE__) + '/../config/boot'
ARGV.push ''
require 'commands/runner'

@admin = User.find_by_login("admin")
User.current = @admin

@tesla = User.find_by_login("tesla")
@grant_on_domain = @tesla.domain
def add_grant_on(item, value="full")
  STDERR.puts "grant on #{item.code} to domain #{@grant_on_domain.id}"
  GrantOn.create!({
      :value => value,
      :inception => "20060504",
      :expiry => "20180912",
      :grant_targettable => item,
      :roleable => @grant_on_domain,
    })
end

def add_product(code, model_name, name_en, name_ja, options={})
  code = "P_DUMMY_#{code}"
  return if Product.find_by_code(code)
  STDERR.puts "create product #{code}"
  Product.transaction do
    given = {:code => code, :model_name => model_name, :name_po => 0}
    given.update(options)
    product = ProductSingle.create!(given)
    product.name_en = name_en
    product.name_ja = name_ja
    product.save!
    case code
    when "P_DUMMY_LOGIN_HISTORY"
      product.displays.each do |display|
        display.items.each do |item|
          case item.code
          when "LOGIN", "PASSWORD", "REMOTE_ADDRESS"
            item.control = "admin"
          else
            item.control = "permission"
          end
          STDERR.puts "#{item.code} set control #{item.control}"
          item.save!
        end
      end
    when "P_DUMMY_PRODUCT_GENERATOR"
      product.motion = "controller=product_generator/action=list"
      product.save!
      add_grant_on(product, "invisible")
    else
      add_grant_on(product)
    end
  end
end

add_product("PRODUCT_GENERATOR", "products", "Product Generator", "画面生成")
add_product("LOGIN_HISTORY", "login_histories", "Login Histories", "ログイン履歴")

def add_model_with_code_and_name(model_class, template)
  return if model_class.find_by_code("Z")
  model_class.transaction do
    ("A".."Z").each do |s|
      name = template % [s]
      STDERR.puts "create #{model_class} #{name}"
      it = model_class.create!({
          :code => s,
          :name => name,
        })
    end
  end
end

add_model_with_code_and_name(Company, "%s社")
add_product("COMPANY", "companies", "Companies", "会社")
add_model_with_code_and_name(Group, "グループ%s")
add_product("GROUP", "groups", "Groups", "グループ")
add_product("ORGANIZATION", "organizations", "Organizations", "組織")

def add_belongs_to_company(model_class, template, options={})
  return if model_class.find_by_name(template % ["Z", "Z"])
  Company.transaction do
    ("A".."Z").each do |c|
      company = Company.find_by_code(c)
      ("A".."Z").each do |o|
        name = template % [c, o]
        STDERR.puts "create #{model_class} #{name}"
        it = model_class.create!(options.merge({
              :company => company,
              :name => name,
              :code => "#{c}#{o}",
          }))
      end
    end
  end
end
add_belongs_to_company(Organization, "%s%s部", :inception => "20070101", :expiry => "20170101")
add_belongs_to_company(Post, "役職%s%s")
add_product("Post", "posts", "Posts", "役職")

def add_people
  last = "CC"
  # last = "ZZ"
  return if Person.find_by_name("#{last}さん")
  Person.transaction do
    ("AA"..last).each do |s|
      attributes = {
        :name => "#{s}さん",
      }
      STDERR.puts "create person #{attributes[:name]}"
      if /(.)\1/ =~ s
        attributes[:mail_address] = "#{s.downcase}@example.jp"
      end
      person = Person.create!(attributes)
      (1..2).each do |i|
        login = "%s%02d" % [s.downcase, i]
        STDERR.puts "create user #{login}"
        password = s * 3
        user = User.new({
            :login => login,
            :password => password,
            :password_confirmation => password,
            :person => person,
          })
        key = nil
        User.transaction do
          user.password_needs_confirmation = true
          user.save!
          key = user.generate_security_token
        end
        user = User.authenticate_by_token(user.id, key)
      end
    end
  end
end
add_people
add_product("PEOPLE", "people", "People", "人々")
add_product("USER", "users", "User", "ユーザ")

add_product("MAIL_FORMAT", "mail_formats", "Mail Format", "メールフォーマット")
add_product("MAIL_QUEUE", "mail_queues", "Mail Queue", "メールキュー")
add_product("MAIL_HISTORY", "mail_histories", "Mail History", "メール履歴")

def add_holidays
  return if Holiday.find_by_year_and_month_and_day(2007,1,1)
  Holiday.transaction do
    d = Date.new(2007,1,1)
    STDERR.puts "create holiday #{d}"
    Holiday.create!(:year => d.year, :month => d.month, :day => d.day)
    sun = d - d.wday
    d20100101 = Date.new(2010,1,1)
    while sun < d20100101
      STDERR.puts "create holiday(Sun) #{sun}"
      Holiday.create!(:year => sun.year, :month => sun.month, :day => sun.day)
      sat = sun - 1
      STDERR.puts "create holiday(Sat) #{sat}"
      Holiday.create!(:year => sat.year, :month => sat.month, :day => sat.day)
      sun += 7
    end
  end
end
add_holidays
add_product("HOLIDAY", "holidays", "Holiday", "休日")
add_product("MATTER", "matters", "Matter", "案件情報", :attachment => true, :csv => true, :document => true, :document_name_method => "anken_code", :document_content_method => "anken_name", :mail => true)

def add_member(model_class, template)
  model_name = model_class.to_s.underscore
  member_class = "#{model_class}Member".constantize
  return if member_class.find(:first, :conditions => [
      "#{model_name}_id = ?",
      model_class.find(:first, :conditions => ["name = ?", (template % "Z")], :select => "id").id
    ])
  member_class.transaction do
    ("A".."Z").each do |s|
      model_class.find(:all, :conditions => ["name = ?", (template % s)]).each do |model|
        Person.find(:all, :conditions => ["name LIKE ?", "#{s}%"]).each do |person|
          STDERR.puts "create #{member_class} #{model.name} #{person.name}"
          member = member_class.create!(model_name=>model,:person=>person,:inception=>"20070101",:expiry=>"20080101")
        end
      end
    end
  end
end

add_member(Company, "%s社")
add_member(Group, "グループ%s")
add_member(Organization, "A%s部")
add_member(Organization, "%1$s%1$s部")

def add_parent_of_dummies
  code = "P_PARENT_OF_DUMMIES"
  return if Product.find_by_code(code)
  Product.transaction do
    STDERR.puts "create product #{code}"
    parent = ProductSingle.create!({
        :code => code,
        :model_name => "Domain",
        :name_po => 0,
      })
    parent.motion = nil
    parent.name_en = "Dummies"
    parent.name_ja = "ダミー"
    parent.save!
    add_grant_on(parent)
    logout = Product.find_by_code("P_LOGOUT")
    STDERR.puts "#{parent.code} move_to_left_of #{logout.code}"
    parent.move_to_left_of logout
    Product.find(:all, :conditions => ["code LIKE ?", "P_DUMMY_%"]).each do |product|
      STDERR.puts "#{product.code} move_to_child_of #{parent.code}"
      product.move_to_child_of parent
      product.save!
    end
  end
end
add_parent_of_dummies

def fixup_names(item)
  changed = false
  Language.all.each do |lang|
    name = item.name_(lang.code)
    if name.blank? || name == item.code
      name = item.name
      name = item.code.humanize if name.blank?
      changed = true
      name_with_lang = "#{name} (#{lang.name[/./]})"
      STDERR.puts "#{item.code}.name_#{lang.code}=#{name_with_lang}"
      item.__send__("name_#{lang.code}=", name_with_lang)
    end
  end
  item.save! if changed
end

Product.transaction do
  Product.find(:all, :order => "id DESC").each do |product|
    STDERR.puts "product #{product.id} #{product.code}"
    fixup_names(product)
  end
end

Display.transaction do
  Display.find(:all, :order => "id DESC").each do |display|
    STDERR.puts "display #{display.id} #{display.code}"
    fixup_names(display)
  end
end
