class CreateUsers < ActiveRecord::Migration
  def self.up
    hash_length = 128
    create_table :users do |t|
      t.column :person_id, :integer, :null => false
      t.column :login, :string, :limit => 80, :null => false
      t.column :salted_password, :string, :limit => hash_length, :null => false
      t.column :admin, :boolean, :default => false, :null => false
      t.column :list_default_per_page, :integer, :default => 10, :null => false
      t.column :list_header_per_line, :integer, :default => 10, :null => false
      t.column :menu_history_max, :integer, :default => 10, :null => false
      t.column :salt, :string, :limit => hash_length, :null => false
      t.column :verified, :boolean, :default => false, :null => false
      t.column :security_token, :string, :limit => hash_length, :default => nil
      t.column :token_expiry, :datetime, :default => nil
      t.column :deleted, :boolean, :default => false, :null => false
      t.column :failed_login_count, :integer, :default => 0, :null => false
      t.column :password_updated_on, :string, :limit => 8
    end
    add_index :users, :login
  end

  def self.down
    remove_index :users, :login rescue nil
    drop_table :users
  end
end
