# -*- coding: utf-8 -*-

# 関連文書を自動登録するモデルのためのオブザーバー
class AutoDocumentObserver

  def after_create(record)
    relatable_type = record.class.to_s
    relatable_product = Product.find(:first, :conditions => {:model_name => relatable_type})
    return unless relatable_product
    auto_document = AutoDocument.find(:first, :conditions => {:relatable_product_id => relatable_product.id})
    target_product = auto_document.target_product
    return unless target_product
    Document.create(:domain_id            => record.domain_id,
                    :relatable_id         => record.id,
                    :relatable_type       => relatable_type,
                    :relatable_product_id => relatable_product.id,
                    :target_id            => record.__send__(auto_document.target_id_method),
                    :target_type          => target_product.model_name,
                    :target_product_id    => target_product.id,
                    :mutual               => false)
  end

  def before_destroy(record)
    conditions = {
      :relatable_id   => record.id,
      :relatable_type => record.class.to_s,
    }
    Document.destroy_all(conditions)
  end

end
