# -*- coding: utf-8 -*-
# パーミッションを展開するためのオブザーバ
class PermissionObserver

  def after_create(record)
    c_table_name = record.roleable_type.constantize.table_name
    case c_table_name
    when "people"
      person = record.roleable
      if person
        user = person.user
        if user
          Permission.create_with_grant_on_and_user_id_and_priority(record, user.id, Membership::PRIORITY_PERSON)
        end
      end
    when "domains"
      record.roleable.people.each do |person|
        user = person.user
        if user
          Permission.create_with_grant_on_and_user_id_and_priority(record, user.id, Membership::PRIORITY_DOMAIN)
        end
      end
    when "companies", "organizations", "groups"
      c_member_class = "#{c_table_name.classify}Member".constantize
      c_condition = <<-"SQL", __FILE__, __LINE__
        #{c_table_name.singularize}_id = '#{record.roleable_id}' AND
        ((inception <= '#{record.inception}' AND '#{record.inception}' <= expiry) OR
         (inception <= '#{record.expiry}' AND '#{record.expiry}' <= expiry))
      SQL
      c_member_class.find_with_period(:all, :conditions => c_condition).each do |membership|
        person = membership.person
        if person
          user = person.user
          if user
            Permission.create_with_grant_on_and_user_id_and_priority(record,
                                                                     user.id,
                                                                     "Membership::PRIORITY_#{c_table_name.singularize.upcase}".constantize,
                                                                     membership.inception,
                                                                     membership.expiry)
          end
        end
      end
    else
      raise ArgumentError, "Unknown roleable type: #{record.roleable_type}"
    end
  end

  def after_update(record)
    after_destroy(record)
    after_create(record)
  end

  def after_destroy(record)
    Permission.find_with_period(:all, :conditions => {:grant_on_id => record.id}).each(&:destroy)
  end

end
