require "config/initializers/app"

desc 'The Database is merged by using the CSV file.'
namespace :db do
  namespace :pjc do
    task :merge => :environment do
      path = ENV['FIXTURE_DIR'] || "#{RAILS_ROOT}/pjc_merge"
      pass_column = %w(id created_at updated_at created_by updated_by created_in updated_in lock_version parent_id lft rgt)
      ActiveRecord::Base.establish_connection(RAILS_ENV.to_sym)
      ActiveRecord::Base.transaction do
        p "create po_messages"
        row_cnt = 0
        column_names = []
        map_po_messages = {}
        CSV.open("#{path}/po_messages.csv",'r') {|row|
          if row_cnt == 0
            column_names = row
          else
            m = MergeMessage.new
            row.each_with_index do |value,idx|
              if pass_column.index(column_names[idx]) == nil
                m.__send__("#{column_names[idx]}=",value)
              end
            end
            m.save!
            map_po_messages[row[0]] = m.id
          end
          row_cnt += 1
        }

        p "create po_translations"
        row_cnt = 0
        column_names = []
        #type_index = 0
        CSV.open("#{path}/po_translations.csv",'r') {|row|
          if row_cnt == 0
            column_names = row
            #type_index = column_names.index("type")
          else
            #m = row[type_index].constantize.new
            m = MergeTranslation.new
            row.each_with_index do |value,idx|
              if pass_column.index(column_names[idx]) == nil
                if column_names[idx] == "po_message_id"
                  value = map_po_messages[value]
                end
                if column_names[idx] == "type"
                  m.type= value
                else
                  m.__send__("#{column_names[idx]}=",value)
                end
              end
            end
            m.save!
          end
          row_cnt += 1
        }

        p "create products"
        row_cnt = 0
        column_names = []
        map_products = {}
        CSV.open("#{path}/products.csv",'r') {|row|
          if row_cnt == 0
            column_names = row
          else
            m = MergeProduct.new
            row.each_with_index do |value,idx|
              if pass_column.index(column_names[idx]) == nil
                if column_names[idx] == "name_po"
                  value = map_po_messages[value]
                end
                m.__send__("#{column_names[idx]}=",value)
              end
            end
            m.save!
            map_products[row[0]] = m.id
            m.motion = "controller=product/product_id=#{m.id}/action=list"
            m.save!
            mm = MergeMessage.find(m.name_po)
            mm.msgid = "Product|#{m.id}|name|"
            mm.save!
            root = MergeProduct.find_by_domain_id_and_type(m.domain_id,"ProductRoot")
            root.add_child(m)
          end
          row_cnt += 1
        }

        p "create menus"
        row_cnt = 0
        column_names = []
        CSV.open("#{path}/menus.csv",'r') {|row|
          if row_cnt == 0
            column_names = row
          else
            m = MergeMenu.new
            row.each_with_index do |value,idx|
              if pass_column.index(column_names[idx]) == nil
                if column_names[idx] == "product_id"
                  value = map_products[value]
                end
                if column_names[idx] == "name_po"
                  value = map_po_messages[value]
                end
                m.__send__("#{column_names[idx]}=",value)
              end
            end
            m.save!
            m.motion = "controller=product/product_id=#{m.product_id}/action=list"
            m.save!
            mm = MergeMessage.find(m.name_po)
            mm.msgid = "Menu|#{m.id}|name|"
            mm.save!
            root = MergeMenu.find_by_domain_id_and_code(m.domain_id,"ROOT")
            root.add_child(m)
          end
          row_cnt += 1
        }


        p "create displays"
        row_cnt = 0
        column_names = []
        map_displays = {}
        CSV.open("#{path}/displays.csv",'r') {|row|
          if row_cnt == 0
            column_names = row
          else
            m = MergeDisplay.new
            row.each_with_index do |value,idx|
              if pass_column.index(column_names[idx]) == nil
                if column_names[idx] == "product_id"
                  value = map_products[value]
                end
                if column_names[idx] == "name_po"
                  value = map_po_messages[value]
                end
                m.__send__("#{column_names[idx]}=",value)
              end
            end
            m.save!
            map_displays[row[0]] = m.id
            mm = MergeMessage.find(m.name_po)
            mm.msgid = "Display|#{m.id}|name|"
            mm.save!
          end
          row_cnt += 1
        }

        p "create items"
        row_cnt = 0
        column_names = []
        CSV.open("#{path}/items.csv",'r') {|row|
          if row_cnt == 0
            column_names = row
          else
            m = MergeItem.new
            row.each_with_index do |value,idx|
              if pass_column.index(column_names[idx]) == nil
                if column_names[idx] == "display_id"
                  value = map_displays[value]
                end
                if column_names[idx] == "name_po"
                  value = map_po_messages[value]
                end
                m.__send__("#{column_names[idx]}=",value)
              end
            end
            m.save!
          end
          row_cnt += 1
        }
        #create table informatinons
        merge_table(path,pass_column)
      end
    end
    task :dump => :environment do
      p "dump start (PRODUCT_ID=#{ENV['PRODUCT_ID']}) "
      path = ENV['FIXTURE_DIR'] || "#{RAILS_ROOT}/pjc_merge"
      p "products"
      name_po_ids = []

      products_column_names = MergeProduct.column_names
      product_row =[]
      product_row << products_column_names
      product = MergeProduct.find(ENV['PRODUCT_ID'].to_i)
      row = []
      name_po_ids << product.name_po
      products_column_names.each do |column_name|
        row << product.__send__(column_name)
      end
      product_row << row
      to_csv("#{path}/products.csv",product_row)

      #dump table informations
      dump_table([product.table_name,product.detail_table_name])

      p "menus"
      menus_column_names = MergeMenu.column_names
      menu_row =[]
      menu_row << menus_column_names
      menu = MergeMenu.find_by_product_id(ENV['PRODUCT_ID'].to_i)
      row = []
      name_po_ids << menu.name_po
      menus_column_names.each do |column_name|
        row << menu.__send__(column_name)
      end
      to_csv("#{path}/menus.csv",menu_row)

      p "displays & items"
      displays_column_names = MergeDisplay.column_names
      display_row =[]
      display_row << displays_column_names
      items_column_names = MergeItem.column_names
      item_row =[]
      item_row << items_column_names
      MergeDisplay.find_all_by_product_id(product.id).each do |display|
        row_d = []
        name_po_ids << display.name_po
        displays_column_names.each do |column_name|
          row_d << display.__send__(column_name)
        end
        display_row << row_d

        MergeItem.find_all_by_display_id(display.id).each do |item|
          row_i = []
          name_po_ids << item.name_po
          items_column_names.each do |column_name|
            row_i << item.__send__(column_name)
          end
          item_row << row_i
        end
      end
      to_csv("#{path}/displays.csv",display_row)
      to_csv("#{path}/items.csv",item_row)

      p "po_messages"
      po_messages_column_names = MergeMessage.column_names
      po_message_row = []
      po_message_row << po_messages_column_names
      MergeMessage.find(:all,:conditions=>{:id =>name_po_ids}).each do |po_message|
        row = []
        po_messages_column_names.each do |column_name|
            row << po_message.__send__(column_name)
        end
        po_message_row << row
      end
      MergeMessage.find(:all ,:conditions=>"msgid like '#{product.model_name}%'").each do |po_message|
        row = []
        name_po_ids << po_message.id
        po_messages_column_names.each do |column_name|
            row << po_message.__send__(column_name)
        end
        po_message_row << row
      end
      to_csv("#{path}/po_messages.csv",po_message_row)

      p "po_translations"
      po_translations_column_names = MergeTranslation.column_names
      po_translation_row = []
      po_translation_row << po_translations_column_names
      MergeTranslation.find_all_by_po_message_id(name_po_ids).each do |po_translation|
        row = []
        po_translations_column_names.each do |column_name|
            row << po_translation.__send__(column_name)
        end
        po_translation_row << row
      end
      to_csv("#{path}/po_translations.csv",po_translation_row)
      p "dump end (PRODUCT_ID=#{ENV['PRODUCT_ID']}) "
    end

    task :merge_table => :environment do
      path = ENV['FIXTURE_DIR'] || "#{RAILS_ROOT}/pjc_merge"
      pass_column = %w(id created_at updated_at created_by updated_by created_in updated_in lock_version parent_id lft rgt)
      ActiveRecord::Base.establish_connection(RAILS_ENV.to_sym)
      ActiveRecord::Base.transaction do
        merge_table(path,pass_column)
      end
    end

    task :table => :environment do
      path = ENV['FIXTURE_DIR'] || "#{RAILS_ROOT}/pjc_merge"
      tbls = ENV['TABLE'].split(/,/)
      dump_table(tbls)
    end

    task :remove => :environment do
      path = ENV['FIXTURE_DIR'] || "#{RAILS_ROOT}/pjc_merge"
      ActiveRecord::Base.establish_connection(RAILS_ENV.to_sym)
      ActiveRecord::Base.transaction do
        product = Product.find(ENV['PRODUCT_ID'].to_i)
        product.displays.each do |display|
          items = display.items
          Item.delete(items.id)
          Display.delete(display.id)
        end
        Product.delete(product.id)
        Menu.delete_all("product_id = #{ENV['PRODUCT_ID']}")
      end
    end
    
    task :update_msgs => :environment do
      puts "begins."
      ActiveRecord::Base.transaction do
        ms = PoMessageSingular.all(:conditions => ["msgid like ?", "Item|Pjc%"])
        mss = ms.select{|m| m.msgid.split('|').size == 3 }
        mss.each do |m|
          _, a, b = m.msgid.split('|')
          m.update_attributes(:msgid => "#{a}|#{b.humanize}")
        end
      end
      puts "ended."
    end

    task :create_msgs => :environment do
      puts "The registration processing of translation information begins."
      ActiveRecord::Base.transaction do
        CSV.open("#{RAILS_ROOT}/locale/#{ENV['FILE']}",'r', "\t") {|row|
          po_message_id = row[0]
          p po_message_id
          po_msg(po_message_id , row)
        }
      end
      puts "The registration processing of translation information was ended."
    end

    task :garbage_msgs => :environment do
      puts "The registration processing of translation information begins."
      ActiveRecord::Base.transaction do

        # po_messagesテーブルの中で、
        # 下記のテーブルで利用されていない翻訳情報を全て削除する。
        # menus
        # products
        # displays
        # items
        # input_options
        # pj_input_options
        # languages
        # po_translations

        name_pos = []
        #翻訳情報を利用しているテーブルからpomessages.idを全て取得する。
        name_pos << Menu.find(:all).map(&:name_po)
        name_pos << Product.find(:all).map(&:name_po)
        name_pos << Display.find(:all).map(&:name_po)
        name_pos << Item.find(:all).map(&:name_po)
        name_pos << InputOption.find(:all).map(&:name_po)
        name_pos << Language.find(:all).map(&:name_po)
        name_pos << PjInputOption.find(:all).map(&:name_po)
        name_pos << PoTranslation.find(:all).map(&:po_message_id)

        #po_translationsテーブルを追記しているので重複しているidを削除する。- (1)
        name_pos.uniq!

        #翻訳情報のidを全て取得する。- (2)
        message_ids = PoMessage.find(:all).map(&:id)

        #(1)と(2)の差分を求める（利用されていないid)
        delete_ids = message_ids - name_pos

        #不要なデータを全て削除する。（無用なコールバックが発生しないようにdelete_allで実施）
        PoTranslation.delete_all(:conditions=>{:po_message_id => delete_ids})
        PoMessage.delete_all(:conditions=>{:id => delete_ids})
      end
      puts "The registration processing of translation information was ended."
    end

    private

    def merge_table(path,pass_column)
      p "create application_tables"
      row_cnt = 0
      column_names = []
      map_tlb ={}
      CSV.open("#{path}/application_tables.csv",'r') {|row|
        if row_cnt == 0
          column_names = row
        else
          m = ApplicationTable.new
          row.each_with_index do |value,idx|
            if pass_column.index(column_names[idx]) == nil
              m.__send__("#{column_names[idx]}=",value)
            end
          end
          m.save!
          map_tlb[row[0]] = m.id
        end
        row_cnt += 1
      }
      p "create table_columns"
      row_cnt = 0
      column_names = []
      CSV.open("#{path}/table_columns.csv",'r') {|row|
        if row_cnt == 0
          column_names = row
          #type_index = column_names.index("type")
        else
          #m = row[type_index].constantize.new
          m = TableColumn.new
          row.each_with_index do |value,idx|
            if pass_column.index(column_names[idx]) == nil
              if column_names[idx] == "table_id"
                value = map_tlb[value]
              end
              m.__send__("#{column_names[idx]}=",value)
            end
          end
          m.save!
        end
        row_cnt += 1
      }
      p "create application_models"
      row_cnt = 0
      column_names = []
      map_mdl ={}
      CSV.open("#{path}/application_models.csv",'r') {|row|
        if row_cnt == 0
          column_names = row
          #type_index = column_names.index("type")
        else
          #m = row[type_index].constantize.new
          m = ApplicationModel.new
          row.each_with_index do |value,idx|
            if pass_column.index(column_names[idx]) == nil
              if column_names[idx] == "table_id"
                value = map_tlb[value]
              end
              m.__send__("#{column_names[idx]}=",value)
            end
          end
          m.save!
          map_mdl[row[0]] = m.id
        end
        row_cnt += 1
      }

      p "create belongs_tos"
      row_cnt = 0
      column_names = []
      CSV.open("#{path}/belongs_tos.csv",'r') {|row|
        if row_cnt == 0
          column_names = row
          #type_index = column_names.index("type")
        else
          #m = row[type_index].constantize.new
          m = BelongsTo.new
          row.each_with_index do |value,idx|
            if pass_column.index(column_names[idx]) == nil
              if column_names[idx] == "table_id"
                value = map_tlb[value]
              end
              m.__send__("#{column_names[idx]}=",value)
            end
          end
          m.save!
        end
        row_cnt += 1
      }
      p "create has_manies"
      row_cnt = 0
      column_names = []
      CSV.open("#{path}/has_manies.csv",'r') {|row|
        if row_cnt == 0
          column_names = row
          #type_index = column_names.index("type")
        else
          #m = row[type_index].constantize.new
          m = HasMany.new
          row.each_with_index do |value,idx|
            if pass_column.index(column_names[idx]) == nil
              if column_names[idx] == "table_id"
                value = map_mdl[value]
              end
              m.__send__("#{column_names[idx]}=",value)
            end
          end
          m.save!
        end
        row_cnt += 1
      }
    end

    def dump_table(tbls)
      path = ENV['FIXTURE_DIR'] || "#{RAILS_ROOT}/pjc_merge"
      p "application_tables"
      tbl_ids = []
      tbl_column_names = ApplicationTable.column_names
      tbl_row =[]
      tbl_row << tbl_column_names
      tbls.each do |tbl_name|
        if tbl_name && tbl_name != ""
          tbl = ApplicationTable.find_by_name(tbl_name)
          tbl_ids << tbl.id
          row = []
          tbl_column_names.each do |column_name|
            row << tbl.__send__(column_name)
          end
          tbl_row << row
        end
      end
      to_csv("#{path}/application_tables.csv",tbl_row)

      p "table_columns"
      clm_column_names = TableColumn.column_names
      model_names = ApplicationModel.column_names
      belongs_names = BelongsTo.column_names
      clm_row =[]
      mdl_row =[]
      blt_row = []
      clm_row << clm_column_names
      mdl_row << model_names
      blt_row << belongs_names
      mdl_ids =[]
      tbl_ids.each do |tbl_id|
        TableColumn.find_all_by_table_id(tbl_id).each do |clm|
          row_1 = []
          clm_column_names.each do |column_name|
            row_1 << clm.__send__(column_name)
          end
          clm_row << row_1
        end
        ApplicationModel.find_all_by_application_table_id(tbl_id).each do |mdl|
          mdl_ids << mdl.id
          row_2 = []
          model_names.each do |column_name|
            row_2 << mdl.__send__(column_name)
          end
          mdl_row << row_2
        end
        BelongsTo.find_all_by_application_table_id(tbl_id).each do |mdl|
          row_3 = []
          belongs_names.each do |column_name|
            row_3 << mdl.__send__(column_name)
          end
          blt_row << row_3
        end
      end
      to_csv("#{path}/table_columns.csv",clm_row)
      to_csv("#{path}/application_models.csv",mdl_row)
      to_csv("#{path}/belongs_tos.csv",blt_row)  
      
      has_many_names = HasMany.column_names
      hm_row =[]
      hm_row << has_many_names
      mdl_ids.each do |mdl_id|
        HasMany.find_all_by_application_model_id(mdl_id).each do |hm|
          row_4 = []
          has_many_names.each do |column_name|
            row_4 << hm.__send__(column_name)
          end
          hm_row << row_4
        end
      end
     to_csv("#{path}/has_manies.csv",hm_row)
    end

    def to_csv(path,lines)
      CSV.generate(path, ?,) { |wr|
        lines.each do|l|
        wr << l
        end
      }
    end

  def po_msg(id,row)
#    row = row.split(/,/)

    # added newly msgid.
    msg = PoMessage.new
    msg.domain_id = 1
    msg.type = "PoMessageSingular"
    msg.msgid = "#{id}"
    # msg.msgid = id
    msg.save!
    i=1

    ["Ja","Zh","Ko","En","Fr","Es","Ar","Pt","De","Ru"].each do |names|
      trs_class = "PoTranslation#{names}".constantize
      trs = trs_class.new
      trs.domain_id = 1
      trs.type = "PoTranslation#{names}"
      trs.po_message_id = msg.id
      trs.msgstr = row[i]
      trs.save!
      i += 1
    end
  end


  end
end