# Put your code that runs your task inside the do_work method it will be
# run automatically in a thread. You have access to all of your rails
# models.  You also get logger and results method inside of this class
# by default.
class MailSenderWorker < BackgrounDRb::Worker::RailsBase
  HTTP_REQUEST_HOST = "localhost"
  HTTP_REQUEST_PORT = 3000

  # Worker としての既定のエントリポイント
  # usage:
  #   MiddleMan.new_worker(:class => :mail_sender_worker, :args => {:post => [queue.id, path]})
  # or
  #   MiddleMan.new_worker(:class => :mail_sender_worker, :args => {:deliver => [mail_history_1.id, mail_history_2.id]})
  def do_work(args)
    # This method is called in it's own new thread when you
    # call new worker. args is set to :args
    if args.key?(:post)
      unless post(*args[:post])
        logger.error("ERROR: MailSenderWorker: no mail delivered")
      end
      return
    elsif args.key?(:deliver)
      args[:deliver].each do |mail_history_id|
        deliver(mail_history_id)
      end
    end
  end

  # メールキューから取り出し配送に回す。
  def post(mail_queue_id, path)
    queue = MailQueue.find(mail_queue_id, :include => [ :product, :from ])
    if queue.processed?
      logger.warn { "WARN: MailQueue #{queue.id} was already processed." }
      return false
    end
    require "net/http"
    http = Net::HTTP.new(HTTP_REQUEST_HOST, HTTP_REQUEST_PORT)
    req = Net::HTTP::Get.new(path)
    res = http.request(req)
    return res
  end

  # メール履歴から取り出し配送に回す。
  def deliver(mail_history_id)
    if mail_history = MailHistory.find(mail_history_id)
      return mail_history.deliver
    end
  end
end
MailSenderWorker.register
